/*
 * Decompiled with CFR 0.152.
 */
package filius;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.LanguageSelectionDialog;
import filius.gui.SplashScreen;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.FiliusArgs;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.IconMode;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements I18n {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void starten(String szenarioDatei) {
        LOG.debug("starten(" + szenarioDatei + ")");
        try {
            Information.getInformation().loadIni();
        }
        catch (IOException e1) {
            LOG.warn("ini could not be read: " + e1.getMessage());
        }
        String konfigPfad = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
        String lastSzenarioDatei = null;
        String editedSzenarioDatei = null;
        if (!new File(konfigPfad).exists() && null == Information.getInformation().getLocale()) {
            LanguageSelectionDialog.selectLanguage(false);
        } else {
            try {
                XMLDecoder xmldec = new XMLDecoder(new BufferedInputStream(Files.newInputStream(Paths.get(konfigPfad, new String[0]), new OpenOption[0])));
                Object[] programmKonfig = (Object[])xmldec.readObject();
                if (programmKonfig != null) {
                    if (programmKonfig.length >= 4) {
                        JMainFrame.getJMainFrame().setBounds((Rectangle)programmKonfig[0]);
                        lastSzenarioDatei = (String)programmKonfig[1];
                        if (programmKonfig[2] != null && programmKonfig[3] != null && null == Information.getInformation().getLocale()) {
                            Information.getInformation().setLocale(new Locale((String)programmKonfig[2], (String)programmKonfig[3]));
                        }
                    }
                    if (programmKonfig.length >= 5) {
                        Information.getInformation().setLastOpenedDirectory((String)programmKonfig[4]);
                    }
                    if (programmKonfig.length >= 6 && ((Boolean)programmKonfig[5]).booleanValue()) {
                        editedSzenarioDatei = Information.getInformation().getArbeitsbereichPfad() + "edited_scenario.fls";
                    }
                    if (programmKonfig.length >= 7) {
                        if (StringUtils.equals(programmKonfig[6].toString(), IconMode.ENTERPRISE.toString())) {
                            Information.getInformation().setIconMode(IconMode.ENTERPRISE);
                        } else if (StringUtils.equals(programmKonfig[6].toString(), IconMode.SYMBOL.toString())) {
                            Information.getInformation().setIconMode(IconMode.SYMBOL);
                        }
                    }
                    if (programmKonfig.length >= 8 && ((Boolean)programmKonfig[7]).booleanValue()) {
                        Information.getInformation().setLayerVisualization((Boolean)programmKonfig[7]);
                    }
                }
            }
            catch (Exception e) {
                LOG.info("There is no user configuration available.");
            }
        }
        UIManager.put("OptionPane.cancelButtonText", messages.getString("main_dlg_CANCEL"));
        UIManager.put("OptionPane.noButtonText", messages.getString("main_dlg_NO"));
        UIManager.put("OptionPane.okButtonText", messages.getString("main_dlg_OK"));
        UIManager.put("OptionPane.yesButtonText", messages.getString("main_dlg_YES"));
        SplashScreen splashScreen = new SplashScreen("gfx/allgemein/splashscreen.png", null);
        splashScreen.setVisible(true);
        splashScreen.setAlwaysOnTop(true);
        long splashTime = System.currentTimeMillis();
        try {
            if (null != szenarioDatei) {
                SzenarioVerwaltung.getInstance().laden(szenarioDatei, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
            } else if (null != editedSzenarioDatei) {
                SzenarioVerwaltung.getInstance().laden(editedSzenarioDatei, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
                SzenarioVerwaltung.getInstance().setCurrentFile(lastSzenarioDatei, true);
            } else if (null != lastSzenarioDatei) {
                SzenarioVerwaltung.getInstance().laden(lastSzenarioDatei, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
        }
        GUIContainer.getGUIContainer().setProperty(null);
        GUIContainer.getGUIContainer().updateViewport();
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            LOG.error("Caught an unexpected exception.", exception);
        }
        GUIContainer.getGUIContainer().updateCables();
        splashTime = System.currentTimeMillis() - splashTime;
        LOG.debug("Splash Screen shown for " + splashTime + " ms");
        if (splashTime < 1000L) {
            try {
                Thread.sleep(1000L - splashTime);
            }
            catch (Exception exception) {
                LOG.error("Caught an unexpected exception.", exception);
            }
        }
        splashScreen.setAlwaysOnTop(false);
        splashScreen.setVisible(false);
    }

    public static void beenden() {
        LOG.debug("beenden");
        boolean abbruch = false;
        GUIContainer.getGUIContainer().getMenu().selectMode(1);
        if (SzenarioVerwaltung.getInstance().istGeaendert()) {
            SzenarioVerwaltung.getInstance().speichern(Information.getInformation().getArbeitsbereichPfad() + "edited_scenario.fls", GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
        }
        if (!abbruch) {
            Object[] programmKonfig = new Object[]{JMainFrame.getJMainFrame().getBounds(), SzenarioVerwaltung.getInstance().holePfad(), Information.getInformation().getLocale().getLanguage(), Information.getInformation().getLocale().getCountry(), Information.getInformation().getLastOpenedDirectory(), SzenarioVerwaltung.getInstance().istGeaendert(), Information.getInformation().getIconMode().toString(), Information.getInformation().isLayerVisualization()};
            String applicationConfigPath = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
            try (FileOutputStream fos = new FileOutputStream(applicationConfigPath);
                 XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(fos));){
                encoder.writeObject(programmKonfig);
            }
            catch (Exception e) {
                LOG.debug("", e);
            }
            SzenarioVerwaltung.loescheVerzeichnisInhalt(Information.getInformation().getTempPfad());
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        FiliusArgs filiusArgs = new FiliusArgs();
        try {
            filiusArgs.parseCommandLine(args);
            if (filiusArgs.currWD.isEmpty() || !filiusArgs.currWD.substring(filiusArgs.currWD.length() - 1).equals(System.getProperty("file.separator"))) {
                if (Information.getInformation(filiusArgs.currWD + System.getProperty("file.separator")) == null) {
                    System.exit(6);
                } else if (Information.getInformation(filiusArgs.currWD) == null) {
                    System.exit(6);
                }
            }
            if (filiusArgs.log) {
                System.setProperty("FILIUS_LOG_LEVEL", "DEBUG");
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.reset();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(loggerContext);
                try {
                    configurator.doConfigure(configurator.getClass().getResourceAsStream("/logback.xml"));
                    LOG.info("Log to file enabled.");
                }
                catch (JoranException exception) {
                    LOG.error("Caught an unexpected error while trying to load the logback configuration file..", exception);
                }
            }
            if (Information.getInformation(filiusArgs.currWD) == null) {
                System.exit(6);
            }
            Verbindung.setRTTfactor(filiusArgs.rtt);
            Information.setLowResolution(filiusArgs.lowResolution);
            if (filiusArgs.nativeLookAndFeel) {
                Main.activateNativeLookAndFeel();
            }
            if (filiusArgs.help) {
                filiusArgs.showUsageInformation();
            } else {
                Main.starten(filiusArgs.projectFile);
            }
        }
        catch (ParseException e) {
            filiusArgs.showUsageInformation();
        }
        LOG.info("------------------------------------------------------");
        LOG.info("\tJava Version: " + System.getProperty("java.version"));
        LOG.info("\tJava Directory: " + System.getProperty("java.home"));
        LOG.info("\tFILIUS Version: " + Information.getVersion());
        LOG.info("\tParameters: '" + filiusArgs.argsString.trim() + "'");
        LOG.info("\tFILIUS Installation: " + Information.getInformation().getProgrammPfad());
        LOG.info("\tFILIUS Working Directory: " + Information.getInformation().getArbeitsbereichPfad());
        LOG.info("\tFILIUS Temp Directory: " + Information.getInformation().getTempPfad());
        LOG.info("------------------------------------------------------\n");
    }

    public static void activateNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
            LOG.warn("Native look and feel not supported. Using default look and feel.");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("LookAndFeel class could not be found. Using default look and feel.");
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Could not instantiate LookAndFeel. Using default look and feel.");
        }
    }
}

