/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.GUIContainer;
import filius.gui.InfoDialog;
import filius.gui.JBackgroundPanel;
import filius.gui.JMainFrame;
import filius.gui.LanguageSelectionDialog;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JGatewayConfiguration;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.gui.quelltextsicht.FrameSoftwareWizard;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.software.system.SystemSoftware;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.nio.file.Path;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIMainMenu
implements Serializable,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(GUIMainMenu.class);
    private static final long serialVersionUID = 1L;
    public static final int MODUS_ENTWURF = 1;
    public static final int MODUS_AKTION = 2;
    public static final int MODUS_DOKUMENTATION = 3;
    private JBackgroundPanel menupanel;
    private JSlider simulationSpeedInPercent;
    private JLabel geschwindigkeit;
    private int aktuellerModus;
    private JButton btAktionsmodus;
    private JButton btEntwurfsmodus;
    private JButton btDokumodus;
    private JButton btOeffnen;
    private JButton btSpeichern;
    private JButton btNeu;
    private JButton btWizard;
    private JButton btHilfe;
    private JButton btInfo;
    private JButton btSettings;

    public GUIMainMenu() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIMainMenu), constr: GUIMainMenu()");
        Container c = JMainFrame.getJMainFrame().getContentPane();
        this.menupanel = new JBackgroundPanel();
        this.menupanel.setPreferredSize(new Dimension(100, 63));
        this.menupanel.setBounds(0, 0, c.getWidth(), 65);
        this.menupanel.setEnabled(false);
        this.menupanel.setBackgroundImage("gfx/allgemein/menue_hg.png");
        this.btNeu = new JButton();
        this.btNeu.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/neu.png")));
        this.btNeu.setBounds(10, 5, this.btNeu.getIcon().getIconWidth(), this.btNeu.getIcon().getIconHeight());
        this.btNeu.setActionCommand("neu");
        this.btNeu.setToolTipText(messages.getString("guimainmemu_msg5"));
        this.btOeffnen = new JButton();
        this.btOeffnen.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/oeffnen.png")));
        this.btOeffnen.setBounds(80, 5, this.btOeffnen.getIcon().getIconWidth(), this.btOeffnen.getIcon().getIconHeight());
        this.btOeffnen.setActionCommand("oeffnen");
        this.btOeffnen.setToolTipText(messages.getString("guimainmemu_msg1"));
        this.btSpeichern = new JButton();
        this.btSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/speichern.png")));
        this.btSpeichern.setBounds(150, 5, this.btSpeichern.getIcon().getIconWidth(), this.btSpeichern.getIcon().getIconHeight());
        this.btSpeichern.setActionCommand("speichern");
        this.btSpeichern.setToolTipText(messages.getString("guimainmemu_msg2"));
        this.btDokumodus = new JButton();
        this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
        this.btDokumodus.setBounds(250, 5, this.btDokumodus.getIcon().getIconWidth(), this.btDokumodus.getIcon().getIconHeight());
        this.btDokumodus.setActionCommand("dokumodus");
        this.btDokumodus.setToolTipText(messages.getString("guimainmemu_msg14"));
        this.btEntwurfsmodus = new JButton();
        this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus_aktiv.png")));
        this.btEntwurfsmodus.setBounds(350, 5, this.btEntwurfsmodus.getIcon().getIconWidth(), this.btEntwurfsmodus.getIcon().getIconHeight());
        this.btEntwurfsmodus.setActionCommand("entwurfsmodus");
        this.btEntwurfsmodus.setToolTipText(messages.getString("guimainmemu_msg3"));
        this.btAktionsmodus = new JButton();
        this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
        this.btAktionsmodus.setBounds(420, 5, this.btAktionsmodus.getIcon().getIconWidth(), this.btAktionsmodus.getIcon().getIconHeight());
        this.btAktionsmodus.setActionCommand("aktionsmodus");
        this.btAktionsmodus.setToolTipText(messages.getString("guimainmemu_msg4"));
        if (this.isSoftwareWizardEnabled()) {
            this.btWizard = new JButton();
            this.btWizard.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/button_wizard.png")));
            this.btWizard.setBounds(700, 5, this.btWizard.getIcon().getIconWidth(), this.btWizard.getIcon().getIconHeight());
            this.btWizard.setActionCommand("wizard");
            this.btWizard.setToolTipText(messages.getString("guimainmemu_msg6"));
        }
        this.btHilfe = new JButton();
        this.btHilfe.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/hilfe.png")));
        this.btHilfe.setBounds(800, 5, this.btHilfe.getIcon().getIconWidth(), this.btHilfe.getIcon().getIconHeight());
        this.btHilfe.setActionCommand("hilfe");
        this.btHilfe.setToolTipText(messages.getString("guimainmemu_msg7"));
        this.btInfo = new JButton();
        this.btInfo.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/info.png")));
        this.btInfo.setBounds(870, 5, this.btInfo.getIcon().getIconWidth(), this.btInfo.getIcon().getIconHeight());
        this.btInfo.setActionCommand("info");
        this.btInfo.setToolTipText(messages.getString("guimainmemu_msg8"));
        this.btSettings = new JButton();
        this.btSettings.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/settings.png")));
        this.btSettings.setBounds(940, 5, this.btInfo.getIcon().getIconWidth(), this.btInfo.getIcon().getIconHeight());
        this.btSettings.setActionCommand("settings");
        this.btSettings.setToolTipText(messages.getString("guimainmemu_msg18"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIMainMenu.this.isSoftwareWizardEnabled() && e.getActionCommand().equals(GUIMainMenu.this.btWizard.getActionCommand())) {
                    FrameSoftwareWizard gsw = new FrameSoftwareWizard();
                    gsw.setVisible(true);
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btHilfe.getActionCommand())) {
                    GUIContainer.getGUIContainer().showHelp();
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btNeu.getActionCommand())) {
                    GUIMainMenu.this.newScenario(e);
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btSpeichern.getActionCommand()) && GUIContainer.getGUIContainer().getActiveSite() != 2) {
                    GUIMainMenu.this.saveScenario();
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btOeffnen.getActionCommand())) {
                    GUIMainMenu.this.loadScenario();
                }
                if (e.getActionCommand().equals(GUIMainMenu.this.btEntwurfsmodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(1);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btAktionsmodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(2);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btDokumodus.getActionCommand())) {
                    GUIMainMenu.this.selectMode(3);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btInfo.getActionCommand())) {
                    new InfoDialog(JMainFrame.getJMainFrame()).setVisible(true);
                } else if (e.getActionCommand().equals(GUIMainMenu.this.btSettings.getActionCommand())) {
                    LanguageSelectionDialog.selectLanguage(true);
                }
            }
        };
        this.btNeu.addActionListener(al);
        this.btOeffnen.addActionListener(al);
        this.btSpeichern.addActionListener(al);
        this.btEntwurfsmodus.addActionListener(al);
        this.btAktionsmodus.addActionListener(al);
        this.btDokumodus.addActionListener(al);
        if (this.isSoftwareWizardEnabled()) {
            this.btWizard.addActionListener(al);
        }
        this.btInfo.addActionListener(al);
        this.btHilfe.addActionListener(al);
        this.btSettings.addActionListener(al);
        this.geschwindigkeit = new JLabel();
        this.geschwindigkeit.setVisible(true);
        this.geschwindigkeit.setToolTipText(messages.getString("guimainmemu_msg15"));
        this.geschwindigkeit.setAlignmentX(1.0f);
        this.geschwindigkeit.setBounds(612, 10, 50, 44);
        this.simulationSpeedInPercent = new JSlider(0, 100);
        this.simulationSpeedInPercent.setToolTipText(messages.getString("guimainmemu_msg16"));
        this.simulationSpeedInPercent.setMaximum(100);
        this.simulationSpeedInPercent.setMinimum(1);
        this.simulationSpeedInPercent.setValue(100 - Verbindung.holeVerzoegerungsFaktor());
        this.simulationSpeedInPercent.setBounds(510, 10, 100, 44);
        this.simulationSpeedInPercent.setOpaque(false);
        this.simulationSpeedInPercent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GUIMainMenu.this.updateLatency();
            }
        });
        this.updateLatency();
        this.menupanel.setLayout(null);
        this.menupanel.add(this.btEntwurfsmodus);
        this.menupanel.add(this.btAktionsmodus);
        this.menupanel.add(this.btDokumodus);
        this.menupanel.add(this.btNeu);
        this.menupanel.add(this.btOeffnen);
        this.menupanel.add(this.btSpeichern);
        this.menupanel.add(this.simulationSpeedInPercent);
        this.menupanel.add(this.geschwindigkeit);
        if (this.isSoftwareWizardEnabled()) {
            this.menupanel.add(this.btWizard);
        }
        this.menupanel.add(this.btHilfe);
        this.menupanel.add(this.btInfo);
        this.menupanel.add(this.btSettings);
    }

    private void updateLatency() {
        Verbindung.setzeVerzoegerungsFaktor(this.simulationSpeedInPercent.getMaximum() - this.simulationSpeedInPercent.getValue() + 1);
        this.geschwindigkeit.setText(this.simulationSpeedInPercent.getValue() + "%");
    }

    private void initCurrentFileOrDirSelection(FileDialog dialog) {
        String scenarioPath = SzenarioVerwaltung.getInstance().holePfad();
        String lastOpenedDir = Information.getInformation().getLastOpenedDirectory();
        File file = null;
        if (scenarioPath != null) {
            file = new File(scenarioPath);
        }
        if (null != file && file.exists()) {
            dialog.setFile(file.getAbsolutePath());
        } else if (null != lastOpenedDir && (file = new File(lastOpenedDir)).exists()) {
            dialog.setDirectory(file.getAbsolutePath());
        }
    }

    private boolean isSoftwareWizardEnabled() {
        return null != ToolProvider.getSystemJavaCompiler() && Information.getInformation().getSoftwareWizardMode() != Information.FeatureMode.FORCE_DISABLE || Information.getInformation().getSoftwareWizardMode() == Information.FeatureMode.FORCE_ENABLE;
    }

    public void changeSlider(int diff) {
        if (diff < 0 && this.simulationSpeedInPercent.getValue() + diff < 1) {
            this.simulationSpeedInPercent.setValue(1);
        } else if (diff > 0 && this.simulationSpeedInPercent.getValue() + diff > 10) {
            this.simulationSpeedInPercent.setValue(10);
        } else {
            this.simulationSpeedInPercent.setValue(this.simulationSpeedInPercent.getValue() + diff);
        }
    }

    public boolean doClick(String button) {
        if (button.equals("btAktionsmodus")) {
            this.btAktionsmodus.doClick();
        } else if (button.equals("btEntwurfsmodus")) {
            this.btEntwurfsmodus.doClick();
        } else if (button.equals("btDokumodus")) {
            this.btDokumodus.doClick();
        } else if (button.equals("btOeffnen")) {
            this.btOeffnen.doClick();
        } else if (button.equals("btSpeichern")) {
            this.btSpeichern.doClick();
        } else if (button.equals("btNeu")) {
            this.btNeu.doClick();
        } else if (button.equals("btWizard")) {
            this.btWizard.doClick();
        } else if (button.equals("btHilfe")) {
            this.btHilfe.doClick();
        } else if (button.equals("btInfo")) {
            this.btInfo.doClick();
        } else if (button.equals("btSettings")) {
            this.btSettings.doClick();
        } else {
            return false;
        }
        return true;
    }

    private void newScenario(ActionEvent e) {
        int entscheidung = 0;
        try {
            entscheidung = SzenarioVerwaltung.getInstance().istGeaendert() ? JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg9"), messages.getString("guimainmemu_msg10"), 0) : 0;
        }
        catch (Exception exc) {
            LOG.debug("", (Object)e);
        }
        if (entscheidung == 0) {
            GUIContainer.getGUIContainer().clearAllItems();
            GUIContainer.getGUIContainer().setProperty(null);
            Information.getInformation().reset();
            SzenarioVerwaltung.getInstance().reset();
        }
    }

    private void loadScenario() {
        int entscheidung = 0;
        try {
            entscheidung = SzenarioVerwaltung.getInstance().istGeaendert() ? JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg9"), messages.getString("guimainmemu_msg10"), 0) : 0;
        }
        catch (Exception exc) {
            LOG.debug("", exc);
        }
        if (entscheidung == 0 && GUIContainer.getGUIContainer().getActiveSite() != 2) {
            FileDialog fileDialog = new FileDialog((Frame)JMainFrame.getJMainFrame(), messages.getString("main_msg3"), 0);
            FilenameFilter filiusFilenameFilter = (dir, name) -> name.endsWith(".fls");
            fileDialog.setFilenameFilter(filiusFilenameFilter);
            this.initCurrentFileOrDirSelection(fileDialog);
            fileDialog.setVisible(true);
            String selectedFile = fileDialog.getFile();
            if (selectedFile != null) {
                Information.getInformation().setLastOpenedDirectory(fileDialog.getDirectory());
                try {
                    Path file = Path.of(fileDialog.getDirectory(), selectedFile);
                    Information.getInformation().reset();
                    SzenarioVerwaltung.getInstance().laden(file.toString(), GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
                    GUIContainer.getGUIContainer().setProperty(null);
                    GUIContainer.getGUIContainer().updateViewport();
                    Thread.sleep(10L);
                    GUIContainer.getGUIContainer().updateCables();
                }
                catch (FileNotFoundException e1) {
                    LOG.debug("Selected File could not be found.", e1);
                }
                catch (Exception e2) {
                    LOG.debug(e2.getMessage(), e2);
                }
            }
        }
    }

    private void saveScenario() {
        FileDialog fileDialog = new FileDialog((Frame)JMainFrame.getJMainFrame(), messages.getString("main_msg4"), 1);
        FilenameFilter filiusFilenameFilter = (dir, name) -> name.endsWith(".fls");
        fileDialog.setFilenameFilter(filiusFilenameFilter);
        this.initCurrentFileOrDirSelection(fileDialog);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String targetFilePath;
            Information.getInformation().setLastOpenedDirectory(fileDialog.getDirectory());
            boolean nameChanged = false;
            if (fileDialog.getFile().endsWith(".fls")) {
                targetFilePath = Path.of(fileDialog.getDirectory(), fileDialog.getFile()).toString();
            } else {
                nameChanged = true;
                targetFilePath = Path.of(fileDialog.getDirectory(), fileDialog.getFile() + ".fls").toString();
            }
            int entscheidung = 0;
            if (nameChanged && new File(targetFilePath).exists()) {
                entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg17"), messages.getString("guimainmemu_msg10"), 0);
            }
            if (entscheidung == 0) {
                boolean erfolg = SzenarioVerwaltung.getInstance().speichern(targetFilePath, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
                if (erfolg) {
                    SzenarioVerwaltung.getInstance().setCurrentFile(targetFilePath, false);
                } else {
                    JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg11"));
                }
            }
        }
    }

    private void resetCableHighlighting(int mode) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIMainMenu), resetCableHL(" + mode + ")");
        if (mode == 2) {
            for (GUIKabelItem cableItem : GUIContainer.getGUIContainer().getCableItems()) {
                cableItem.getDasKabel().setAktiv(false);
            }
        } else {
            if (GUIContainer.getGUIContainer().getProperty() instanceof JVermittlungsrechnerKonfiguration) {
                ((JVermittlungsrechnerKonfiguration)GUIContainer.getGUIContainer().getProperty()).highlightConnCable();
            }
            if (GUIContainer.getGUIContainer().getProperty() instanceof JGatewayConfiguration) {
                ((JGatewayConfiguration)GUIContainer.getGUIContainer().getProperty()).highlightConnCable();
            }
        }
    }

    public synchronized void selectMode(int mode) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIMainMenu), selectMode(" + mode + ")");
        if (mode == 1) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus_aktiv.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
            GUIContainer.getGUIContainer().setActiveSite(1);
            this.stopSimulation();
            this.btOeffnen.setEnabled(true);
            this.btNeu.setEnabled(true);
            this.btSpeichern.setEnabled(true);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(true);
            }
        } else if (mode == 3) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus_aktiv.png")));
            GUIContainer.getGUIContainer().setActiveSite(3);
            this.stopSimulation();
            this.btOeffnen.setEnabled(true);
            this.btNeu.setEnabled(true);
            this.btSpeichern.setEnabled(true);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(false);
            }
        } else if (mode == 2 && this.aktuellerModus != 2) {
            this.resetCableHighlighting(mode);
            this.btEntwurfsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/entwurfsmodus.png")));
            this.btAktionsmodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/aktionsmodus_aktiv.png")));
            this.btDokumodus.setIcon(new ImageIcon(this.getClass().getResource("/gfx/allgemein/dokumodus.png")));
            GUIContainer.getGUIContainer().setActiveSite(2);
            for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
                SystemSoftware system = knotenItem.getKnoten().getSystemSoftware();
                system.starten();
            }
            this.btOeffnen.setEnabled(false);
            this.btNeu.setEnabled(false);
            this.btSpeichern.setEnabled(false);
            if (this.isSoftwareWizardEnabled()) {
                this.btWizard.setEnabled(false);
            }
            this.geschwindigkeit.setEnabled(true);
            this.simulationSpeedInPercent.setEnabled(true);
        }
        this.aktuellerModus = mode;
    }

    private void stopSimulation() {
        for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
            SystemSoftware system = knotenItem.getKnoten().getSystemSoftware();
            try {
                system.beenden();
            }
            catch (Exception exception) {}
        }
    }

    public JBackgroundPanel getMenupanel() {
        return this.menupanel;
    }

    public void setMenupanel(JBackgroundPanel menupanel) {
        this.menupanel = menupanel;
    }
}

