/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.GUIEvents;
import filius.gui.JMarkerPanel;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMainFrame
extends JFrame
implements WindowListener,
Observer {
    private static Logger LOG = LoggerFactory.getLogger(JMainFrame.class);
    private static final long serialVersionUID = 1L;
    private static JMainFrame frame = null;

    private JMainFrame() {
        this.addWindowListener(this);
        SzenarioVerwaltung.getInstance().addObserver(this);
        this.initComponents();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && !(e.getSource() instanceof JTextField)) {
                    LOG.trace("KEY dispatcher:\n\tkey:'" + e.getKeyCode() + "'\n\tmodifier: '" + e.getModifiersEx() + "'\n\tmodifierText: '" + KeyEvent.getModifiersExText(e.getModifiersEx()) + "'\n\tkeyChar: '" + e.getKeyChar() + "'\n\tsourceType: '" + e.getSource().getClass().getSimpleName() + "'\n");
                    if (e.getKeyChar() == ' ' && e.getSource().getClass().getSimpleName() == "JButton") {
                        return true;
                    }
                    if (e.getKeyChar() == '\u007f' && frame.isFocused() && GUIContainer.getGUIContainer().getActiveSite() == 1) {
                        if (GUIContainer.getGUIContainer().isMarkerVisible()) {
                            List<GUIKnotenItem> itemlist = GUIContainer.getGUIContainer().getKnotenItems();
                            JMarkerPanel auswahl = GUIContainer.getGUIContainer().getAuswahl();
                            LinkedList<GUIKnotenItem> markedlist = new LinkedList<GUIKnotenItem>();
                            ListIterator<GUIKnotenItem> it = itemlist.listIterator();
                            while (it.hasNext()) {
                                GUIKnotenItem tempitem = it.next();
                                int tx = tempitem.getImageLabel().getX();
                                int twidth = tempitem.getImageLabel().getWidth();
                                int ty = tempitem.getImageLabel().getY();
                                int theight = tempitem.getImageLabel().getHeight();
                                int itemPosX = tx + twidth / 2;
                                int itemPosY = ty + theight / 2;
                                if (itemPosX < auswahl.getX() || itemPosX > auswahl.getX() + auswahl.getWidth() || itemPosY < auswahl.getY() || itemPosY > auswahl.getY() + auswahl.getHeight()) continue;
                                markedlist.add(tempitem);
                            }
                            for (int i = 0; i < markedlist.size(); ++i) {
                                GUIEvents.getGUIEvents().itemLoeschen(((GUIKnotenItem)markedlist.get(i)).getImageLabel(), (GUIKnotenItem)markedlist.get(i));
                            }
                            auswahl.setVisible(false);
                            GUIContainer.getGUIContainer().hideMarker();
                            return true;
                        }
                        if (GUIEvents.getGUIEvents().getActiveItem() != null) {
                            GUIEvents.getGUIEvents().itemLoeschen(GUIEvents.getGUIEvents().getActiveItem().getImageLabel(), GUIEvents.getGUIEvents().getActiveItem());
                            return true;
                        }
                    }
                    if ((e.getModifiersEx() & 0x80) == 128) {
                        switch (e.getKeyCode()) {
                            case 78: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btNeu");
                                return true;
                            }
                            case 79: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btOeffnen");
                                return true;
                            }
                            case 83: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btSpeichern");
                                return true;
                            }
                            case 68: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btEntwurfsmodus");
                                return true;
                            }
                            case 82: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btAktionsmodus");
                                return true;
                            }
                            case 37: {
                                GUIContainer.getGUIContainer().getMenu().changeSlider(-1);
                                return true;
                            }
                            case 39: {
                                GUIContainer.getGUIContainer().getMenu().changeSlider(1);
                                return true;
                            }
                            case 87: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btWizard");
                                return true;
                            }
                            case 72: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btHilfe");
                                return true;
                            }
                            case 73: {
                                GUIContainer.getGUIContainer().getMenu().doClick("btInfo");
                                return true;
                            }
                        }
                    }
                    if ((e.getModifiersEx() & 0x200) == 512 && e.getKeyCode() == 49 && GUIContainer.getGUIContainer().getActiveSite() == 1) {
                        JMainFrame.this.switchCablePreview();
                        return true;
                    }
                    if (e.getKeyCode() == 27) {
                        GUIEvents.getGUIEvents().resetAndHideCablePreview();
                    }
                }
                return false;
            }
        });
        this.aktualisiere();
    }

    public static JMainFrame getJMainFrame() {
        if (frame == null) {
            frame = new JMainFrame();
            Image image = Toolkit.getDefaultToolkit().getImage(JMainFrame.class.getResource("/gfx/hardware/kabel.png"));
            frame.setIconImage(image);
            frame.setLayout(new BorderLayout(0, 0));
        }
        return frame;
    }

    public void addToContentPane(Component comp, Object constraints) {
        if (comp != null) {
            this.getContentPane().add(comp, constraints);
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setDefaultBounds();
    }

    private void setDefaultBounds() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)Math.min(1020.0, 0.9 * screenSize.getWidth());
        int height = (int)Math.min(700.0, 0.9 * screenSize.getHeight());
        super.setBounds(new Rectangle(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2, width, height));
    }

    @Override
    public void setBounds(Rectangle newBounds) {
        boolean validBounds = false;
        for (GraphicsDevice screenDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = screenDevice.getDefaultConfiguration().getBounds();
            if (newBounds.x < bounds.x || newBounds.x + newBounds.width > bounds.x + bounds.width || newBounds.y < bounds.y || newBounds.y + newBounds.height > bounds.y + bounds.height) continue;
            validBounds = true;
            super.setBounds(newBounds);
            break;
        }
        if (!validBounds) {
            this.setDefaultBounds();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Main.beenden();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void aktualisiere() {
        Object dateipfad = SzenarioVerwaltung.getInstance().holePfad();
        if (dateipfad != null) {
            int startIndex = ((String)dateipfad).length() - 80;
            if (startIndex > 0) {
                dateipfad = ((String)dateipfad).substring(startIndex);
            }
            if (SzenarioVerwaltung.getInstance().istGeaendert()) {
                dateipfad = (String)dateipfad + "*";
            }
            this.setTitle("FILIUS - " + (String)dateipfad);
        } else {
            this.setTitle("FILIUS");
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.aktualisiere();
    }

    private void switchCablePreview() {
        if (GUIContainer.getGUIContainer().getKabelvorschau().isVisible()) {
            GUIEvents.getGUIEvents().resetAndHideCablePreview();
        } else {
            int currentPosX = (int)(MouseInfo.getPointerInfo().getLocation().getX() - GUIContainer.getGUIContainer().getDesignpanel().getLocationOnScreen().getX());
            int currentPosY = (int)(MouseInfo.getPointerInfo().getLocation().getY() - GUIContainer.getGUIContainer().getDesignpanel().getLocationOnScreen().getY());
            GUIEvents.getGUIEvents().resetAndShowCablePreview(currentPosX, currentPosY);
        }
    }

    public void removeFromContentPane(Component comp) {
        if (comp != null) {
            this.getContentPane().remove(comp);
        }
    }
}

