/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.Main;
import filius.gui.JMainFrame;
import filius.rahmenprogramm.IconMode;
import filius.rahmenprogramm.Information;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class LanguageSelectionDialog
extends JDialog {
    private static final String FRANCAIS = "Fran\u00e7ais";
    private static final String ENGLISH = "English";
    private static final String DEUTSCH = "Deutsch";
    private JLabel selectLanguageLabel = new JLabel();
    private JComboBox<String> languageSelection = new JComboBox();
    private JLabel selectIconModeLabel = new JLabel();
    private JComboBox<String> iconModeSelection = new JComboBox();
    private JCheckBox layerVisualization = new JCheckBox();
    private JLabel restartHint = new JLabel();
    private JButton confirm = new JButton();
    private JButton confirmAndExit = new JButton();
    private JButton cancel = new JButton();
    private Box buttonBox = Box.createHorizontalBox();

    private LanguageSelectionDialog(boolean restartMode) {
        super(restartMode ? JMainFrame.getJMainFrame() : null);
        this.setModal(true);
        Image image = Toolkit.getDefaultToolkit().getImage(LanguageSelectionDialog.class.getResource("/gfx/hardware/kabel.png"));
        this.setIconImage(image);
        if (restartMode) {
            this.setTitle("Einstellungen / Settings / Param\u00e8tres");
        } else {
            this.setTitle("Sprache / Language / Langue");
        }
        this.setResizable(false);
        this.initialize(restartMode);
        this.initializeText(Information.getInformation().getLocaleOrDefault());
        this.initializeSettings();
    }

    private void initializeSettings() {
        this.languageSelection.setSelectedItem(this.localeToLanguage(Information.getInformation().getLocaleOrDefault()));
        if (Information.getInformation().getIconMode() == IconMode.DEFAULT) {
            this.iconModeSelection.setSelectedIndex(0);
        } else if (Information.getInformation().getIconMode() == IconMode.ENTERPRISE) {
            this.iconModeSelection.setSelectedIndex(1);
        } else {
            this.iconModeSelection.setSelectedIndex(2);
        }
        this.layerVisualization.setSelected(Information.getInformation().isLayerVisualization());
    }

    private void initializeText(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("filius.messages.MessagesBundle", locale);
        this.selectLanguageLabel.setText(bundle.getString("languageSelection_msg1"));
        int selectedIndex = this.languageSelection.getSelectedIndex();
        this.languageSelection.removeAllItems();
        this.languageSelection.addItem(DEUTSCH);
        this.languageSelection.addItem(ENGLISH);
        this.languageSelection.addItem(FRANCAIS);
        this.languageSelection.setSelectedIndex(selectedIndex);
        this.selectIconModeLabel.setText(bundle.getString("settings_msg1"));
        selectedIndex = this.iconModeSelection.getSelectedIndex();
        this.iconModeSelection.removeAllItems();
        this.iconModeSelection.addItem(bundle.getString("settings_msg2"));
        this.iconModeSelection.addItem(bundle.getString("settings_msg3"));
        this.iconModeSelection.addItem(bundle.getString("settings_msg4"));
        this.iconModeSelection.setSelectedIndex(selectedIndex);
        this.layerVisualization.setText(bundle.getString("settings_msg5"));
        this.restartHint.setText("<html>" + bundle.getString("languageSelection_msg2") + "</html>");
        this.confirm.setText(bundle.getString("languageSelection_msg3"));
        this.confirmAndExit.setText(bundle.getString("languageSelection_msg4"));
        this.cancel.setText(bundle.getString("languageSelection_msg5"));
        this.buttonBox.updateUI();
    }

    public static void selectLanguage(boolean restart) {
        LanguageSelectionDialog instance = new LanguageSelectionDialog(restart);
        instance.setVisible(true);
    }

    private void apply() {
        String selectedValue = (String)this.languageSelection.getSelectedItem();
        Information.getInformation().setLocale(this.languageToLocale(selectedValue));
        switch (this.iconModeSelection.getSelectedIndex()) {
            case 1: {
                Information.getInformation().setIconMode(IconMode.ENTERPRISE);
                break;
            }
            case 2: {
                Information.getInformation().setIconMode(IconMode.SYMBOL);
                break;
            }
            default: {
                Information.getInformation().setIconMode(IconMode.DEFAULT);
            }
        }
        Information.getInformation().setLayerVisualization(this.layerVisualization.isSelected());
    }

    private Locale languageToLocale(String language) {
        Locale locale = Locale.UK;
        if (FRANCAIS.equals(language)) {
            locale = Locale.FRANCE;
        } else if (DEUTSCH.equals(language)) {
            locale = Locale.GERMANY;
        }
        return locale;
    }

    private String localeToLanguage(Locale locale) {
        String language = null == locale || Locale.UK.getCountry().equals(locale.getCountry()) ? ENGLISH : (Locale.FRANCE.getCountry().equals(locale.getCountry()) ? FRANCAIS : DEUTSCH);
        return language;
    }

    private void initialize(boolean restartMode) {
        Box verticalBox = Box.createVerticalBox();
        verticalBox.setPreferredSize(new Dimension(400, 320));
        this.getContentPane().add(verticalBox);
        this.pack();
        if (restartMode) {
            Rectangle mainFrameBounds = JMainFrame.getJMainFrame().getBounds();
            this.setLocation(mainFrameBounds.x + mainFrameBounds.width / 2 - this.getWidth() / 2, mainFrameBounds.y + mainFrameBounds.height / 2 - this.getHeight() / 2);
        } else {
            this.setLocation((this.getToolkit().getScreenSize().width - this.getWidth()) / 2, (this.getToolkit().getScreenSize().height - this.getHeight()) / 2);
        }
        verticalBox.add(Box.createVerticalStrut(10));
        Box languageLabelBox = Box.createHorizontalBox();
        languageLabelBox.add(Box.createHorizontalStrut(10));
        languageLabelBox.add(this.selectLanguageLabel);
        languageLabelBox.add(Box.createGlue());
        verticalBox.add(languageLabelBox);
        verticalBox.add(Box.createVerticalStrut(10));
        this.languageSelection.setMaximumSize(new Dimension(380, 30));
        this.languageSelection.setPreferredSize(new Dimension(380, 30));
        this.languageSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LanguageSelectionDialog.this.initializeText(LanguageSelectionDialog.this.languageToLocale((String)LanguageSelectionDialog.this.languageSelection.getSelectedItem()));
            }
        });
        Box languageSelectBox = Box.createHorizontalBox();
        languageSelectBox.add(Box.createHorizontalStrut(10));
        languageSelectBox.add(this.languageSelection);
        languageSelectBox.add(Box.createGlue());
        verticalBox.add(languageSelectBox);
        if (restartMode) {
            verticalBox.add(Box.createVerticalStrut(10));
            Box iconModeLabelBox = Box.createHorizontalBox();
            iconModeLabelBox.add(Box.createHorizontalStrut(10));
            iconModeLabelBox.add(this.selectIconModeLabel);
            iconModeLabelBox.add(Box.createGlue());
            verticalBox.add(iconModeLabelBox);
            verticalBox.add(Box.createVerticalStrut(10));
            this.iconModeSelection.setMaximumSize(new Dimension(380, 30));
            this.iconModeSelection.setPreferredSize(new Dimension(380, 30));
            Box iconModeSelectBox = Box.createHorizontalBox();
            iconModeSelectBox.add(Box.createHorizontalStrut(10));
            iconModeSelectBox.add(this.iconModeSelection);
            iconModeSelectBox.add(Box.createGlue());
            verticalBox.add(iconModeSelectBox);
        }
        if (restartMode) {
            verticalBox.add(Box.createVerticalStrut(10));
            Box layerVisualizationBox = Box.createHorizontalBox();
            layerVisualizationBox.add(Box.createHorizontalStrut(10));
            layerVisualizationBox.add(this.layerVisualization);
            layerVisualizationBox.add(Box.createGlue());
            verticalBox.add(layerVisualizationBox);
            verticalBox.add(Box.createVerticalStrut(10));
            this.layerVisualization.setMaximumSize(new Dimension(380, 30));
            this.layerVisualization.setPreferredSize(new Dimension(380, 30));
        }
        if (restartMode) {
            verticalBox.add(Box.createVerticalStrut(10));
            Box hintBox = Box.createHorizontalBox();
            hintBox.add(Box.createHorizontalStrut(10));
            this.restartHint.setPreferredSize(new Dimension(350, 60));
            this.restartHint.setSize(new Dimension(350, 60));
            this.restartHint.setMinimumSize(new Dimension(350, 60));
            hintBox.add(this.restartHint);
            hintBox.add(Box.createGlue());
            verticalBox.add(hintBox);
            verticalBox.add(Box.createVerticalStrut(10));
        } else {
            verticalBox.add(Box.createVerticalStrut(90));
        }
        this.buttonBox.setSize(new Dimension(390, 50));
        this.buttonBox.setPreferredSize(new Dimension(390, 50));
        this.buttonBox.setMinimumSize(new Dimension(390, 50));
        if (restartMode) {
            this.cancel.setPreferredSize(new Dimension(120, 30));
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguageSelectionDialog.this.setVisible(false);
                }
            });
            this.buttonBox.add(this.cancel);
            this.buttonBox.add(Box.createHorizontalStrut(10));
            this.confirmAndExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguageSelectionDialog.this.apply();
                    Main.beenden();
                }
            });
            this.buttonBox.add(this.confirmAndExit);
        } else {
            this.confirm.setPreferredSize(new Dimension(250, 30));
            this.confirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguageSelectionDialog.this.apply();
                    LanguageSelectionDialog.this.setVisible(false);
                }
            });
            this.buttonBox.add(this.confirm);
        }
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.buttonBox);
    }
}

