/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.JMainFrame;
import filius.gui.anwendungssicht.NatViewer;
import filius.hardware.knoten.Gateway;
import filius.rahmenprogramm.I18n;
import filius.software.system.SystemSoftware;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NatViewerControl
implements I18n {
    private Map<SystemSoftware, NatViewer> natViewer = new HashMap<SystemSoftware, NatViewer>();
    private Set<SystemSoftware> visibleViewer = new HashSet<SystemSoftware>();
    private static NatViewerControl singleton;

    private NatViewerControl() {
    }

    public static NatViewerControl getInstance() {
        if (null == singleton) {
            singleton = new NatViewerControl();
        }
        return singleton;
    }

    public void hideViewer() {
        this.visibleViewer.clear();
        for (NatViewer viewer : this.natViewer.values()) {
            if (viewer.isVisible()) {
                this.visibleViewer.add(viewer.getGateway().getSystemSoftware());
            }
            viewer.setVisible(false);
        }
    }

    public void showViewer(Gateway gw) {
        if (!this.natViewer.containsKey(gw.getSystemSoftware())) {
            NatViewer viewer = new NatViewer(gw);
            viewer.setLocation(JMainFrame.getJMainFrame().getX() + (JMainFrame.getJMainFrame().getWidth() - viewer.getWidth()) / 2, JMainFrame.getJMainFrame().getY() + (JMainFrame.getJMainFrame().getHeight() - viewer.getHeight()) / 2);
            gw.getSystemSoftware().addPropertyChangeListener(viewer);
            this.natViewer.put(gw.getSystemSoftware(), viewer);
        }
        this.natViewer.get(gw.getSystemSoftware()).setVisible(true);
    }

    public void removeViewer(SystemSoftware systemSoftware) {
        this.natViewer.remove(systemSoftware);
    }

    public void reshowViewer(Set<SystemSoftware> activeSystemSoftware) {
        HashSet<SystemSoftware> satToRemove = new HashSet<SystemSoftware>();
        for (SystemSoftware sysSoftawre : this.natViewer.keySet()) {
            if (!activeSystemSoftware.contains(sysSoftawre)) {
                satToRemove.add(sysSoftawre);
                continue;
            }
            if (!this.visibleViewer.contains(sysSoftawre)) continue;
            this.natViewer.get(sysSoftawre).setVisible(true);
        }
        for (SystemSoftware sysSoftware : satToRemove) {
            this.natViewer.remove(sysSoftware);
        }
    }
}

