/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.JMainFrame;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.gui.anwendungssicht.GUITreeRenderer;
import filius.gui.anwendungssicht.OrdnerInhaltListRenderer;
import filius.rahmenprogramm.I18n;
import filius.software.lokal.FileExplorer;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationFileExplorerWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationFileExplorerWindow.class);
    private static final long serialVersionUID = 1L;
    private final ImageIcon dateiIcon = new ImageIcon(this.getClass().getResource("/gfx/desktop/datei.png"));
    private final ImageIcon ordnerIcon = new ImageIcon(this.getClass().getResource("/gfx/desktop/ordner.png"));
    private JPanel backPanel;
    private JTree tv;
    private DefaultMutableTreeNode aktuellerOrdner = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
    private JList<String> dateiListe;
    private DefaultMutableTreeNode selektierteNode;
    private DefaultMutableTreeNode zwischenAblageNode;
    private OpType lastSelectedPasteOperation;
    private JButton btImportieren;
    private String datei;
    private String pfad;

    public GUIApplicationFileExplorerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initialisiereKomponenten();
    }

    private void initialisiereKomponenten() {
        this.backPanel = new JPanel(new BorderLayout());
        this.tv = new JTree(this.aktuellerOrdner);
        this.tv.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)GUIApplicationFileExplorerWindow.this.tv.getLastSelectedPathComponent();
                if (node != null) {
                    GUIApplicationFileExplorerWindow.this.aktuellerOrdner = node;
                    GUIApplicationFileExplorerWindow.this.ordnerInhaltAnzeigen(node);
                }
            }
        });
        this.tv.setBounds(0, 0, 150, 100);
        this.tv.setCellRenderer(new GUITreeRenderer((Icon)this.dateiIcon, this.ordnerIcon));
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton aktualisieren = new JButton(messages.getString("fileexplorer_msg1"));
        aktualisieren.setActionCommand("aktualisieren");
        aktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationFileExplorerWindow.this.aktualisieren();
            }
        });
        buttonBox.add(aktualisieren);
        buttonBox.add(Box.createHorizontalStrut(5));
        this.btImportieren = new JButton(messages.getString("fileexplorer_msg2"));
        this.btImportieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationFileExplorerWindow.this.fileImport();
            }
        });
        buttonBox.add(this.btImportieren);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        box.add(Box.createVerticalStrut(5));
        box.add(buttonBox);
        JScrollPane scrollpane = new JScrollPane(this.tv);
        scrollpane.setPreferredSize(new Dimension(10, 350));
        Box horBox = Box.createHorizontalBox();
        horBox.add(scrollpane);
        horBox.setPreferredSize(new Dimension(180, 350));
        DefaultListModel lmDateiListe = new DefaultListModel();
        this.dateiListe = new JList(lmDateiListe);
        this.dateiListe.setFixedCellHeight(16);
        JScrollPane dateiListenScrollPane = new JScrollPane(this.dateiListe);
        dateiListenScrollPane.setPreferredSize(new Dimension(10, 240));
        horBox.add(dateiListenScrollPane);
        this.dateiListe.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && GUIApplicationFileExplorerWindow.this.aktuellerOrdner != null) {
                    int index = ((JList)e.getSource()).locationToIndex(e.getPoint());
                    ListModel<String> lm = GUIApplicationFileExplorerWindow.this.dateiListe.getModel();
                    int selektiert = GUIApplicationFileExplorerWindow.this.selektierteZelle(index, e.getPoint());
                    JPopupMenu popmen = new JPopupMenu();
                    final JMenuItem miNeuerOrdner = new JMenuItem(I18n.messages.getString("fileexplorer_msg3"));
                    miNeuerOrdner.setActionCommand("neuerordner");
                    final JMenuItem miLoeschen = new JMenuItem(I18n.messages.getString("fileexplorer_msg4"));
                    miLoeschen.setActionCommand("loeschen");
                    final JMenuItem miAusschneiden = new JMenuItem(I18n.messages.getString("fileexplorer_msg5"));
                    miAusschneiden.setActionCommand("ausschneiden");
                    final JMenuItem miKopieren = new JMenuItem(I18n.messages.getString("fileexplorer_msg6"));
                    miKopieren.setActionCommand("kopieren");
                    final JMenuItem miEinfuegen = new JMenuItem(I18n.messages.getString("fileexplorer_msg7"));
                    miEinfuegen.setActionCommand("einfuegen");
                    final JMenuItem miUmbenennen = new JMenuItem(I18n.messages.getString("fileexplorer_msg8"));
                    miUmbenennen.setActionCommand("umbenennen");
                    ActionListener al = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String neuerName;
                            int loeschAbfrage;
                            String ordnerName;
                            if (e.getActionCommand().equals(miNeuerOrdner.getActionCommand()) && !(ordnerName = JOptionPane.showInputDialog(GUIApplicationFileExplorerWindow.this, (Object)"")).equals("")) {
                                GUIApplicationFileExplorerWindow.this.holeAnwendung().getSystemSoftware().getDateisystem().erstelleVerzeichnis(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, ordnerName);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miLoeschen.getActionCommand()) && (loeschAbfrage = JOptionPane.showConfirmDialog(GUIApplicationFileExplorerWindow.this, I18n.messages.getString("fileexplorer_msg18"), I18n.messages.getString("fileexplorer_msg18"), 0)) == 0) {
                                GUIApplicationFileExplorerWindow.this.aktuellerOrdner.remove(GUIApplicationFileExplorerWindow.this.selektierteNode);
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miAusschneiden.getActionCommand())) {
                                GUIApplicationFileExplorerWindow.this.zwischenAblageNode = GUIApplicationFileExplorerWindow.this.selektierteNode;
                                GUIApplicationFileExplorerWindow.this.lastSelectedPasteOperation = OpType.CUT_AND_PASTE;
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miKopieren.getActionCommand())) {
                                GUIApplicationFileExplorerWindow.this.zwischenAblageNode = GUIApplicationFileExplorerWindow.this.selektierteNode;
                                GUIApplicationFileExplorerWindow.this.lastSelectedPasteOperation = OpType.COPY_AND_PASTE;
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                            if (e.getActionCommand().equals(miEinfuegen.getActionCommand())) {
                                if (GUIApplicationFileExplorerWindow.this.zwischenAblageNode.isNodeDescendant(GUIApplicationFileExplorerWindow.this.aktuellerOrdner)) {
                                    JOptionPane.showMessageDialog(GUIApplicationFileExplorerWindow.this, I18n.messages.getString("fileexplorer_msg19"), "", 0);
                                } else {
                                    try {
                                        GUIApplicationFileExplorerWindow.this.aktuellerOrdner.add(GUIApplicationFileExplorerWindow.this.tiefesKopieren(GUIApplicationFileExplorerWindow.this.zwischenAblageNode));
                                        if (GUIApplicationFileExplorerWindow.this.lastSelectedPasteOperation == OpType.CUT_AND_PASTE) {
                                            ((DefaultMutableTreeNode)GUIApplicationFileExplorerWindow.this.zwischenAblageNode.getParent()).remove(GUIApplicationFileExplorerWindow.this.zwischenAblageNode);
                                            GUIApplicationFileExplorerWindow.this.zwischenAblageNode = null;
                                        }
                                    }
                                    catch (IOException | ClassNotFoundException e1) {
                                        LOG.debug("Error inserting file/dir", (Object)e);
                                    }
                                    GUIApplicationFileExplorerWindow.this.aktualisieren();
                                }
                            }
                            if (e.getActionCommand().equals(miUmbenennen.getActionCommand()) && (neuerName = JOptionPane.showInputDialog(GUIApplicationFileExplorerWindow.this, (Object)I18n.messages.getString("fileexplorer_msg9"))) != null && !neuerName.trim().isEmpty() && !GUIApplicationFileExplorerWindow.this.holeAnwendung().getSystemSoftware().getDateisystem().dateiVorhanden(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, neuerName)) {
                                if (GUIApplicationFileExplorerWindow.this.selektierteNode.getUserObject().getClass().equals(Datei.class)) {
                                    Datei dat = (Datei)GUIApplicationFileExplorerWindow.this.selektierteNode.getUserObject();
                                    dat.setName(neuerName);
                                } else {
                                    GUIApplicationFileExplorerWindow.this.selektierteNode.setUserObject(neuerName);
                                }
                                GUIApplicationFileExplorerWindow.this.aktualisieren();
                            }
                        }
                    };
                    miNeuerOrdner.addActionListener(al);
                    miLoeschen.addActionListener(al);
                    miAusschneiden.addActionListener(al);
                    miKopieren.addActionListener(al);
                    miEinfuegen.addActionListener(al);
                    miUmbenennen.addActionListener(al);
                    if (selektiert == -1) {
                        popmen.add(miNeuerOrdner);
                        if (GUIApplicationFileExplorerWindow.this.zwischenAblageNode != null) {
                            popmen.add(miEinfuegen);
                        }
                    } else {
                        String[] teile = lm.getElementAt(index).toString().split(";");
                        if (teile.length > 0) {
                            GUIApplicationFileExplorerWindow.this.selektierteNode = Dateisystem.verzeichnisKnoten(GUIApplicationFileExplorerWindow.this.aktuellerOrdner, teile[1]);
                            GUIApplicationFileExplorerWindow.this.dateiListe.setSelectedIndex(index);
                        }
                        popmen.add(miLoeschen);
                        popmen.add(miAusschneiden);
                        popmen.add(miKopieren);
                        popmen.add(miUmbenennen);
                    }
                    GUIApplicationFileExplorerWindow.this.add(popmen);
                    popmen.show(GUIApplicationFileExplorerWindow.this.dateiListe, e.getX(), e.getY());
                }
            }
        });
        box.add(horBox);
        this.backPanel.add((Component)box, "Center");
        this.ordnerInhaltAnzeigen(this.aktuellerOrdner);
        this.add((Component)this.backPanel, "Center");
    }

    public void ordnerInhaltAnzeigen(DefaultMutableTreeNode node) {
        DefaultListModel lm = (DefaultListModel)this.dateiListe.getModel();
        lm.clear();
        this.dateiListe.setCellRenderer(new OrdnerInhaltListRenderer());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode enode = (DefaultMutableTreeNode)e.nextElement();
            if (enode.getUserObject().getClass().equals(Datei.class)) {
                Datei dat = (Datei)enode.getUserObject();
                lm.addElement(messages.getString("fileexplorer_msg10") + ";" + dat.getName());
                continue;
            }
            lm.addElement(messages.getString("fileexplorer_msg11") + ";" + enode.toString());
        }
    }

    public int selektierteZelle(int index, Point punkt) {
        int ergebnis = -1;
        if (this.dateiListe.indexToLocation(index) != null && this.dateiListe.indexToLocation(index).getY() + (double)this.dateiListe.getFixedCellHeight() > punkt.getY()) {
            ergebnis = index;
        }
        return ergebnis;
    }

    public void aktualisieren() {
        this.tv.updateUI();
        this.ordnerInhaltAnzeigen(this.aktuellerOrdner);
    }

    public DefaultMutableTreeNode tiefesKopieren(DefaultMutableTreeNode original) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode ergebnis = null;
        ByteArrayOutputStream bufOutStream = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(bufOutStream);
        outStream.writeObject(original);
        outStream.close();
        byte[] buffer = bufOutStream.toByteArray();
        ByteArrayInputStream bufInStream = new ByteArrayInputStream(buffer);
        ObjectInputStream inStream = new ObjectInputStream(bufInStream);
        ergebnis = (DefaultMutableTreeNode)inStream.readObject();
        return ergebnis;
    }

    public void fileImport() {
        this.backPanel = new JPanel(new BorderLayout());
        final JTextArea outputField = new JTextArea("");
        outputField.setEditable(false);
        outputField.setBackground(this.backPanel.getBackground());
        outputField.setFont(outputField.getFont().deriveFont(1));
        outputField.setBorder(null);
        outputField.setPreferredSize(new Dimension(500, 30));
        JLabel fileLabel = new JLabel(messages.getString("fileexplorer_msg13"));
        fileLabel.setPreferredSize(new Dimension(100, 30));
        final JTextField inputField = new JTextField("");
        inputField.setPreferredSize(new Dimension(200, 30));
        inputField.setEditable(false);
        final JTextField renameField = new JTextField("");
        renameField.setPreferredSize(new Dimension(200, 30));
        JLabel renameLabel = new JLabel(messages.getString("fileexplorer_msg9"));
        renameLabel.setPreferredSize(new Dimension(100, 30));
        JButton fileButton = new JButton(messages.getString("fileexplorer_msg14"));
        fileButton.setPreferredSize(new Dimension(150, 30));
        fileButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FileDialog fileDialog = new FileDialog((Frame)JMainFrame.getJMainFrame(), I18n.messages.getString("main_msg3"), 0);
                fileDialog.setVisible(true);
                if (null != fileDialog.getFile()) {
                    GUIApplicationFileExplorerWindow.this.datei = fileDialog.getFile();
                    GUIApplicationFileExplorerWindow.this.pfad = fileDialog.getDirectory();
                    if (!GUIApplicationFileExplorerWindow.this.pfad.endsWith(System.getProperty("file.separator"))) {
                        GUIApplicationFileExplorerWindow.this.pfad = GUIApplicationFileExplorerWindow.this.pfad + System.getProperty("file.separator");
                    }
                }
                if (GUIApplicationFileExplorerWindow.this.datei != null) {
                    inputField.setText(GUIApplicationFileExplorerWindow.this.pfad + GUIApplicationFileExplorerWindow.this.datei);
                    renameField.setText(GUIApplicationFileExplorerWindow.this.datei);
                }
            }
        });
        JButton importButton = new JButton(messages.getString("fileexplorer_msg15"));
        importButton.setPreferredSize(new Dimension(150, 30));
        importButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent z) {
                if (inputField.getText().equals("") || renameField.getText().equals("")) {
                    outputField.setText(I18n.messages.getString("fileexplorer_msg16"));
                } else if (GUIApplicationFileExplorerWindow.this.aktuellerOrdner == null) {
                    outputField.setText(I18n.messages.getString("fileexplorer_msg17"));
                } else {
                    outputField.setText(((FileExplorer)GUIApplicationFileExplorerWindow.this.holeAnwendung()).addFile(GUIApplicationFileExplorerWindow.this.pfad, GUIApplicationFileExplorerWindow.this.datei, GUIApplicationFileExplorerWindow.this.aktuellerOrdner, renameField.getText()));
                    GUIApplicationFileExplorerWindow.this.aktualisieren();
                }
            }
        });
        JButton closeButton = new JButton(messages.getString("sw_fileimporter_msg3"));
        closeButton.setPreferredSize(new Dimension(150, 30));
        closeButton.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent z) {
                GUIApplicationFileExplorerWindow.this.desktop.closeModularWindow();
            }
        });
        Box fileSelectionBox = Box.createHorizontalBox();
        fileSelectionBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        fileSelectionBox.add(fileLabel);
        fileSelectionBox.add(Box.createHorizontalStrut(5));
        fileSelectionBox.add(inputField);
        fileSelectionBox.add(Box.createHorizontalStrut(5));
        fileSelectionBox.add(fileButton);
        Box fileImportBox = Box.createHorizontalBox();
        fileImportBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        fileImportBox.add(renameLabel);
        fileImportBox.add(Box.createHorizontalStrut(5));
        fileImportBox.add(renameField);
        fileImportBox.add(Box.createHorizontalStrut(5));
        fileImportBox.add(importButton);
        Box importResultBox = Box.createHorizontalBox();
        importResultBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        importResultBox.add(outputField);
        Box upperBox = Box.createVerticalBox();
        upperBox.add(fileSelectionBox);
        upperBox.add(fileImportBox);
        upperBox.add(importResultBox);
        this.backPanel.add((Component)upperBox, "North");
        Box lowerBox = Box.createVerticalBox();
        lowerBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lowerBox.add(Box.createVerticalStrut(5));
        lowerBox.add(closeButton);
        lowerBox.add(Box.createVerticalStrut(5));
        this.backPanel.add((Component)lowerBox, "South");
        this.desktop.showModularWindow(messages.getString("fileexplorer_msg12"), this.backPanel);
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.aktualisieren();
    }

    private static enum OpType {
        CUT_AND_PASTE,
        COPY_AND_PASTE;

    }
}

