/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.software.www.HTTPNachricht;
import filius.software.www.WebBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.NodeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationWebBrowserWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationWebBrowserWindow.class);
    private static final long serialVersionUID = 1L;
    private JPanel browserPanel = new JPanel(new BorderLayout());
    private JTextField urlFeld;
    private JEditorPane anzeigeFeld;
    private JButton goButton;

    public GUIApplicationWebBrowserWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.add((Component)this.browserPanel, "Center");
        Box topBox = Box.createHorizontalBox();
        this.urlFeld = new JTextField("http://");
        this.urlFeld.setVisible(true);
        topBox.add(this.urlFeld);
        topBox.add(Box.createHorizontalStrut(5));
        this.goButton = new JButton(messages.getString("webbrowser_msg2"));
        topBox.add(this.goButton);
        topBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.browserPanel.add((Component)topBox, "North");
        Box middleBox = Box.createHorizontalBox();
        middleBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                URL url = GUIApplicationWebBrowserWindow.this.erzeugeURL(GUIApplicationWebBrowserWindow.this.urlFeld.getText());
                GUIApplicationWebBrowserWindow.this.abrufenWebseite(url, null);
            }
        };
        this.goButton.addActionListener(al);
        this.urlFeld.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    URL url = GUIApplicationWebBrowserWindow.this.erzeugeURL(GUIApplicationWebBrowserWindow.this.urlFeld.getText());
                    GUIApplicationWebBrowserWindow.this.abrufenWebseite(url, null);
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        HTMLEditorKit ek = new HTMLEditorKit();
        ek.setAutoFormSubmission(false);
        this.anzeigeFeld = new JEditorPane();
        this.anzeigeFeld.setEditorKit(ek);
        this.anzeigeFeld.setContentType("text/html");
        this.anzeigeFeld.setText("<html><head><base href=\"file:bilder\"></head><body margin=\"0\"><center><img src=\"browser_waterwolf_logo.png\" align=\"top\"></center></font></body></html>");
        SzenarioVerwaltung.saveStream(this.getClass().getResourceAsStream("/gfx/desktop/browser_waterwolf_logo.png"), Information.getInformation().getTempPfad() + "browser_waterwolf_logo.png");
        try {
            ((HTMLDocument)this.anzeigeFeld.getDocument()).setBase(new URL("file:" + Information.getInformation().getTempPfad()));
        }
        catch (MalformedURLException e1) {
            LOG.debug("", e1);
        }
        this.anzeigeFeld.setEditable(false);
        this.anzeigeFeld.setBorder(null);
        this.hyperLinkListener(this.anzeigeFeld);
        this.anzeigeFeld.setVisible(true);
        JScrollPane spAnzeige = new JScrollPane(this.anzeigeFeld);
        middleBox.add(spAnzeige);
        this.browserPanel.add((Component)middleBox, "Center");
    }

    private URL erzeugeURL(String ressource) {
        int i;
        URL url = null;
        String host = null;
        Object pfad = "";
        String[] teilstrings = ressource.split("/");
        if (teilstrings.length > 0 && !teilstrings[0].equalsIgnoreCase("http:") && (EingabenUeberpruefung.isGueltig(teilstrings[0], EingabenUeberpruefung.musterDomain) || EingabenUeberpruefung.isGueltig(teilstrings[0], EingabenUeberpruefung.musterIpAdresse))) {
            host = teilstrings[0];
            for (i = 1; i < teilstrings.length; ++i) {
                pfad = (String)pfad + "/" + teilstrings[i];
            }
        }
        if (teilstrings.length > 2 && teilstrings[0].equalsIgnoreCase("http:")) {
            if (EingabenUeberpruefung.isGueltig(teilstrings[2], EingabenUeberpruefung.musterDomain) || EingabenUeberpruefung.isGueltig(teilstrings[2], EingabenUeberpruefung.musterIpAdresse)) {
                host = teilstrings[2];
            }
            for (i = 3; i < teilstrings.length; ++i) {
                pfad = (String)pfad + "/" + teilstrings[i];
            }
        }
        if (host != null) {
            if (((String)pfad).equals("")) {
                pfad = "/";
            }
            try {
                url = new URL("http", host, (String)pfad);
            }
            catch (MalformedURLException e) {
                LOG.debug("", e);
            }
        }
        return url;
    }

    private void abrufenWebseite(URL url, String postDaten) {
        if (url != null) {
            if (postDaten == null) {
                ((WebBrowser)this.holeAnwendung()).holeWebseite(url);
            } else {
                ((WebBrowser)this.holeAnwendung()).holeWebseite(url, postDaten);
            }
            String host = url.getHost() == null || url.getHost().equals("") ? ((WebBrowser)this.holeAnwendung()).holeHost() : url.getHost();
            this.urlFeld.setText(url.getProtocol() + "://" + host + url.getPath());
            this.setTitle(url.getProtocol() + "://" + host + url.getPath());
        } else {
            this.urlFeld.setText("http://");
        }
    }

    private void initialisiereWebseite(String quelltext) {
        this.anzeigeFeld.setContentType("text/html");
        this.anzeigeFeld.setText(quelltext);
        Parser parser = Parser.createParser(quelltext, null);
        try {
            Tag tag;
            NodeList liste = parser.parse(new TagNameFilter("title"));
            if (liste.size() > 0 && (tag = (Tag)liste.elementAt(0)).getChildren() != null && tag.getChildren().size() > 0) {
                this.setTitle(tag.getChildren().elementAt(0).toHtml());
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
        }
    }

    private void hyperLinkListener(JEditorPane editorPane) {
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url = null;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL tmp = ((HTMLDocument)GUIApplicationWebBrowserWindow.this.anzeigeFeld.getDocument()).getBase();
                    if (e.getURL().getProtocol().equals(tmp.getProtocol())) {
                        try {
                            String pfad = e.getURL().getFile().replace(tmp.getFile(), "/");
                            url = new URL("http", "", pfad);
                        }
                        catch (MalformedURLException e1) {
                            LOG.debug("", (Object)e);
                        }
                    } else {
                        url = e.getURL();
                    }
                    if (e instanceof FormSubmitEvent) {
                        String postDatenteil = "";
                        FormSubmitEvent formSubmitEvent = (FormSubmitEvent)e;
                        if (formSubmitEvent.getMethod() == FormSubmitEvent.MethodType.POST) {
                            postDatenteil = formSubmitEvent.getData();
                        }
                        GUIApplicationWebBrowserWindow.this.abrufenWebseite(url, postDatenteil);
                    } else {
                        GUIApplicationWebBrowserWindow.this.abrufenWebseite(url, null);
                    }
                }
            }
        });
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIApplicationWebBrowserWindow), update(" + String.valueOf(arg0) + "," + String.valueOf(arg1) + ")");
        if (arg1 == null) {
            this.anzeigeFeld.updateUI();
        } else if (arg1 instanceof HTTPNachricht) {
            if (((HTTPNachricht)arg1).getDaten() == null) {
                this.anzeigeFeld.updateUI();
            } else {
                this.initialisiereWebseite(((HTTPNachricht)arg1).getDaten());
            }
        }
    }
}

