/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.gui.anwendungssicht.VHostConfigTable;
import filius.rahmenprogramm.I18n;
import filius.software.www.WebServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationWebServerWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationWebServerWindow.class);
    private static final int VHOST_NUMBER = 5;
    private static final long serialVersionUID = 1L;
    private JPanel backPanel;
    private JTextArea logArea;
    private JButton buttonStart;
    private JCheckBox showVHosts;
    private VHostConfigTable vHostTable;
    private Box vHostBox = null;
    private Box logBox = null;

    public GUIApplicationWebServerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initialisiereKomponenten();
        this.aktualisieren();
    }

    private void initialisiereKomponenten() {
        this.backPanel = new JPanel(new BorderLayout());
        this.buttonStart = new JButton(messages.getString("webserver_msg1"));
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GUIApplicationWebServerWindow.this.buttonStart.getText().equals(I18n.messages.getString("webserver_msg1"))) {
                    ((WebServer)GUIApplicationWebServerWindow.this.holeAnwendung()).setAktiv(true);
                } else {
                    ((WebServer)GUIApplicationWebServerWindow.this.holeAnwendung()).setAktiv(false);
                }
            }
        });
        Box upperBox = Box.createHorizontalBox();
        upperBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upperBox.add(this.buttonStart);
        upperBox.add(Box.createHorizontalStrut(100));
        this.showVHosts = new JCheckBox();
        this.showVHosts.setText(messages.getString("webserver_msg6"));
        this.showVHosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCheckBox checkBox = (JCheckBox)evt.getSource();
                ((WebServer)GUIApplicationWebServerWindow.this.holeAnwendung()).setUseVHost(checkBox.isSelected());
                GUIApplicationWebServerWindow.this.aktualisieren();
                LOG.debug("vhost status changed: " + (checkBox.isSelected() ? "enabled" : "disabled"));
            }
        });
        upperBox.add(this.showVHosts);
        this.backPanel.add((Component)upperBox, "North");
        this.vHostBox = Box.createVerticalBox();
        this.vHostBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(messages.getString("webserver_msg3"));
        Box vHostLabel = Box.createHorizontalBox();
        vHostLabel.add(label);
        DefaultTableModel tablemodel = new DefaultTableModel(5, 2);
        this.vHostTable = new VHostConfigTable((TableModel)tablemodel, true);
        this.vHostTable.setParentGUI(this);
        JScrollPane tableScrollPane = new JScrollPane(this.vHostTable);
        tableScrollPane.setVerticalScrollBarPolicy(20);
        tableScrollPane.setHorizontalScrollBarPolicy(31);
        LOG.debug("message webserver_msg4='" + messages.getString("webserver_msg4") + "'");
        this.vHostTable.getColumnModel().getColumn(0).setHeaderValue(messages.getString("webserver_msg4"));
        this.vHostTable.getColumnModel().getColumn(1).setHeaderValue(messages.getString("webserver_msg5"));
        LOG.debug("header value: '" + String.valueOf(this.vHostTable.getColumnModel().getColumn(0).getHeaderValue()) + "'");
        this.vHostTable.setIntercellSpacing(new Dimension(5, 5));
        this.vHostTable.setRowHeight(26);
        this.vHostTable.setShowGrid(true);
        this.vHostTable.setFillsViewportHeight(true);
        this.vHostTable.setBackground(Color.WHITE);
        this.vHostTable.setShowHorizontalLines(true);
        this.vHostBox.add(vHostLabel);
        this.vHostBox.add(Box.createVerticalStrut(5));
        this.vHostBox.add(tableScrollPane);
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        JScrollPane sPane = new JScrollPane(this.logArea);
        this.logBox = Box.createHorizontalBox();
        this.logBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.logBox.add(sPane);
        this.backPanel.add((Component)this.logBox, "South");
        this.add((Component)this.backPanel, "Center");
    }

    private void showVHostTable(boolean tableVisible) {
        if (tableVisible) {
            this.backPanel.add((Component)this.vHostBox, "Center");
            this.logBox.setPreferredSize(new Dimension(300, 150));
        } else {
            this.backPanel.remove(this.vHostBox);
            this.logBox.setPreferredSize(new Dimension(300, 350));
        }
        this.showVHosts.setSelected(tableVisible);
        Dimension size = this.getSize();
        this.setSize(size);
        this.updateUI();
    }

    public void updateVHostTable() {
        Vector<String> v;
        int i;
        LOG.trace("GUIApplicationWebServerWindow, updateTable; vHostArray:\n" + ((WebServer)this.holeAnwendung()).printVHostTable());
        String[][] vhosts = ((WebServer)this.holeAnwendung()).getVHostArray();
        DefaultTableModel tablemodel = (DefaultTableModel)this.vHostTable.getModel();
        tablemodel.setRowCount(0);
        for (i = 0; i < vhosts.length; ++i) {
            v = new Vector<String>();
            if (vhosts[i][0] != null) {
                v.add(vhosts[i][0]);
            } else {
                v.add("");
            }
            if (vhosts[i][1] != null) {
                v.add(vhosts[i][1]);
            } else {
                v.add("");
            }
            tablemodel.addRow(v);
        }
        for (i = vhosts.length; i < 5; ++i) {
            v = new Vector();
            v.add("");
            v.add("");
            tablemodel.addRow(v);
        }
    }

    private void aktualisieren() {
        WebServer webserver = (WebServer)this.holeAnwendung();
        if (webserver.isAktiv()) {
            this.buttonStart.setText(messages.getString("webserver_msg2"));
        } else {
            this.buttonStart.setText(messages.getString("webserver_msg1"));
        }
        this.buttonStart.setEnabled(true);
        this.updateVHostTable();
        this.showVHostTable(webserver.isUseVHost());
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIApplicationWebServerWindow), update(" + String.valueOf(arg0) + "," + String.valueOf(arg1) + ")");
        if (this.logArea != null && arg1 != null) {
            this.logArea.append(arg1.toString() + "\n");
        }
        try {
            this.aktualisieren();
        }
        catch (Exception e) {
            LOG.debug("GUIApplicationWebServerWindow: update() Exception: " + e.getMessage());
        }
        LOG.debug("GUIApplicationWebServerWindow: update() aufgerufen.");
    }
}

