/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;

public abstract class GUIApplicationWindow
extends JPanel
implements I18n,
Observer {
    protected GUIDesktopPanel desktop;
    protected Anwendung anwendung;
    protected JLabel titleLabel;
    protected JLabel icon;

    public GUIApplicationWindow(GUIDesktopPanel desktop) {
        super(new BorderLayout());
        this.desktop = desktop;
        this.initComponents();
    }

    public GUIApplicationWindow(GUIDesktopPanel desktop, String appKlasse) {
        super(new BorderLayout());
        this.desktop = desktop;
        this.initComponents();
        this.anwendung = desktop.getBetriebssystem().holeSoftware(appKlasse);
        this.anwendung.hinzuBeobachter(this);
        this.setIcon(this.anwendung);
        this.setTitle(this.anwendung);
    }

    private void initComponents() {
        this.setSize(640, 430);
        this.setPreferredSize(new Dimension(640, 430));
        BorderLayout appWindowLayout = (BorderLayout)this.getLayout();
        appWindowLayout.setHgap(0);
        appWindowLayout.setVgap(0);
        this.setLayout(appWindowLayout);
        JPanel titleBar = new JPanel(new BorderLayout());
        titleBar.setPreferredSize(new Dimension(640, 30));
        titleBar.setBackground(Color.DARK_GRAY);
        this.add((Component)titleBar, "North");
        this.icon = new JLabel();
        this.icon.setPreferredSize(new Dimension(30, 30));
        this.icon.setHorizontalAlignment(0);
        titleBar.add((Component)this.icon, "West");
        this.titleLabel = new JLabel();
        this.titleLabel.setForeground(new Color(225, 225, 225));
        this.titleLabel.setHorizontalAlignment(0);
        titleBar.add((Component)this.titleLabel, "Center");
    }

    public void close() {
        this.desktop.showApplications();
    }

    private void setIcon(Anwendung app) {
        for (Map<String, String> tmpMap : Information.getInformation().ladeProgrammListe()) {
            if (!app.holeAnwendungsName().equals(tmpMap.get("Anwendung"))) continue;
            String path = "/" + tmpMap.get("gfxFile");
            this.setIcon(path);
            break;
        }
    }

    protected void setIcon(String path) {
        ImageIcon image = new ImageIcon(this.getClass().getResource(path));
        image.setImage(image.getImage().getScaledInstance(16, 16, 16));
        this.icon.setIcon(image);
    }

    protected void setTitle(Anwendung app) {
        this.setTitle(app, "");
    }

    protected void setTitle(Anwendung app, String titleExtension) {
        Object title = StringUtils.isNoneBlank(titleExtension) && null != app ? app.holeAnwendungsName() + " - " + titleExtension : (null != app ? app.holeAnwendungsName() : titleExtension);
        this.setTitle((String)title);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public Anwendung holeAnwendung() {
        return this.anwendung;
    }

    public void showMessageDialog(String msg) {
        JOptionPane.showMessageDialog(this.desktop, msg);
    }

    public int showOptionDialog(Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        return JOptionPane.showOptionDialog(this.desktop, message, title, optionType, messageType, icon, options, initialValue);
    }

    public int showConfirmDialog(String msg) {
        return JOptionPane.showConfirmDialog(this.desktop, msg);
    }

    public void addFrame(JInternalFrame frame) {
        this.desktop.getDesktopPane().add(frame);
    }

    public void starteExterneAnwendung(String softwareName) {
        this.desktop.starteAnwendung(softwareName);
    }

    public void starteExterneAnwendung(String softwareName, String[] param) {
        this.desktop.starteAnwendung(softwareName, param);
    }

    public String[] holeParameter() {
        return this.desktop.getParameter();
    }

    public void zeigePopupMenu(JPopupMenu menu, int x, int y) {
        menu.show(this.desktop, x, y);
    }

    public void starten(String[] param) {
    }
}

