/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopIcon;
import filius.gui.anwendungssicht.GUIInstallationsDialog;
import filius.gui.anwendungssicht.JBackgroundDesktopPane;
import filius.gui.anwendungssicht.NetworkInfoPanel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.FiliusClassLoader;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.system.Betriebssystem;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIDesktopPanel
extends JPanel
implements I18n,
Observer {
    private static Logger LOG = LoggerFactory.getLogger(GUIDesktopPanel.class);
    static final int HEIGHT_TASKBAR = 30;
    static final int HEIGHT_OVERALL = 460;
    static final int PANEL_WIDTH = 640;
    static final int HEIGHT_CONTENT = 430;
    static final int HEIGHT_APP_TITLEBAR = 30;
    static final int SIZE_TITLEBAR_ICON = 30;
    private static final String SOFTWARE_INSTALLATION = "Software-Installation";
    private static final String DESKTOP_WITH_APPS = "desktop-with-apps";
    private Betriebssystem betriebssystem;
    private HashMap<String, GUIApplicationWindow> laufendeAnwendung = new HashMap();
    private CardLayout workingAreaCardLayout = new CardLayout();
    private JBackgroundDesktopPane desktopCard;
    private JPanel workingLayer;
    private JPanel appPanel;
    private JPanel taskbar;
    private JLayeredPane mainPaneWithOverlay;
    private JPanel infoLayer;
    private NetworkInfoPanel networkInfo;
    private JLabel networkIcon;
    private JPanel dialogLayer;
    private String[] parameter = new String[]{"", "", ""};

    public GUIDesktopPanel(Betriebssystem betriebssystem) {
        this.betriebssystem = betriebssystem;
        betriebssystem.addObserver(this);
        this.initOverallArea();
        this.initWorkingArea();
        this.initTaskbar();
        this.updateAppPane();
    }

    private void initOverallArea() {
        this.setBounds(0, 0, 640, 460);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(0);
        layout.setVgap(0);
        this.setLayout(layout);
    }

    private void initTaskbar() {
        this.taskbar = new JPanel(new BorderLayout());
        this.taskbar.setPreferredSize(new Dimension(640, 30));
        this.taskbar.setBackground(new Color(180, 180, 180));
        this.add((Component)this.taskbar, "South");
        this.networkIcon = new JLabel(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_aus.png")));
        this.networkIcon.setPreferredSize(new Dimension(50, 30));
        this.networkIcon.setAlignmentX(0.5f);
        this.networkIcon.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDesktopPanel.this.setInfoVisible(true);
            }
        });
        this.initNetworkIcon();
        this.taskbar.add((Component)this.networkIcon, "East");
        JButton homeButton = new JButton(" " + messages.getString("desktoppanel_application") + " ");
        homeButton.setBackground(this.taskbar.getBackground());
        homeButton.setContentAreaFilled(false);
        homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIDesktopPanel.this.showApplications();
            }
        });
        this.taskbar.add((Component)homeButton, "Center");
        JLabel leftPlaceholder = new JLabel();
        leftPlaceholder.setPreferredSize(this.networkIcon.getPreferredSize());
        this.taskbar.add((Component)leftPlaceholder, "West");
    }

    private void setInfoVisible(boolean visible) {
        if (visible) {
            this.mainPaneWithOverlay.moveToFront(this.infoLayer);
            if (null != this.networkInfo) {
                this.networkInfo.setVisible(true);
            }
        } else {
            this.mainPaneWithOverlay.moveToBack(this.infoLayer);
        }
        this.mainPaneWithOverlay.updateUI();
    }

    private void initWorkingArea() {
        this.mainPaneWithOverlay = new JLayeredPane();
        this.mainPaneWithOverlay.setPreferredSize(new Dimension(640, 430));
        this.add((Component)this.mainPaneWithOverlay, "Center");
        this.workingLayer = new JPanel(this.workingAreaCardLayout);
        this.workingLayer.setSize(new Dimension(640, 430));
        this.mainPaneWithOverlay.add((Component)this.workingLayer, JLayeredPane.DEFAULT_LAYER);
        this.desktopCard = new JBackgroundDesktopPane();
        this.desktopCard.setBackgroundImage("gfx/desktop/hintergrundbild.png");
        this.appPanel = new JPanel();
        this.appPanel.setBounds(0, 0, 640, 460);
        this.appPanel.setLayout(new FlowLayout(0, 5, 10));
        this.appPanel.setOpaque(false);
        this.desktopCard.add((Component)this.appPanel, "Center");
        this.workingLayer.add((Component)this.desktopCard, DESKTOP_WITH_APPS);
        this.infoLayer = new JPanel();
        this.infoLayer.setLayout(null);
        this.infoLayer.setOpaque(false);
        this.infoLayer.setBounds(0, 0, 640, 460);
        this.infoLayer.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDesktopPanel.this.setInfoVisible(false);
            }
        });
        this.networkInfo = new NetworkInfoPanel(this);
        int infoWidth = (int)this.networkInfo.getPreferredSize().getWidth();
        int infoHeight = (int)this.networkInfo.getPreferredSize().getHeight();
        this.networkInfo.setBounds(640 - infoWidth, 430 - infoHeight, infoWidth, infoHeight);
        this.infoLayer.add(this.networkInfo);
        this.mainPaneWithOverlay.add((Component)this.infoLayer, JLayeredPane.DEFAULT_LAYER);
        this.dialogLayer = new JPanel();
        this.dialogLayer.setLayout(null);
        this.dialogLayer.setBounds(0, 30, 640, 430);
        this.dialogLayer.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }
        });
        this.dialogLayer.setVisible(false);
        this.mainPaneWithOverlay.add((Component)this.dialogLayer, JLayeredPane.DRAG_LAYER);
    }

    public void showApplications() {
        this.workingAreaCardLayout.show(this.workingLayer, DESKTOP_WITH_APPS);
        this.dialogLayer.setVisible(false);
    }

    public void showModularWindow(String title, JComponent panel) {
        this.dialogLayer.removeAll();
        this.dialogLayer.setVisible(true);
        int windowWidth = (int)panel.getPreferredSize().getWidth();
        int windowHeight = (int)panel.getPreferredSize().getHeight();
        panel.setBounds((640 - windowWidth) / 2, 30, windowWidth, windowHeight);
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.dialogLayer.add(panel);
        JLabel titlebar = new JLabel(title);
        titlebar.setOpaque(true);
        titlebar.setBackground(new Color(100, 100, 100));
        titlebar.setForeground(new Color(250, 250, 250));
        titlebar.setHorizontalAlignment(0);
        titlebar.setBounds(0, 0, 640, 30);
        this.dialogLayer.add(titlebar);
        this.dialogLayer.updateUI();
        this.mainPaneWithOverlay.moveToFront(this.dialogLayer);
        this.mainPaneWithOverlay.updateUI();
    }

    public void closeModularWindow() {
        this.dialogLayer.removeAll();
        this.dialogLayer.setVisible(false);
        this.mainPaneWithOverlay.moveToBack(this.dialogLayer);
        this.mainPaneWithOverlay.updateUI();
    }

    public void closeModularWindow(JPanel progressPanel) {
        for (Component comp : this.dialogLayer.getComponents()) {
            if (!comp.equals(progressPanel)) continue;
            this.closeModularWindow();
            break;
        }
    }

    public void updateAppPane() {
        this.appPanel.removeAll();
        this.appPanel.add(this.initInstaller());
        for (Map<String, String> appInfo : Information.getInformation().ladeProgrammListe()) {
            String appClass = appInfo.get("Klasse");
            if (this.betriebssystem.holeSoftware(appClass) == null) continue;
            this.appPanel.add(this.initApp(appInfo));
        }
        this.appPanel.updateUI();
    }

    private GUIDesktopIcon initInstaller() {
        GUIInstallationsDialog tempWindow = new GUIInstallationsDialog(this);
        tempWindow.setBounds(0, 0, 640, 460);
        this.addLaufendeAnwendung(SOFTWARE_INSTALLATION, tempWindow);
        return this.createIcon(messages.getString("desktoppanel_msg1"), SOFTWARE_INSTALLATION, "/gfx/desktop/icon_softwareinstallation.png");
    }

    private GUIDesktopIcon initApp(Map<String, String> appInfo) {
        GUIDesktopIcon tmpLabel = null;
        try {
            Class<?> cl = Class.forName(appInfo.get("GUI-Klasse"), true, FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
            GUIApplicationWindow tempWindow = (GUIApplicationWindow)cl.getConstructor(GUIDesktopPanel.class, String.class).newInstance(this, appInfo.get("Klasse"));
            tempWindow.setBounds(0, 0, 640, 460);
            this.addLaufendeAnwendung(appInfo.get("Klasse"), tempWindow);
            tmpLabel = this.createIcon(appInfo.get("Anwendung"), appInfo.get("Klasse"), "/" + appInfo.get("gfxFile"));
        }
        catch (Exception e) {
            LOG.debug("app {} could not be initiated", (Object)appInfo, (Object)e);
        }
        return tmpLabel;
    }

    private GUIDesktopIcon createIcon(String appName, String invokeName, String imagePath) {
        GUIDesktopIcon tmpLabel = new GUIDesktopIcon(this, new ImageIcon(this.getClass().getResource(imagePath)));
        tmpLabel.setAnwendungsName(appName);
        tmpLabel.setToolTipText(appName);
        tmpLabel.setText(appName);
        tmpLabel.setInvokeName(invokeName);
        tmpLabel.setVerticalTextPosition(3);
        tmpLabel.setHorizontalTextPosition(0);
        tmpLabel.setForeground(new Color(255, 255, 255));
        tmpLabel.setPreferredSize(new Dimension(120, 96));
        return tmpLabel;
    }

    private void initNetworkIcon() {
        NetzwerkInterface nic = ((InternetKnoten)this.betriebssystem.getKnoten()).getNetzwerkInterfaces().get(0);
        if (nic != null && nic.getPort() != null && nic.getPort().getVerbindung() != null) {
            nic.getPort().getVerbindung().addObserver(this);
            this.networkIcon.setToolTipText(nic.getIp());
        }
    }

    public GUIApplicationWindow starteAnwendung(String softwareKlasse, String[] param) {
        this.setParameter(param);
        return this.starteAnwendung(softwareKlasse);
    }

    public GUIApplicationWindow starteAnwendung(String softwareKlasse) {
        GUIApplicationWindow tempWindow = null;
        if (this.getLaufendeAnwendungByName(softwareKlasse) != null) {
            tempWindow = this.getLaufendeAnwendungByName(softwareKlasse);
            tempWindow.updateUI();
            tempWindow.starten(this.parameter);
            this.workingAreaCardLayout.show(this.workingLayer, softwareKlasse);
            this.workingLayer.transferFocus();
        }
        return tempWindow;
    }

    private void addLaufendeAnwendung(String appClass, GUIApplicationWindow fenster) {
        this.laufendeAnwendung.put(appClass, fenster);
        this.workingLayer.add((Component)fenster, appClass);
    }

    private GUIApplicationWindow getLaufendeAnwendungByName(String anwendungsName) {
        GUIApplicationWindow tmpFenster = null;
        tmpFenster = this.laufendeAnwendung.get(anwendungsName);
        return tmpFenster;
    }

    public Betriebssystem getBetriebssystem() {
        return this.betriebssystem;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopCard;
    }

    public String[] getParameter() {
        return this.parameter;
    }

    public void setParameter(String[] parameter) {
        this.parameter = parameter;
    }

    @Override
    public void update(Observable o, Object arg) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (GUIDesktopPanel), update(" + String.valueOf(o) + "," + String.valueOf(arg) + ")");
        if (arg == null) {
            this.updateAppPane();
            this.initNetworkIcon();
        } else if (arg.equals(Boolean.TRUE)) {
            this.networkIcon.setIcon(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_c.png")));
        } else {
            this.networkIcon.setIcon(new ImageIcon(this.getClass().getResource("/gfx/desktop/netzwek_aus.png")));
        }
    }

    public void updateInfo() {
        if (null != this.networkInfo) {
            this.networkInfo.updateInfo();
        }
    }
}

