/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.JMainFrame;
import filius.hardware.knoten.Gateway;
import filius.rahmenprogramm.I18n;
import filius.software.system.GatewayFirmware;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class NatViewer
extends JDialog
implements I18n,
PropertyChangeListener {
    private Gateway gw;
    private DefaultTableModel dtm;

    public NatViewer(Gateway gw) {
        super((Frame)JMainFrame.getJMainFrame(), messages.getString("guievents_msg29") + " " + gw.holeAnzeigeName());
        this.gw = gw;
        this.init();
        this.updateNat();
    }

    private void init() {
        this.getContentPane().removeAll();
        this.setBounds(100, 100, 840, 240);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/gfx/hardware/router.png"));
        this.setIconImage(icon.getImage());
        this.dtm = new DefaultTableModel(0, 6);
        JTable tableNATNachrichten = new JTable(this.dtm);
        DefaultTableColumnModel dtcm = (DefaultTableColumnModel)tableNATNachrichten.getColumnModel();
        dtcm.getColumn(0).setHeaderValue(messages.getString("guievents_msg30"));
        dtcm.getColumn(1).setHeaderValue(messages.getString("guievents_msg32"));
        dtcm.getColumn(2).setHeaderValue(messages.getString("guievents_msg31"));
        dtcm.getColumn(3).setHeaderValue(messages.getString("guievents_msg33"));
        dtcm.getColumn(4).setHeaderValue(messages.getString("guievents_msg34"));
        dtcm.getColumn(5).setHeaderValue(messages.getString("guievents_msg27"));
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem resetMenuItem = new JMenuItem(messages.getString("guievents_msg36"));
        resetMenuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                menu.setVisible(false);
                ((GatewayFirmware)NatViewer.this.gw.getSystemSoftware()).loescheNAT();
            }
        });
        menu.add(resetMenuItem);
        tableNATNachrichten.setComponentPopupMenu(menu);
        JScrollPane spNAT = new JScrollPane(tableNATNachrichten);
        this.getContentPane().add(spNAT);
    }

    public Gateway getGateway() {
        return this.gw;
    }

    private void updateNat() {
        this.dtm.setRowCount(0);
        for (Vector<String> zeile : ((GatewayFirmware)this.gw.getSystemSoftware()).holeNAT()) {
            this.dtm.addRow(zeile);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "nat_entry") {
            this.updateNat();
        } else if (evt.getPropertyName() == "nat_method") {
            this.init();
            this.updateNat();
        }
    }
}

