/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.documentation;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import filius.gui.GUIContainer;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.Anwendung;
import filius.software.dns.DNSServer;
import filius.software.dns.ResourceRecord;
import filius.software.system.Betriebssystem;
import filius.software.system.GatewayFirmware;
import filius.software.system.InternetKnotenBetriebssystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ReportGenerator {
    private static final Font SMALL_FONT = FontFactory.getFont("Helvetica", 8.0f, BaseColor.BLACK);
    private static final Font SMALL_BOLD_FONT = FontFactory.getFont("Helvetica-Bold", 8.0f, BaseColor.BLACK);
    private static final Font BOLD_FONT = FontFactory.getFont("Helvetica-Bold", 10.0f, BaseColor.BLACK);
    private static final Font DEFAULT_FONT = FontFactory.getFont("Helvetica", 10.0f, BaseColor.BLACK);
    private Lauscher lauscher;
    private static ReportGenerator singleton;
    private int sectionNoLevel1;
    private int sectionNoLevel2;

    ReportGenerator() {
    }

    public static ReportGenerator getInstance() {
        if (null == singleton) {
            singleton = new ReportGenerator();
            ReportGenerator.singleton.lauscher = Lauscher.getLauscher();
        }
        return singleton;
    }

    private void resetSections() {
        this.sectionNoLevel1 = 0;
        this.sectionNoLevel2 = 0;
    }

    public void generateReport(String pdfFilepath) throws DocumentException, IOException {
        Document document = this.initDocument(pdfFilepath);
        this.resetSections();
        this.addOverviewSection(document);
        document.add(Chunk.NEXTPAGE);
        this.addComponentConfigSection(document);
        document.add(Chunk.NEXTPAGE);
        this.addNetworkTrafficSection(document);
        this.closeDocument(document);
    }

    void addOverviewSection(Document document) throws BadElementException, IOException, DocumentException {
        this.createSection(document, I18n.messages.getString("report_overview"), 1);
        Image img = Image.getInstance(GUIContainer.getGUIContainer().createNetworkImage(), null);
        float percent = (document.right() - document.left()) / img.getWidth() * 100.0f;
        img.scalePercent(percent);
        document.add(img);
    }

    void addComponentConfigSection(Document document) throws BadElementException, IOException, DocumentException {
        this.createSection(document, I18n.messages.getString("report_component_config"), 1);
        List<GUIKnotenItem> components = GUIContainer.getGUIContainer().getKnotenItems();
        for (GUIKnotenItem item : components) {
            DNSServer dnsServer;
            if (!(item.getKnoten() instanceof InternetKnoten)) continue;
            InternetKnotenBetriebssystem systemSoftware = (InternetKnotenBetriebssystem)item.getKnoten().getSystemSoftware();
            this.createSection(document, item.getKnoten().holeAnzeigeName(), 2);
            this.createSection(document, I18n.messages.getString("report_base_config"), 3);
            PdfPTable configTable = new PdfPTable(2);
            configTable.setHorizontalAlignment(0);
            configTable.setTotalWidth(new float[]{180.0f, 360.0f});
            configTable.setLockedWidth(false);
            this.addConfigParam(I18n.messages.getString("jhostkonfiguration_msg5"), systemSoftware.getStandardGateway(), configTable);
            this.addConfigParam(I18n.messages.getString("jhostkonfiguration_msg6"), systemSoftware.getDNSServer(), configTable);
            if (systemSoftware instanceof Betriebssystem) {
                this.addConfigParam(I18n.messages.getString("jhostkonfiguration_msg7"), String.valueOf(((Betriebssystem)systemSoftware).isDHCPKonfiguration()), configTable);
            }
            document.add(configTable);
            document.add(Chunk.NEWLINE);
            InternetKnoten node = (InternetKnoten)item.getKnoten();
            PdfPTable interfaceTable = new PdfPTable(3);
            interfaceTable.setHorizontalAlignment(0);
            interfaceTable.setTotalWidth(new float[]{180.0f, 180.0f, 180.0f});
            interfaceTable.setLockedWidth(false);
            this.addHeaderCell(I18n.messages.getString("jhostkonfiguration_msg9"), interfaceTable);
            this.addHeaderCell(I18n.messages.getString("jhostkonfiguration_msg3"), interfaceTable);
            this.addHeaderCell(I18n.messages.getString("jhostkonfiguration_msg4"), interfaceTable);
            this.createSection(document, I18n.messages.getString("report_nics"), 3);
            for (NetzwerkInterface networkInterface : node.getNetzwerkInterfaces()) {
                this.addCell(networkInterface.getMac(), interfaceTable);
                this.addCell(networkInterface.getIp(), interfaceTable);
                this.addCell(networkInterface.getSubnetzMaske(), interfaceTable);
            }
            document.add(interfaceTable);
            document.add(Chunk.NEWLINE);
            if (systemSoftware instanceof Betriebssystem) {
                this.createSection(document, I18n.messages.getString("report_apps"), 3);
                Chunk chunk = new Chunk(I18n.messages.getString("installationsdialog_msg3") + " ", BOLD_FONT);
                document.add(chunk);
                Anwendung[] apps = ((Betriebssystem)systemSoftware).holeArrayInstallierteSoftware();
                String[] appNames = new String[apps.length];
                for (int i = 0; i < apps.length; ++i) {
                    appNames[i] = apps[i].holeAnwendungsName();
                }
                String appList = StringUtils.join((Object[])appNames, ", ");
                chunk = new Chunk(StringUtils.isBlank(appList) ? "-" : appList, DEFAULT_FONT);
                document.add(chunk);
                document.add(Chunk.NEWLINE);
                document.add(Chunk.NEWLINE);
            }
            if ((dnsServer = (DNSServer)systemSoftware.holeSoftware("filius.software.dns.DNSServer")) != null) {
                this.createSection(document, I18n.messages.getString("report_dns_rr"), 3);
                PdfPTable dnsTable = new PdfPTable(3);
                dnsTable.setHorizontalAlignment(0);
                dnsTable.setTotalWidth(new float[]{180.0f, 60.0f, 260.0f});
                dnsTable.setLockedWidth(false);
                this.addHeaderCell(I18n.messages.getString("report_domain"), dnsTable);
                this.addHeaderCell(I18n.messages.getString("report_type"), dnsTable);
                this.addHeaderCell(I18n.messages.getString("report_data"), dnsTable);
                for (ResourceRecord resourceRecord : dnsServer.holeResourceRecords()) {
                    this.addCell(resourceRecord.getDomainname(), dnsTable);
                    this.addCell(resourceRecord.getType(), dnsTable);
                    this.addCell(resourceRecord.getRdata(), dnsTable);
                }
                document.add(dnsTable);
                document.add(Chunk.NEWLINE);
            }
            this.createSection(document, I18n.messages.getString("report_routing_table"), 3);
            PdfPTable forwardingTable = new PdfPTable(4);
            forwardingTable.setHorizontalAlignment(0);
            forwardingTable.setTotalWidth(new float[]{180.0f, 180.0f, 180.0f, 180.0f});
            forwardingTable.setLockedWidth(false);
            this.addHeaderCell(I18n.messages.getString("jweiterleitungstabelle_msg3"), forwardingTable);
            this.addHeaderCell(I18n.messages.getString("jweiterleitungstabelle_msg4"), forwardingTable);
            this.addHeaderCell(I18n.messages.getString("jweiterleitungstabelle_msg5"), forwardingTable);
            this.addHeaderCell(I18n.messages.getString("jweiterleitungstabelle_msg6"), forwardingTable);
            for (String[] routeEntry : systemSoftware.getWeiterleitungstabelle().holeTabelle()) {
                if (!EingabenUeberpruefung.isGueltig(routeEntry[0], EingabenUeberpruefung.musterIpAdresse)) continue;
                for (int i = 0; i < routeEntry.length; ++i) {
                    this.addCell(routeEntry[i], forwardingTable);
                }
            }
            document.add(forwardingTable);
            document.add(Chunk.NEWLINE);
            if (!(systemSoftware instanceof GatewayFirmware)) continue;
            PdfPTable portForwardingTable = new PdfPTable(4);
            portForwardingTable.setHorizontalAlignment(0);
            portForwardingTable.setTotalWidth(new float[]{180.0f, 180.0f, 180.0f, 180.0f});
            portForwardingTable.setLockedWidth(false);
            this.addHeaderCell(I18n.messages.getString("jportforwarding_msg4"), portForwardingTable);
            this.addHeaderCell(I18n.messages.getString("jportforwarding_msg5"), portForwardingTable);
            this.addHeaderCell(I18n.messages.getString("jportforwarding_msg6"), portForwardingTable);
            this.addHeaderCell(I18n.messages.getString("jportforwarding_msg7"), portForwardingTable);
            boolean notEmpty = false;
            for (String[] routeEntry : ((GatewayFirmware)systemSoftware).getStaticNAT()) {
                System.out.println(routeEntry[0] + " " + String.valueOf(EingabenUeberpruefung.musterProtocol));
                if (!EingabenUeberpruefung.isGueltig(routeEntry[0], EingabenUeberpruefung.musterProtocol)) continue;
                notEmpty = true;
                switch (routeEntry[0]) {
                    case "6": 
                    case "TCP": {
                        routeEntry[0] = "TCP";
                        break;
                    }
                    case "17": 
                    case "UDP": {
                        routeEntry[0] = "UDP";
                    }
                }
                for (int i = 0; i < routeEntry.length; ++i) {
                    this.addCell(routeEntry[i], portForwardingTable);
                }
            }
            if (!notEmpty) continue;
            this.createSection(document, I18n.messages.getString("jgatewayconfiguration_msg19"), 3);
            document.add(portForwardingTable);
            document.add(Chunk.NEWLINE);
        }
    }

    private void addConfigParam(String key, String value, PdfPTable table) {
        this.addHeaderCell(key, table);
        this.addCell(value, table);
    }

    private void addCell(String value, PdfPTable table) {
        PdfPCell cell = new PdfPCell(new Phrase(value, DEFAULT_FONT));
        cell.setBorder(0);
        table.addCell(cell);
    }

    private void addHeaderCell(String key, PdfPTable table) {
        PdfPHeaderCell header = new PdfPHeaderCell();
        header.setBorder(0);
        header.setPhrase(new Phrase(key, BOLD_FONT));
        table.addCell(header);
    }

    void addNetworkTrafficSection(Document document) throws BadElementException, IOException, DocumentException {
        String[] columnHeader = this.lauscher.getHeader();
        Collection<String> interfaceIDs = this.lauscher.getInterfaceIDs();
        if (interfaceIDs.size() > 0) {
            this.createSection(document, I18n.messages.getString("report_network_traffic"), 1);
        }
        for (String interfaceId : interfaceIDs) {
            String hostname = "Unknown";
            String ipAddress = "0.0.0.0";
            for (GUIKnotenItem item : GUIContainer.getGUIContainer().getKnotenItems()) {
                InternetKnoten node;
                NetzwerkInterface nic;
                if (!(item.getKnoten() instanceof InternetKnoten) || (nic = (node = (InternetKnoten)item.getKnoten()).getNetzwerkInterfaceByMac(interfaceId)) == null) continue;
                hostname = item.getKnoten().holeAnzeigeName();
                ipAddress = nic.getIp();
                break;
            }
            this.createSection(document, hostname + " - " + ipAddress, 2);
            PdfPTable table = new PdfPTable(columnHeader.length);
            table.setTotalWidth(new float[]{20.0f, 60.0f, 80.0f, 80.0f, 40.0f, 50.0f, 180.0f});
            table.setLockedWidth(true);
            for (int i = 0; i < columnHeader.length; ++i) {
                PdfPHeaderCell header = new PdfPHeaderCell();
                header.setBackgroundColor(new BaseColor(230, 240, 255));
                header.setBorder(0);
                header.setPhrase(new Phrase(columnHeader[i], SMALL_BOLD_FONT));
                table.addCell(header);
            }
            Object[][] data = this.lauscher.getDaten(interfaceId, true, 0);
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    PdfPCell cell = new PdfPCell(new Phrase((String)data[i][j], SMALL_FONT));
                    cell.setBorder(0);
                    if (i % 2 == 1) {
                        cell.setBackgroundColor(new BaseColor(240, 240, 240));
                    }
                    table.addCell(cell);
                }
            }
            document.add(table);
            document.add(Chunk.NEWLINE);
        }
    }

    private void createSection(Document document, String title, int level) throws DocumentException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        if (level == 1) {
            numbers.add(++this.sectionNoLevel1);
            this.sectionNoLevel2 = 0;
        } else if (level == 2) {
            numbers.add(++this.sectionNoLevel2);
            numbers.add(this.sectionNoLevel1);
        }
        Font font = FontFactory.getFont("Helvetica-Bold", (float)(16 - 2 * level), BaseColor.DARK_GRAY);
        Paragraph sectionHeader = Section.constructTitle(new Paragraph(title, font), numbers, level, 0);
        document.add(sectionHeader);
    }

    void closeDocument(Document document) {
        document.close();
        GUIContainer.getGUIContainer().updateViewport();
    }

    Document initDocument(String pdfFilepath) throws DocumentException, FileNotFoundException {
        Object title;
        Document document = new Document();
        PdfWriter.getInstance(document, new FileOutputStream(pdfFilepath));
        document.open();
        String storagePath = SzenarioVerwaltung.getInstance().holePfad();
        if (storagePath != null) {
            String filename = new File(storagePath).getName();
            if (filename.contains(".")) {
                filename = filename.substring(0, filename.lastIndexOf(46));
            }
            title = I18n.messages.getString("report_title") + ": " + filename;
        } else {
            title = I18n.messages.getString("report_title");
        }
        document.addTitle((String)title);
        document.addCreator("Filius (www.lernsoftware-filius.de)");
        Font font = FontFactory.getFont("Helvetica-Bold", 18.0f, new BaseColor(30, 50, 120));
        Paragraph paragraph = new Paragraph((String)title, font);
        paragraph.setAlignment(1);
        document.add(paragraph);
        if (null != storagePath) {
            document.add(new Chunk(storagePath, SMALL_FONT));
        }
        document.add(Chunk.NEWLINE);
        return document;
    }
}

