/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.AggregatedExchangeComponent;
import filius.gui.nachrichtensicht.AggregatedMessageTable;
import filius.gui.nachrichtensicht.MessageDetails;
import filius.gui.nachrichtensicht.MessageDetailsPanel;
import filius.gui.nachrichtensicht.MessageDetailsTable;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class AggregatedExchangePanel
extends JTabbedPane
implements AggregatedExchangeComponent,
I18n,
Observer {
    private Hashtable<String, JPanel> openedTabs = new Hashtable();
    private Hashtable<String, InternetKnotenBetriebssystem> systems = new Hashtable();
    private Hashtable<String, AggregatedMessageTable> tabellen = new Hashtable();

    @Override
    public void addTable(SystemSoftware system, final String identifier) {
        system.addObserver(this);
        final MessageDetails messageDetails = Information.getInformation().isLayerVisualization() ? new MessageDetailsTable(identifier, 0, Color.WHITE) : new MessageDetailsPanel(identifier);
        if (this.openedTabs.get(identifier) == null) {
            final AggregatedMessageTable tabelle = new AggregatedMessageTable(this, identifier, system);
            tabelle.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (tabelle.getSelectedRow() >= 0) {
                        messageDetails.update(identifier, tabelle.getSelectedRow() + 1);
                    } else {
                        messageDetails.clear();
                    }
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(tabelle);
            tabelle.setScrollPane(scrollPane);
            JSplitPane splitPane = new JSplitPane();
            splitPane.setEnabled(false);
            splitPane.setDividerLocation(500);
            splitPane.setOrientation(0);
            splitPane.setTopComponent(scrollPane);
            splitPane.setBottomComponent(new JScrollPane(messageDetails));
            splitPane.setOneTouchExpandable(true);
            panel.add((Component)splitPane, "Center");
            this.add(panel);
            this.setSelectedComponent(panel);
            TabTitle title = new TabTitle(this, identifier);
            this.setTabComponentAt(this.getSelectedIndex(), title);
            this.openedTabs.put(identifier, panel);
            this.systems.put(identifier, (InternetKnotenBetriebssystem)system);
            this.tabellen.put(identifier, tabelle);
            if (this.openedTabs.size() > 0) {
                this.setVisible(true);
            }
            this.updateTabTitle();
        } else {
            this.setSelectedComponent(this.openedTabs.get(identifier));
            this.tabellen.get(identifier).update();
        }
    }

    void updateTabTitle() {
        block0: for (int i = 0; i < this.getTabCount(); ++i) {
            for (String identifier : this.openedTabs.keySet()) {
                if (!this.getComponentAt(i).equals(this.openedTabs.get(identifier))) continue;
                SystemSoftware system = this.systems.get(identifier);
                String ipAddress = ((InternetKnoten)system.getKnoten()).getNetzwerkInterfaceByMac(identifier).getIp();
                Object tabTitle = system.getKnoten() instanceof Host && ((Host)system.getKnoten()).isUseIPAsName() ? ipAddress : system.getKnoten().holeAnzeigeName() + " - " + ipAddress;
                TabTitle titlePanel = (TabTitle)this.getTabComponentAt(i);
                titlePanel.setTitle((String)tabTitle);
                continue block0;
            }
        }
    }

    void clearUnavailableComponents() {
        for (Map.Entry<String, InternetKnotenBetriebssystem> system : this.systems.entrySet()) {
            if (system.getValue().isStarted()) continue;
            this.removeTable(system.getKey());
        }
    }

    private void removeTable(String mac) {
        this.removeTable(mac, this.openedTabs.get(mac));
    }

    @Override
    public void removeTable(String mac, JPanel panel) {
        if (mac != null) {
            this.openedTabs.remove(mac);
            this.tabellen.remove(mac);
            this.remove(panel);
            if (this.openedTabs.size() == 0) {
                this.setVisible(false);
            }
        }
    }

    @Override
    public String getTabTitle(String interfaceId) {
        String title = interfaceId.replaceAll(":", "-");
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tab = this.getComponentAt(i);
            if (tab != this.openedTabs.get(interfaceId)) continue;
            title = ((TabTitle)this.getTabComponentAt(i)).getTitle();
            break;
        }
        return title;
    }

    @Override
    public void reset() {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateTabTitle();
    }

    private class TabTitle
    extends JPanel {
        private JLabel label;

        TabTitle(final AggregatedExchangePanel parent, final String identifier) {
            this.setOpaque(false);
            this.label = new JLabel();
            this.add((Component)this.label, "West");
            JButton btnClose = new JButton("X");
            btnClose.setUI(new BasicButtonUI());
            btnClose.setForeground(Color.GRAY);
            btnClose.setBorder(BorderFactory.createEmptyBorder());
            btnClose.setPreferredSize(new Dimension(18, 18));
            btnClose.setToolTipText(I18n.messages.getString("buttontabcomponent_msg1"));
            this.add((Component)btnClose, "East");
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    parent.removeTable(identifier);
                }
            });
        }

        void setTitle(String title) {
            this.label.setText(title);
        }

        String getTitle() {
            return this.label.getText();
        }
    }
}

