/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.JMainFrame;
import filius.gui.nachrichtensicht.AggregatedExchangeComponent;
import filius.gui.nachrichtensicht.LauscherTableCellRenderer;
import filius.gui.nachrichtensicht.LauscherTableModel;
import filius.gui.schichtensicht.GlobalLayerPath;
import filius.gui.schichtensicht.LayerPathDialog;
import filius.gui.schichtensicht.LocalLayerPathPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;
import filius.software.system.SystemSoftware;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedMessageTable
extends JTable
implements LauscherBeobachter,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(AggregatedMessageTable.class);
    private static final int EXPORT_MAX_LINES_PER_MESSAGE = 5;
    private static final long serialVersionUID = 1L;
    public static final int SCHICHT_SPALTE = 5;
    public static final int BEMERKUNG_SPALTE = 6;
    public static final int LFD_NR_SPALTE = 0;
    private SystemSoftware systemSoftware;
    private String interfaceId;
    private int selectedRowByRightclick;
    private JCheckBoxMenuItem checkbox;
    private AggregatedExchangeComponent exchangeComponent;
    private JScrollPane scrollPane = null;
    private boolean autoscroll = true;
    private JPopupMenu menu;

    public AggregatedMessageTable(AggregatedExchangeComponent component, String macAddress, SystemSoftware systemSoftware) {
        this.systemSoftware = systemSoftware;
        this.exchangeComponent = component;
        this.setinterfaceId(macAddress);
        this.initTableModel();
        this.setAutoResizeMode(3);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        String[] spalten = Lauscher.SPALTEN;
        for (int i = 0; i < spalten.length; ++i) {
            TableColumn col = new TableColumn();
            col.setHeaderValue(spalten[i]);
            col.setIdentifier(spalten[i]);
            col.setModelIndex(i);
            columnModel.addColumn(col);
        }
        this.setColumnModel(columnModel);
        this.setIntercellSpacing(new Dimension(0, 5));
        this.setRowHeight(25);
        this.setEnabled(true);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setBackground(Color.DARK_GRAY);
        this.getTableHeader().setReorderingAllowed(false);
        this.setFillsViewportHeight(true);
        this.initTableColumnWidth();
        this.setDefaultRenderer(Object.class, new LauscherTableCellRenderer());
        this.initKontextMenue();
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    AggregatedMessageTable target = (AggregatedMessageTable)e.getSource();
                    target.selectedRowByRightclick = target.rowAtPoint(e.getPoint());
                    if (target.selectedRowByRightclick == -1) {
                        AggregatedMessageTable.this.disablePathOptions();
                    } else {
                        target.setRowSelectionInterval(target.selectedRowByRightclick, target.selectedRowByRightclick);
                        AggregatedMessageTable.this.enablePathOptions();
                    }
                    AggregatedMessageTable.this.menu.setVisible(true);
                    AggregatedMessageTable.this.menu.show(AggregatedMessageTable.this.getTabelle(), e.getX(), e.getY());
                }
            }
        });
        this.update();
    }

    private void initTableModel() {
        LauscherTableModel tableModel = new LauscherTableModel();
        tableModel.addTableModelListener(this);
        tableModel.setColumnIdentifiers(Lauscher.SPALTEN);
        this.setModel(tableModel);
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    private AggregatedMessageTable getTabelle() {
        return this;
    }

    private void initTableColumnWidth() {
        this.getColumnModel().getColumn(0).setMaxWidth(40);
        this.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.getColumnModel().getColumn(1).setMaxWidth(120);
        this.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.getColumnModel().getColumn(2).setMaxWidth(180);
        this.getColumnModel().getColumn(2).setPreferredWidth(160);
        this.getColumnModel().getColumn(3).setMaxWidth(180);
        this.getColumnModel().getColumn(3).setPreferredWidth(160);
        this.getColumnModel().getColumn(4).setMaxWidth(100);
        this.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.getColumnModel().getColumn(5).setMaxWidth(140);
        this.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.getColumnModel().getColumn(6).setMaxWidth(Integer.MAX_VALUE);
        this.getColumnModel().getColumn(6).setPreferredWidth(460);
        this.getColumnModel().getColumn(6).setResizable(true);
    }

    private int initKontextMenue() {
        this.menu = new JPopupMenu();
        final AggregatedMessageTable target = this;
        if (Information.getInformation().isLayerVisualization()) {
            JMenuItem globalPathThroughLayersMenuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg11"));
            globalPathThroughLayersMenuItem.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (AggregatedMessageTable.this.isPathOptionsEnabled()) {
                        AggregatedMessageTable.this.menu.setVisible(false);
                        AggregatedMessageTable.this.showGlobalPathThroughLayers(AggregatedMessageTable.this.systemSoftware, target.selectedRowByRightclick + 1);
                    }
                }
            });
            this.menu.add(globalPathThroughLayersMenuItem);
        }
        JMenuItem resetMenuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg7"));
        resetMenuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AggregatedMessageTable.this.menu.setVisible(false);
                Lauscher.getLauscher().reset();
            }
        });
        this.menu.add(resetMenuItem);
        JMenuItem exportMenuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg9"));
        exportMenuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AggregatedMessageTable.this.menu.setVisible(false);
                FileDialog fileDialog = new FileDialog((Frame)JMainFrame.getJMainFrame(), I18n.messages.getString("main_msg4"), 1);
                FilenameFilter filiusFilenameFilter = (dir, name) -> name.endsWith(".txt");
                fileDialog.setFilenameFilter(filiusFilenameFilter);
                String path = SzenarioVerwaltung.getInstance().holePfad();
                if (path != null) {
                    File preselectedFile = new File(AggregatedMessageTable.this.exchangeComponent.getTabTitle(AggregatedMessageTable.this.interfaceId) + ".txt");
                    fileDialog.setFile(preselectedFile.toString());
                }
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null) {
                    Path outFile;
                    boolean nameChanged = false;
                    if (StringUtils.endsWith(fileDialog.getFile(), ".txt")) {
                        outFile = Path.of(fileDialog.getDirectory(), fileDialog.getFile());
                    } else {
                        nameChanged = true;
                        outFile = Path.of(fileDialog.getDirectory(), fileDialog.getFile() + ".txt");
                    }
                    int entscheidung = 0;
                    if (nameChanged && outFile.toFile().exists()) {
                        entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), I18n.messages.getString("guimainmemu_msg17"), I18n.messages.getString("guimainmemu_msg10"), 0);
                    }
                    if (entscheidung == 0) {
                        try (FileOutputStream outputStream = new FileOutputStream(outFile.toString());){
                            AggregatedMessageTable.this.writeToStream(outputStream);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.menu.add(exportMenuItem);
        this.checkbox = new JCheckBoxMenuItem(messages.getString("nachrichtentabelle_msg8"), this.autoscroll);
        this.checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AggregatedMessageTable.this.autoscroll != AggregatedMessageTable.this.checkbox.getState()) {
                    AggregatedMessageTable.this.menu.setVisible(false);
                    AggregatedMessageTable.this.autoscroll = AggregatedMessageTable.this.checkbox.getState();
                    AggregatedMessageTable.this.update();
                }
            }
        });
        this.menu.add(this.checkbox);
        this.menu.setVisible(false);
        this.exchangeComponent.getRootPane().getLayeredPane().add(this.menu);
        return this.menu.getComponentCount();
    }

    private void enablePathOptions() {
        if (!this.menu.getComponent(0).isEnabled() && !this.menu.getComponent(1).isEnabled()) {
            this.menu.getComponent(0).setEnabled(true);
            this.menu.getComponent(1).setEnabled(true);
        }
    }

    private void disablePathOptions() {
        if (this.menu.getComponent(0).isEnabled() && this.menu.getComponent(1).isEnabled()) {
            this.menu.getComponent(0).setEnabled(false);
            this.menu.getComponent(1).setEnabled(false);
        }
    }

    private boolean isPathOptionsEnabled() {
        return this.menu.getComponent(0).isEnabled() && this.menu.getComponent(1).isEnabled();
    }

    private void setinterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        Lauscher.getLauscher().addBeobachter(interfaceId, this);
    }

    @Override
    public synchronized void update() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (NachrichtenTabelle), update()");
        int selectedRow = this.getSelectedRow();
        Object[][] daten = Lauscher.getLauscher().getDaten(this.interfaceId, true, 0);
        if (daten.length == 0) {
            this.initTableModel();
            this.initTableColumnWidth();
        }
        int lastNo = -1;
        if (this.getModel().getRowCount() > 0) {
            lastNo = Integer.parseInt(this.getModel().getValueAt(this.getModel().getRowCount() - 1, 0).toString());
        }
        int currentNo = 1;
        int previousNo = 1;
        for (int i = 0; i < daten.length; ++i) {
            currentNo = Integer.parseInt(daten[i][0].toString());
            if (currentNo <= lastNo || currentNo == previousNo || currentNo <= previousNo || previousNo <= lastNo || i <= 0) continue;
            Object[] row = daten[i - 1];
            this.addRowData(row);
            previousNo = currentNo;
        }
        if (currentNo > lastNo && daten.length > 0) {
            this.addRowData(daten[daten.length - 1]);
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
        if (this.getModel().getRowCount() > 0 && this.scrollPane != null && this.scrollPane.getViewport() != null && this.autoscroll) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, this.getHeight()));
        }
        if (selectedRow >= 0 && selectedRow < this.getModel().getRowCount()) {
            this.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void addRowData(Object[] row) {
        Vector<Object> rowData = new Vector<Object>(row.length);
        for (int col = 0; col < row.length; ++col) {
            rowData.add(col, row[col]);
        }
        ((DefaultTableModel)this.getModel()).addRow(rowData);
    }

    @Override
    public synchronized void writeToStream(OutputStream outputStream) throws IOException {
        Object[] columnNames = this.getColumnHeader();
        StringBuilder tmplBuilder = new StringBuilder("| ");
        StringBuilder lineSeparatorBuilder = new StringBuilder("+");
        for (int colIdx = 0; colIdx < this.getColumnCount(); ++colIdx) {
            if (colIdx == 6) {
                tmplBuilder.append("%-40s | ");
                lineSeparatorBuilder.append(StringUtils.repeat('-', 42) + "+");
                continue;
            }
            if (colIdx == 0) {
                tmplBuilder.append("%-10s | ");
                lineSeparatorBuilder.append(StringUtils.repeat('-', 12) + "+");
                continue;
            }
            tmplBuilder.append("%-20s | ");
            lineSeparatorBuilder.append(StringUtils.repeat('-', 22) + "+");
        }
        tmplBuilder.append("\r\n");
        String rowTemplate = tmplBuilder.toString();
        lineSeparatorBuilder.append("\r\n");
        String lineSeparator = lineSeparatorBuilder.toString();
        outputStream.write(lineSeparator.replace('-', '=').getBytes("UTF8"));
        outputStream.write(String.format(rowTemplate, columnNames).getBytes("UTF8"));
        outputStream.write(lineSeparator.replace('-', '=').getBytes("UTF8"));
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            String[] values = new String[this.getColumnCount()];
            for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
                values[columnIndex] = this.getModel().getValueAt(rowIndex, columnIndex).toString();
            }
            List<String[]> lineData = AggregatedMessageTable.prepareDataArrays(values, 40);
            for (String[] data : lineData) {
                outputStream.write(String.format(rowTemplate, data).getBytes("UTF8"));
            }
            outputStream.write(lineSeparator.getBytes("UTF8"));
        }
    }

    public Object[] getColumnHeader() {
        Object[] columnNames = new Object[this.getColumnCount()];
        for (int colIdx = 0; colIdx < this.getColumnCount(); ++colIdx) {
            columnNames[colIdx] = this.getColumnName(colIdx);
        }
        return columnNames;
    }

    static List<String[]> prepareDataArrays(String[] values, int maxRemarkLength) {
        List<Object> remarks = Collections.emptyList();
        Object[] data = new String[values.length];
        for (int columnIndex = 0; columnIndex < values.length; ++columnIndex) {
            if (columnIndex == 6) {
                if (!StringUtils.isNoneBlank(values[columnIndex])) continue;
                remarks = AggregatedMessageTable.splitString(values[columnIndex].toString(), maxRemarkLength);
                data[columnIndex] = (String)remarks.get(0);
                continue;
            }
            data[columnIndex] = values[columnIndex];
        }
        ArrayList<String[]> lineData = new ArrayList<String[]>();
        lineData.add((String[])data);
        for (int i = 1; i < remarks.size() && i < 5; ++i) {
            data = new String[values.length];
            Arrays.fill(data, "");
            data[6] = (String)remarks.get(i);
            lineData.add((String[])data);
        }
        if (remarks.size() > 5) {
            data = new String[values.length];
            Arrays.fill(data, "");
            data[6] = "...";
            lineData.add((String[])data);
        }
        return lineData;
    }

    static List<String> splitString(String text, int maxLength) {
        String normalizedText = StringUtils.normalizeSpace(text);
        String[] tokens = normalizedText.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        int currentLength = 0;
        StringBuilder lineBuilder = new StringBuilder();
        for (String token : tokens) {
            if (currentLength + token.length() <= maxLength) {
                lineBuilder.append(token).append(" ");
                currentLength += token.length() + 1;
                continue;
            }
            if (token.length() > maxLength) {
                if (currentLength > 0) {
                    lines.add(lineBuilder.toString().trim());
                }
                String[] parts = token.split("(?<=\\G.{" + maxLength + "})");
                for (int i = 0; i < parts.length - 1; ++i) {
                    lines.add(parts[i]);
                }
                lineBuilder = new StringBuilder(parts[parts.length - 1]).append(" ");
                currentLength = parts[parts.length - 1].length() + 1;
                continue;
            }
            lines.add(lineBuilder.toString().trim());
            lineBuilder = new StringBuilder(token).append(" ");
            currentLength = token.length() + 1;
        }
        lines.add(lineBuilder.toString().trim());
        return lines;
    }

    private void showLocalPathThroughLayers(SystemSoftware systemSoftware, int frameNumber) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (AggregatedMessageTable), showLocalPathThroughLayers()");
        new LayerPathDialog(JMainFrame.getJMainFrame(), this.interfaceId, systemSoftware, frameNumber, null, true);
    }

    private void showGlobalPathThroughLayers(SystemSoftware systemSoftware, int frameNumber) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (AggregatedMessageTable), showGlobalPathThroughLayers()");
        if (LocalLayerPathPanel.isFrameSent(this.interfaceId, frameNumber) && Lauscher.getLauscher().getFrame(this.interfaceId, frameNumber).getZielMacAdresse().equals("FF:FF:FF:FF:FF:FF")) {
            JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), messages.getString("nachrichtentabelle_msg12"));
        } else {
            new GlobalLayerPath(JMainFrame.getJMainFrame(), this.interfaceId, systemSoftware, frameNumber);
        }
    }

    public static enum LayerColorVar {
        DEFAULT(Color.BLACK, Color.decode("#A6A6A6"), Color.WHITE, Color.WHITE, Color.WHITE),
        LINK(Color.BLACK, Color.decode("#A6A6A6"), Color.decode("#C9C9C9"), Color.decode("#DBDBDB"), Color.decode("#F2F2F2")),
        INTERNET(Color.BLACK, Color.decode("#A6A6A6"), Color.decode("#8FAADC"), Color.decode("#B4C6E7"), Color.decode("#D9E2F3")),
        TRANSPORT(Color.BLACK, Color.decode("#A6A6A6"), Color.decode("#F4B183"), Color.decode("#F7CAAC"), Color.decode("#FBE4D5")),
        APPLICATION(Color.BLACK, Color.decode("#A6A6A6"), Color.decode("#FFD966"), Color.decode("#FFE599"), Color.decode("#FFF2CC"));

        public final Color foregroundColor;
        public final Color foregroundColorGreyedOut;
        public final Color backgroundColor;
        public final Color backgroundColorFine;
        public final Color backgroundColorUltraFine;

        private LayerColorVar(Color foregroundColor, Color foregroundColorGreyedOut, Color backgroundColor, Color backgroundColorFine, Color backgroundColorUltraFine) {
            this.foregroundColor = foregroundColor;
            this.foregroundColorGreyedOut = foregroundColorGreyedOut;
            this.backgroundColor = backgroundColor;
            this.backgroundColorFine = backgroundColorFine;
            this.backgroundColorUltraFine = backgroundColorUltraFine;
        }

        public static Color getLayerColorVar(String typeOfColor, int layerNumber) {
            String layerName = null;
            if (layerNumber == 1) {
                layerName = "LINK";
            } else if (layerNumber == 2) {
                layerName = "INTERNET";
            } else if (layerNumber == 3) {
                layerName = "TRANSPORT";
            } else if (layerNumber == 4) {
                layerName = "APPLICATION";
            }
            Color color = null;
            if (typeOfColor == "foregroundColor") {
                color = LayerColorVar.valueOf((String)layerName).foregroundColor;
            } else if (typeOfColor == "foregroundColorGreyedOut") {
                color = LayerColorVar.valueOf((String)layerName).foregroundColorGreyedOut;
            } else if (typeOfColor == "backgroundColor") {
                color = LayerColorVar.valueOf((String)layerName).backgroundColor;
            } else if (typeOfColor == "backgroundColorFine") {
                color = LayerColorVar.valueOf((String)layerName).backgroundColorFine;
            } else if (typeOfColor == "backgroundColorUltraFine") {
                color = LayerColorVar.valueOf((String)layerName).backgroundColorUltraFine;
            }
            return color;
        }
    }

    public static enum LayerColorOrig {
        DEFAULT(Color.WHITE, Color.GRAY),
        LINK(Color.BLACK, new Color(0.9f, 0.9f, 0.9f)),
        INTERNET(Color.BLACK, new Color(0.3f, 1.0f, 0.3f)),
        TRANSPORT(Color.BLACK, Color.CYAN),
        APPLICATION(Color.WHITE, Color.BLUE);

        public final Color foregroundColor;
        public final Color backgroundColor;

        private LayerColorOrig(Color foregroundColor, Color backgroundColor) {
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
        }
    }
}

