/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.LauscherTableCellRenderer;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayeredMessageTable
extends JTable
implements LauscherBeobachter,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(LayeredMessageTable.class);
    private static final long serialVersionUID = 1L;
    public static final int SCHICHT_SPALTE = 5;
    private String interfaceId;
    private boolean netzzugangVisible = true;
    private boolean vermittlungVisible = true;
    private boolean transportVisible = true;
    private boolean anwendungVisible = true;
    private JCheckBoxMenuItem checkbox;
    private JDialog schichtenKonfigDialog;
    private JDialog dialog;
    private JScrollPane scrollPane = null;
    private boolean autoscroll = true;
    private JPopupMenu menu;

    public LayeredMessageTable(JDialog dialog, String macAddress) {
        this.dialog = dialog;
        this.setinterfaceId(macAddress);
        this.initTableModel();
        this.setAutoResizeMode(3);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        String[] spalten = Lauscher.SPALTEN;
        for (int i = 0; i < spalten.length; ++i) {
            TableColumn col = new TableColumn();
            col.setHeaderValue(spalten[i]);
            col.setIdentifier(spalten[i]);
            col.setModelIndex(i);
            columnModel.addColumn(col);
        }
        this.setColumnModel(columnModel);
        this.setIntercellSpacing(new Dimension(0, 5));
        this.setRowHeight(25);
        this.setEnabled(false);
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setBackground(Color.DARK_GRAY);
        this.getTableHeader().setReorderingAllowed(false);
        this.setFillsViewportHeight(true);
        this.initTableColumnWidth();
        this.setDefaultRenderer(Object.class, new LauscherTableCellRenderer());
        this.initKontextMenue();
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    LayeredMessageTable.this.menu.setVisible(true);
                    LayeredMessageTable.this.menu.show(LayeredMessageTable.this.getTabelle(), e.getX(), e.getY());
                }
            }
        });
        this.update();
    }

    private void initTableModel() {
        DefaultTableModel tableModel = new DefaultTableModel();
        this.setModel(tableModel);
        tableModel.addTableModelListener(this);
        tableModel.setColumnIdentifiers(Lauscher.SPALTEN);
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    private JDialog getDialog() {
        return this.dialog;
    }

    private LayeredMessageTable getTabelle() {
        return this;
    }

    private void initTableColumnWidth() {
        this.getColumnModel().getColumn(0).setMaxWidth(40);
        this.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.getColumnModel().getColumn(1).setMaxWidth(120);
        this.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.getColumnModel().getColumn(2).setMaxWidth(180);
        this.getColumnModel().getColumn(2).setPreferredWidth(140);
        this.getColumnModel().getColumn(3).setMaxWidth(180);
        this.getColumnModel().getColumn(3).setPreferredWidth(140);
        this.getColumnModel().getColumn(4).setMaxWidth(100);
        this.getColumnModel().getColumn(4).setPreferredWidth(70);
        this.getColumnModel().getColumn(5).setMaxWidth(140);
        this.getColumnModel().getColumn(5).setPreferredWidth(100);
        this.getColumnModel().getColumn(6).setMaxWidth(Integer.MAX_VALUE);
        this.getColumnModel().getColumn(6).setPreferredWidth(500);
        this.getColumnModel().getColumn(6).setResizable(true);
    }

    private void initKontextMenue() {
        this.schichtenKonfigDialog = new JDialog(this.dialog);
        this.schichtenKonfigDialog.setTitle(messages.getString("nachrichtentabelle_msg1"));
        this.schichtenKonfigDialog.setModal(true);
        this.schichtenKonfigDialog.setBounds(50, 50, 200, 150);
        this.schichtenKonfigDialog.setResizable(false);
        this.schichtenKonfigDialog.getContentPane().setLayout(new FlowLayout());
        ((FlowLayout)this.schichtenKonfigDialog.getContentPane().getLayout()).setAlignment(0);
        final JCheckBox netzzugangCheckBox = new JCheckBox(messages.getString("nachrichtentabelle_msg2"), this.netzzugangVisible);
        final JCheckBox vermittlungCheckBox = new JCheckBox(messages.getString("nachrichtentabelle_msg3"), this.vermittlungVisible);
        final JCheckBox transportCheckBox = new JCheckBox(messages.getString("nachrichtentabelle_msg4"), this.transportVisible);
        final JCheckBox anwendungCheckBox = new JCheckBox(messages.getString("nachrichtentabelle_msg5"), this.anwendungVisible);
        this.schichtenKonfigDialog.getContentPane().add(netzzugangCheckBox);
        this.schichtenKonfigDialog.getContentPane().add(vermittlungCheckBox);
        this.schichtenKonfigDialog.getContentPane().add(transportCheckBox);
        this.schichtenKonfigDialog.getContentPane().add(anwendungCheckBox);
        this.menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg6"));
        menuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LayeredMessageTable.this.menu.setVisible(false);
                int x = LayeredMessageTable.this.getDialog().getX() + LayeredMessageTable.this.getDialog().getWidth() / 2 - LayeredMessageTable.this.schichtenKonfigDialog.getWidth() / 2;
                int y = LayeredMessageTable.this.getDialog().getY() + LayeredMessageTable.this.getDialog().getHeight() / 2 - LayeredMessageTable.this.schichtenKonfigDialog.getHeight() / 2;
                LayeredMessageTable.this.schichtenKonfigDialog.setBounds(x, y, LayeredMessageTable.this.schichtenKonfigDialog.getWidth(), LayeredMessageTable.this.schichtenKonfigDialog.getHeight());
                LayeredMessageTable.this.schichtenKonfigDialog.setVisible(true);
                LayeredMessageTable.this.netzzugangVisible = netzzugangCheckBox.isSelected();
                LayeredMessageTable.this.vermittlungVisible = vermittlungCheckBox.isSelected();
                LayeredMessageTable.this.transportVisible = transportCheckBox.isSelected();
                LayeredMessageTable.this.anwendungVisible = anwendungCheckBox.isSelected();
                LayeredMessageTable.this.initTableModel();
                LayeredMessageTable.this.update();
            }
        });
        this.menu.add(menuItem);
        menuItem = new JMenuItem(messages.getString("nachrichtentabelle_msg7"));
        menuItem.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LayeredMessageTable.this.menu.setVisible(false);
                Lauscher.getLauscher().reset();
            }
        });
        this.menu.add(menuItem);
        this.checkbox = new JCheckBoxMenuItem(messages.getString("nachrichtentabelle_msg8"), this.autoscroll);
        this.checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LayeredMessageTable.this.autoscroll != LayeredMessageTable.this.checkbox.getState()) {
                    LayeredMessageTable.this.menu.setVisible(false);
                    LayeredMessageTable.this.autoscroll = LayeredMessageTable.this.checkbox.getState();
                    LayeredMessageTable.this.update();
                }
            }
        });
        this.menu.add(this.checkbox);
        this.menu.setVisible(false);
        this.dialog.getRootPane().getLayeredPane().add(this.menu);
    }

    private void setinterfaceId(String interfaceId) {
        this.interfaceId = interfaceId;
        Lauscher.getLauscher().addBeobachter(interfaceId, this);
    }

    @Override
    public synchronized void update() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (NachrichtenTabelle), update()");
        Object[][] daten = Lauscher.getLauscher().getDaten(this.interfaceId, false, 1);
        if (daten.length == 0) {
            this.initTableModel();
        }
        int lastNo = -1;
        if (this.getModel().getRowCount() > 0) {
            lastNo = Integer.parseInt(this.getModel().getValueAt(this.getModel().getRowCount() - 1, 0).toString());
        }
        for (int i = 0; i < daten.length; ++i) {
            int currentNo = Integer.parseInt(daten[i][0].toString());
            if (currentNo <= lastNo) continue;
            boolean isValid = false;
            if (daten[i][5].equals(Lauscher.PROTOKOLL_SCHICHTEN[0])) {
                if (this.netzzugangVisible) {
                    isValid = true;
                }
            } else if (daten[i][5].equals(Lauscher.PROTOKOLL_SCHICHTEN[1])) {
                if (this.vermittlungVisible) {
                    isValid = true;
                }
            } else if (daten[i][5].equals(Lauscher.PROTOKOLL_SCHICHTEN[2])) {
                if (this.transportVisible) {
                    isValid = true;
                }
            } else if (daten[i][5].equals(Lauscher.PROTOKOLL_SCHICHTEN[3])) {
                if (this.anwendungVisible) {
                    isValid = true;
                }
            } else {
                isValid = true;
            }
            if (!isValid) continue;
            Vector<Object> rowData = new Vector<Object>(daten[i].length);
            for (int col = 0; col < daten[i].length; ++col) {
                rowData.add(col, daten[i][col]);
            }
            ((DefaultTableModel)this.getModel()).addRow(rowData);
        }
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
        if (this.getRowCount() > 0 && this.scrollPane != null && this.scrollPane.getViewport() != null && this.autoscroll) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, this.getHeight()));
        }
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        outputStream.write("not implemented".getBytes("UTF8"));
    }
}

