/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.AggregatedExchangePanel;
import filius.gui.nachrichtensicht.MessageDetails;
import filius.rahmenprogramm.nachrichten.Lauscher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class MessageDetailsPanel
extends MessageDetails {
    private String macAddress;

    public MessageDetailsPanel(String macAddress) {
        this.macAddress = macAddress;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
    }

    @Override
    public void clear() {
        this.removeAll();
        this.updateUI();
    }

    @Override
    public void update(String interfaceId, int frameNumber) {
        int dataSetNo;
        Object[][] daten = Lauscher.getLauscher().getDaten(this.macAddress, false, 0);
        int currNo = 0;
        for (dataSetNo = 0; dataSetNo < daten.length && (currNo = Integer.parseInt(daten[dataSetNo][0].toString())) != frameNumber; ++dataSetNo) {
        }
        Object[] dataSet = daten[dataSetNo];
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(AggregatedExchangePanel.messages.getString("rp_lauscher_msg1") + ": " + String.valueOf(dataSet[0]) + " / " + AggregatedExchangePanel.messages.getString("rp_lauscher_msg2") + ": " + String.valueOf(dataSet[1]));
        while (dataSetNo < daten.length && Integer.parseInt(daten[dataSetNo][0].toString()) == frameNumber) {
            DefaultMutableTreeNode dateNode;
            dataSet = daten[dataSetNo];
            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(dataSet[5], true);
            if (dataSet[2] != null && !dataSet[2].toString().isEmpty()) {
                String srcLabel = String.format("%-15s", AggregatedExchangePanel.messages.getString("rp_lauscher_msg3") + ": ");
                dateNode = new DefaultMutableTreeNode(srcLabel + String.valueOf(dataSet[2]));
                layerNode.add(dateNode);
            }
            if (dataSet[3] != null && !dataSet[3].toString().isEmpty()) {
                String destLabel = String.format("%-15s", AggregatedExchangePanel.messages.getString("rp_lauscher_msg4") + ": ");
                dateNode = new DefaultMutableTreeNode(destLabel + String.valueOf(dataSet[3]));
                layerNode.add(dateNode);
            }
            if (dataSet[4] != null && !dataSet[4].toString().isEmpty()) {
                String protocolLabel = String.format("%-15s", AggregatedExchangePanel.messages.getString("rp_lauscher_msg5") + ": ");
                dateNode = new DefaultMutableTreeNode(protocolLabel + String.valueOf(dataSet[4]));
                layerNode.add(dateNode);
            }
            if (dataSet[6] != null && !dataSet[6].toString().isEmpty()) {
                Object contentLabel = AggregatedExchangePanel.messages.getString("rp_lauscher_msg7");
                if (dataSet[5] == Lauscher.PROTOKOLL_SCHICHTEN[3]) {
                    contentLabel = (String)contentLabel + " (" + dataSet[6].toString().length() + " Bytes)";
                }
                contentLabel = (String)contentLabel + ": ";
                if (dataSet[6].toString().contains("\n") || dataSet[6].toString().length() > 60) {
                    DefaultMutableTreeNode labelNode = new DefaultMutableTreeNode(contentLabel);
                    dateNode = new DefaultMutableTreeNode(dataSet[6]);
                    labelNode.add(dateNode);
                    layerNode.add(labelNode);
                } else {
                    dateNode = new DefaultMutableTreeNode(String.format("%-15s", contentLabel) + String.valueOf(dataSet[6]));
                    layerNode.add(dateNode);
                }
            }
            rootNode.add(layerNode);
            ++dataSetNo;
        }
        JTree detailsTree = new JTree(rootNode);
        for (int i = 0; i < detailsTree.getRowCount(); ++i) {
            detailsTree.expandRow(i);
        }
        detailsTree.setCellRenderer(new MultiLineCellRenderer());
        this.removeAll();
        this.add((Component)detailsTree, "West");
        this.updateUI();
    }

    class MultiLineCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JLabel icon;
        protected TreeTextArea text;

        public MultiLineCellRenderer() {
            this.setLayout(new BoxLayout(this, 2));
            this.icon = new JLabel(){

                @Override
                public void setBackground(Color color) {
                    if (color instanceof ColorUIResource) {
                        color = null;
                    }
                    super.setBackground(color);
                }
            };
            this.add(this.icon);
            this.add(Box.createHorizontalStrut(4));
            this.text = new TreeTextArea();
            this.add(this.text);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.text.setText(stringValue);
            this.text.setSelect(isSelected);
            this.text.setFocus(hasFocus);
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension iconD = this.icon.getPreferredSize();
            Dimension textD = this.text.getPreferredSize();
            int height = iconD.height < textD.height ? textD.height : iconD.height;
            return new Dimension(iconD.width + textD.width, height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        class TreeTextArea
        extends JTextArea {
            Dimension preferredSize;

            TreeTextArea() {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setOpaque(true);
                Font font = this.getFont();
                this.setFont(new Font("Monospaced", 1, font.getSize()));
            }

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void setPreferredSize(Dimension d) {
                if (d != null) {
                    this.preferredSize = d;
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }

            @Override
            public void setText(String str) {
                Font font = this.getFont();
                FontMetrics fm = this.getToolkit().getFontMetrics(font);
                BufferedReader br = new BufferedReader(new StringReader(str));
                int maxWidth = 0;
                int lines = 0;
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        int width = SwingUtilities.computeStringWidth(fm, line);
                        if (maxWidth < width) {
                            maxWidth = width;
                        }
                        ++lines;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                lines = lines < 1 ? 1 : lines;
                int height = fm.getHeight() * lines;
                this.setPreferredSize(new Dimension(maxWidth + 12, height));
                super.setText(str);
            }

            void setSelect(boolean isSelected) {
                Color bColor = isSelected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground");
                super.setBackground(bColor);
            }

            void setFocus(boolean hasFocus) {
                if (hasFocus) {
                    Color lineColor = UIManager.getColor("Tree.selectionBorderColor");
                    this.setBorder(BorderFactory.createLineBorder(lineColor));
                } else {
                    this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
            }
        }
    }
}

