/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.AggregatedMessageTable;
import filius.gui.nachrichtensicht.MessageDetails;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class MessageDetailsTable
extends MessageDetails
implements I18n {
    private final GridBagLayout GRID_BAG_LAYOUT = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private static final int MSG_DETAILS_CELL_WIDTH = 150;
    private static final int MSG_DETAILS_CELL_HEIGHT = 30;
    private String interfaceId;
    private int frameNumber;
    private String[][] messageDetailsMatrix;
    private int maxLayerInsideFrame;
    private Color backgroundColor;

    public MessageDetailsTable(String interfaceId, int frameNumber, Color backgroundColor) {
        this.interfaceId = interfaceId;
        this.frameNumber = frameNumber;
        this.backgroundColor = backgroundColor;
        this.setLayout(this.GRID_BAG_LAYOUT);
        this.setBackground(Color.WHITE);
        if (frameNumber >= 1) {
            this.update(interfaceId, frameNumber);
        }
    }

    public GridBagLayout getGridBagLayout() {
        return this.GRID_BAG_LAYOUT;
    }

    public int getMaxLayerInsideFrame() {
        return this.maxLayerInsideFrame;
    }

    @Override
    public Dimension getPreferredSize() {
        return MessageDetailsTable.getSizeOfMessageDetailsTable();
    }

    @Override
    public Dimension getMinimumSize() {
        return MessageDetailsTable.getSizeOfMessageDetailsTable();
    }

    @Override
    public Dimension getMaximumSize() {
        return MessageDetailsTable.getSizeOfMessageDetailsTable();
    }

    public static Dimension getSizeOfMessageDetailsTable() {
        return new Dimension(1350, 240);
    }

    private void setMessageDetails() {
        Object[][] daten = Lauscher.getLauscher().getDaten(this.interfaceId, false, 0);
        String frameNumberAsString = Integer.toString(this.frameNumber);
        for (int i = 0; i < daten.length; ++i) {
            if (!daten[i][0].equals(frameNumberAsString)) continue;
            this.messageDetailsMatrix[3][1] = daten[i][2].toString();
            this.messageDetailsMatrix[4][1] = daten[i][3].toString();
            this.messageDetailsMatrix[5][1] = daten[i][6].toString();
            if (i + 1 >= daten.length || !daten[i + 1][0].equals(frameNumberAsString)) break;
            this.messageDetailsMatrix[2][2] = daten[i + 1][4].toString();
            this.messageDetailsMatrix[3][3] = daten[i + 1][2].toString();
            this.messageDetailsMatrix[4][3] = daten[i + 1][3].toString();
            this.messageDetailsMatrix[5][3] = daten[i + 1][6].toString();
            if (i + 2 >= daten.length || !daten[i + 2][0].equals(frameNumberAsString)) break;
            this.messageDetailsMatrix[2][4] = daten[i + 2][4].toString();
            this.messageDetailsMatrix[3][5] = daten[i + 2][2].toString();
            this.messageDetailsMatrix[4][5] = daten[i + 2][3].toString();
            this.messageDetailsMatrix[5][5] = daten[i + 2][6].toString();
            if (i + 3 >= daten.length || !daten[i + 3][0].equals(frameNumberAsString)) break;
            this.messageDetailsMatrix[2][6] = daten[i + 3][4].toString();
            this.messageDetailsMatrix[3][6] = daten[i + 3][6].toString();
            break;
        }
    }

    private int computeMaxLayerInsideFrame() {
        int maxLayerInsideFrame = 1;
        if (this.messageDetailsMatrix[2][2] != null) {
            maxLayerInsideFrame = 2;
            if (this.messageDetailsMatrix[2][4] != null) {
                maxLayerInsideFrame = 3;
                if (this.messageDetailsMatrix[2][6] != null) {
                    maxLayerInsideFrame = 4;
                }
            }
        }
        return maxLayerInsideFrame;
    }

    private void setTitles() {
        this.messageDetailsMatrix[0][0] = messages.getString("rp_lauscher_msg8");
        this.messageDetailsMatrix[0][2] = messages.getString("rp_lauscher_msg9");
        this.messageDetailsMatrix[0][4] = messages.getString("rp_lauscher_msg10");
        this.messageDetailsMatrix[0][6] = messages.getString("rp_lauscher_msg11");
        this.messageDetailsMatrix[2][0] = messages.getString("schichten_lokaler_weg_msg5");
        this.messageDetailsMatrix[3][0] = messages.getString("rp_lauscher_msg3") + ":";
        this.messageDetailsMatrix[4][0] = messages.getString("rp_lauscher_msg4") + ":";
        this.messageDetailsMatrix[5][0] = messages.getString("rp_lauscher_msg7") + ":";
        this.messageDetailsMatrix[3][2] = messages.getString("rp_lauscher_msg3") + ":";
        this.messageDetailsMatrix[4][2] = messages.getString("rp_lauscher_msg4") + ":";
        this.messageDetailsMatrix[5][2] = messages.getString("rp_lauscher_msg7") + ":";
        if (this.maxLayerInsideFrame >= 3) {
            this.messageDetailsMatrix[3][4] = messages.getString("rp_lauscher_msg3") + ":";
            this.messageDetailsMatrix[4][4] = messages.getString("rp_lauscher_msg4") + ":";
            this.messageDetailsMatrix[5][4] = messages.getString("rp_lauscher_msg7") + ":";
        }
        this.messageDetailsMatrix[0][7] = messages.getString("schichten_lokaler_weg_msg2");
        this.messageDetailsMatrix[2][7] = messages.getString("schichten_lokaler_weg_msg3");
        this.messageDetailsMatrix[3][7] = messages.getString("schichten_lokaler_weg_msg4");
    }

    private void initializeTable() {
        JTextArea textArea;
        JLabel label;
        int column;
        for (column = 0; column < 6; column += 2) {
            label = this.setLabel("", column, 0, 2, 1, 1.0, 1.0, false);
            label.setHorizontalAlignment(0);
            label.setBackground(this.getColorByColumn("backgroundColorFine", column));
            label.setBorder(BorderFactory.createEtchedBorder(1));
            this.setBoldAndItalic(label);
        }
        label = this.setLabel("", 6, 0, 1, 1, 2.0, 1.0, false);
        label.setHorizontalAlignment(0);
        label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorFine", 4));
        label.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBoldAndItalic(label);
        label = this.setLabel("", 7, 0, 1, 1, 0.5, 1.0, false);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBackground(this.backgroundColor);
        label.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBoldAndItalic(label);
        for (column = 0; column < 6; column += 2) {
            label = this.setEmptyCell(column, 1, 2, 1, 1.0, 0.8);
        }
        label = this.setEmptyCell(6, 1, 1, 1, 2.0, 0.8);
        label = this.setEmptyCell(7, 1, 1, 1, 0.5, 0.8);
        for (column = 0; column < 6; column += 2) {
            label = this.setLabel("", column, 2, 2, 1, 1.0, 1.0, true);
            label.setHorizontalAlignment(0);
            label.setBackground(this.getColorByColumn("backgroundColor", column));
        }
        label = this.setLabel("", 6, 2, 1, 1, 2.0, 1.0, true);
        label.setHorizontalAlignment(0);
        label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColor", 4));
        label = this.setLabel("", 7, 2, 1, 1, 0.5, 1.0, false);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBackground(this.backgroundColor);
        label.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBoldAndItalic(label);
        for (int row = 3; row < 5; ++row) {
            for (int column2 = 0; column2 < 6; ++column2) {
                label = this.setLabel("", column2, row, 1, 1, 1.0, 1.0, true);
                if (column2 % 2 == 0) {
                    label.setHorizontalAlignment(4);
                }
                label.setBackground(this.getColorByColumn("backgroundColor", column2));
            }
        }
        for (column = 0; column < 6; ++column) {
            if (column % 2 == 0) {
                label = this.setLabel("", column, 5, 1, 1, 1.0, 3.0, true);
                label.setHorizontalAlignment(4);
                label.setVerticalAlignment(1);
                label.setBackground(this.getColorByColumn("backgroundColor", column));
                continue;
            }
            textArea = this.setTextArea("", column, 5, 1, 1, 1.0, 3.0);
            textArea.setBackground(this.getColorByColumn("backgroundColor", column));
        }
        textArea = this.setTextArea("", 6, 3, 1, 3, 2.0, 1.6666666666666667);
        textArea.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColor", 4));
        label = this.setLabel("", 7, 3, 1, 3, 0.5, 1.6666666666666667, false);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBackground(this.backgroundColor);
        label.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBoldAndItalic(label);
    }

    @Override
    public void update(String interfaceId, int frameNumber) {
        this.interfaceId = interfaceId;
        this.frameNumber = frameNumber;
        this.messageDetailsMatrix = new String[6][8];
        this.setMessageDetails();
        this.maxLayerInsideFrame = this.computeMaxLayerInsideFrame();
        this.setTitles();
        this.initializeTable();
        for (Component component : this.getComponents()) {
            String text;
            int gridy = this.GRID_BAG_LAYOUT.getConstraints((Component)component).gridy;
            int gridx = this.GRID_BAG_LAYOUT.getConstraints((Component)component).gridx;
            String string = text = this.messageDetailsMatrix[gridy][gridx] != null ? this.messageDetailsMatrix[gridy][gridx] : "";
            if (component instanceof JLabel) {
                ((JLabel)component).setText(text);
                continue;
            }
            if (!(component instanceof JTextArea)) continue;
            ((JTextArea)component).setText(text);
        }
        this.setLayersInvisible();
    }

    public void setLayersInvisible() {
        HashSet<Integer> columns = new HashSet<Integer>();
        if (this.maxLayerInsideFrame == 4) {
            return;
        }
        if (this.maxLayerInsideFrame == 3) {
            columns.add(6);
        } else if (this.maxLayerInsideFrame == 2) {
            columns.add(4);
            columns.add(5);
            columns.add(6);
        }
        for (Component component : this.getComponents()) {
            if (!columns.contains(this.getGridBagLayout().getConstraints((Component)component).gridx)) continue;
            component.setVisible(false);
        }
    }

    @Override
    public void clear() {
        this.removeAll();
        this.updateUI();
    }

    public static Color getLayerColorVar(String typeOfColor, int layerNumber) {
        return AggregatedMessageTable.LayerColorVar.getLayerColorVar(typeOfColor, layerNumber);
    }

    private Color getColorByColumn(String typeOfColor, int column) {
        Color color = null;
        if (column == 0 || column == 1) {
            color = MessageDetailsTable.getLayerColorVar(typeOfColor, 1);
        } else if (column == 2 || column == 3) {
            color = MessageDetailsTable.getLayerColorVar(typeOfColor, 2);
        } else if (column == 4 || column == 5) {
            color = MessageDetailsTable.getLayerColorVar(typeOfColor, 3);
        } else if (column == 6) {
            color = MessageDetailsTable.getLayerColorVar(typeOfColor, 4);
        }
        return color;
    }

    private JLabel setLabel(String text, int x_pos, int y_pos, int width, int height, double width_multiplier, double height_multiplier, boolean needsBorder) {
        JLabel label = new JLabel(text);
        this.setStandards(label, x_pos, y_pos, width, height, width_multiplier, height_multiplier);
        label.setOpaque(true);
        this.setPlain(label);
        if (needsBorder) {
            this.setBorderVisible(label, true);
        }
        this.add((Component)label, this.c);
        return label;
    }

    private JTextArea setTextArea(String text, int x_pos, int y_pos, int width, int height, double width_multiplier, double height_multiplier) {
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(true);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setFocusable(false);
        this.setBorderVisible(textArea, true);
        this.setStandards(textArea, x_pos, y_pos, width, height, width_multiplier, height_multiplier);
        this.add((Component)textArea, this.c);
        return textArea;
    }

    private JLabel setEmptyCell(int x_pos, int y_pos, int width, int height, double width_multiplier, double height_multiplier) {
        JLabel label = new JLabel();
        label.setOpaque(false);
        label.setBorder(BorderFactory.createEmptyBorder());
        this.setStandards(label, x_pos, y_pos, width, height, width_multiplier, height_multiplier);
        this.add((Component)label, this.c);
        return label;
    }

    private void setStandards(Component component, int x_pos, int y_pos, int width, int height, double width_multiplier, double height_multiplier) {
        Dimension dimensionOfComponent = new Dimension((int)(width_multiplier * (double)width * 150.0), (int)(height_multiplier * (double)height * 30.0));
        component.setPreferredSize(dimensionOfComponent);
        component.setMinimumSize(dimensionOfComponent);
        component.setMaximumSize(dimensionOfComponent);
        this.c.gridx = x_pos;
        this.c.gridy = y_pos;
        this.c.gridwidth = width;
        this.c.gridheight = height;
    }

    private void setBoldAndItalic(Component comp) {
        Font boldFont = new Font(comp.getFont().getName(), 3, comp.getFont().getSize());
        comp.setFont(boldFont);
    }

    private void setPlain(Component comp) {
        Font boldFont = new Font(comp.getFont().getName(), 0, comp.getFont().getSize());
        comp.setFont(boldFont);
    }

    public void setBorderVisible(Component component, boolean isVisible) {
        if (isVisible) {
            Border loweredEtchedBorder = BorderFactory.createEtchedBorder(1);
            EmptyBorder marginBorder = new EmptyBorder(5, 5, 5, 5);
            if (component instanceof JTextArea) {
                ((JTextArea)component).setBorder(new CompoundBorder(loweredEtchedBorder, marginBorder));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setBorder(new CompoundBorder(loweredEtchedBorder, marginBorder));
            }
        } else if (component instanceof JTextArea) {
            ((JTextArea)component).setBorder(BorderFactory.createEmptyBorder());
        } else if (component instanceof JLabel) {
            ((JLabel)component).setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

