/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import com.itextpdf.text.DocumentException;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.documentation.ReportGenerator;
import filius.gui.netzwerksicht.GUISidebar;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;

public class GUIDocumentationSidebar
extends GUISidebar
implements I18n {
    public static final String TYPE_TEXTFIELD = "textfield";
    public static final String TYPE_RECTANGLE = "rectangle";
    public static final String TYPE_EXPORT = "export";
    public static final String TYPE_REPORT = "report";
    public static final String ADD_TEXT = "gfx/dokumentation/add_text_small.png";
    public static final String ADD_RECTANGLE = "gfx/dokumentation/add_small.png";
    public static final String EXPORT = "gfx/dokumentation/download_small.png";
    public static final String REPORT = "gfx/dokumentation/pdf_small.png";
    private static GUIDocumentationSidebar sidebar;

    public static GUIDocumentationSidebar getGUIDocumentationSidebar() {
        if (sidebar == null) {
            sidebar = new GUIDocumentationSidebar();
        }
        return sidebar;
    }

    @Override
    protected void addItemsToSidebar() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/add_text_small.png"));
        JSidebarButton newLabel = new JSidebarButton(messages.getString("docusidebar_msg1"), (Icon)icon, TYPE_TEXTFIELD);
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/add_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg3"), (Icon)icon, TYPE_RECTANGLE);
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/download_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg5"), (Icon)icon, TYPE_EXPORT);
        newLabel.setToolTipText(messages.getString("docusidebar_msg6"));
        newLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIContainer.getGUIContainer().exportAsImage();
            }
        });
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/pdf_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg7"), (Icon)icon, TYPE_REPORT);
        newLabel.setToolTipText(messages.getString("docusidebar_msg8"));
        newLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDocumentationSidebar.this.generateReport();
            }
        });
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
    }

    private void generateReport() {
        FileDialog fileDialog = new FileDialog((Frame)JMainFrame.getJMainFrame(), messages.getString("main_msg4"), 1);
        FilenameFilter pdfFilenameFilter = (dir, name) -> name.endsWith(".pdf") || name.endsWith(".PDF");
        fileDialog.setFilenameFilter(pdfFilenameFilter);
        String path = SzenarioVerwaltung.getInstance().holePfad();
        if (path != null) {
            String szenarioFile = new File(path).getAbsolutePath();
            File preselectedFile = new File(szenarioFile.substring(0, szenarioFile.lastIndexOf(".")) + ".pdf");
            fileDialog.setDirectory(preselectedFile.getParent());
            fileDialog.setFile(preselectedFile.getName());
        }
        fileDialog.setVisible(true);
        if (null != fileDialog.getFile()) {
            Object reportFilename;
            boolean nameChanged = false;
            if (fileDialog.getFile().endsWith(".pdf") || fileDialog.getFile().endsWith(".PDF")) {
                reportFilename = fileDialog.getFile();
            } else {
                nameChanged = true;
                reportFilename = fileDialog.getFile() + ".pdf";
            }
            int entscheidung = 0;
            Path reportFilepath = Path.of(fileDialog.getDirectory(), new String[]{reportFilename});
            if (nameChanged && reportFilepath.toFile().exists()) {
                entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg17"), messages.getString("guimainmemu_msg10"), 0);
            }
            if (entscheidung == 0) {
                try {
                    ReportGenerator.getInstance().generateReport(reportFilepath.toString());
                }
                catch (DocumentException | IOException e) {
                    JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg11"));
                }
            }
        }
    }
}

