/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.JExtendedTable;
import filius.gui.netzwerksicht.JPortForwardingDialog;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GatewayPortForwardingConfigTable
extends JExtendedTable
implements I18n {
    public GatewayPortForwardingConfigTable(TableModel model, boolean editable) {
        super(model, editable);
    }

    @Override
    public void editingStopped(ChangeEvent evt) {
        this.closeEditor();
    }

    void closeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            String data = (String)this.getCellEditor().getCellEditorValue();
            this.setValueAt(data, this.editingRow, this.editingColumn);
            ((JPortForwardingDialog)this.parentGUI).addEintrag(this.getCurrentValueAt(this.editingRow, 0), this.getCurrentValueAt(this.editingRow, 1), this.getCurrentValueAt(this.editingRow, 2), this.getCurrentValueAt(this.editingRow, 3));
            this.removeEditor();
        }
        ((JPortForwardingDialog)this.parentGUI).aenderungenAnnehmen();
        ((DefaultTableModel)this.getModel()).fireTableDataChanged();
    }

    private String getCurrentValueAt(int row, int col) {
        if (row == this.editingRow && col == this.editingColumn) {
            String data = null;
            if (col == 0) {
                switch (((String)this.getCellEditor().getCellEditorValue()).toUpperCase()) {
                    case "TCP": {
                        data = "6";
                        break;
                    }
                    case "UDP": {
                        data = "17";
                    }
                }
            } else {
                data = (String)this.getCellEditor().getCellEditorValue();
            }
            return data;
        }
        return (String)this.getValueAt(row, col);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        Component comp = super.prepareRenderer(renderer, row, col);
        String cellValue = (String)this.getModel().getValueAt(row, col);
        Pattern pattern = null;
        switch (col) {
            case 0: {
                pattern = EingabenUeberpruefung.musterProtocol;
                break;
            }
            case 1: {
                pattern = EingabenUeberpruefung.musterPort;
                break;
            }
            case 2: {
                pattern = EingabenUeberpruefung.musterIpAdresse;
                break;
            }
            case 3: {
                pattern = EingabenUeberpruefung.musterPort;
            }
        }
        if (null != cellValue && EingabenUeberpruefung.isGueltig(cellValue, pattern)) {
            comp.setForeground(EingabenUeberpruefung.farbeRichtig);
        } else {
            comp.setForeground(EingabenUeberpruefung.farbeFalsch);
        }
        return comp;
    }
}

