/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.hardware.Hardware;
import filius.rahmenprogramm.IconMode;
import filius.rahmenprogramm.Information;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCablePanel
extends JPanel
implements Observer {
    private static Logger LOG = LoggerFactory.getLogger(JCablePanel.class);
    private static final long serialVersionUID = 1L;
    private GUIKnotenItem ziel1;
    private GUIKnotenItem ziel2;
    private GUIKabelItem kabelItem;
    private QuadCurve2D currCurve = null;
    private Color kabelFarbe = new Color(64, 64, 64);
    private final Color farbeKabel = new Color(64, 64, 64);
    private final Color farbeWireless = new Color(192, 192, 192);
    private final Color farbeBlinken = new Color(0, 255, 64);
    private final Color farbeFailure = Color.RED;

    public JCablePanel() {
        this.setOpaque(false);
    }

    public void updateBounds() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (JCablePanel), updateBounds()");
        if (null != this.ziel1 && null != this.ziel2) {
            int t1;
            int x1 = this.ziel1.getImageLabel().getX();
            int x2 = this.ziel2.getImageLabel().getX();
            int y1 = this.ziel1.getImageLabel().getY();
            int y2 = this.ziel2.getImageLabel().getY();
            x1 = (int)((double)x1 + 0.5 * (double)this.ziel1.getImageLabel().getWidth());
            y1 = (int)((double)y1 + 0.5 * (double)this.ziel1.getImageLabel().getHeight());
            x2 = (int)((double)x2 + 0.5 * (double)this.ziel2.getImageLabel().getWidth());
            y2 = (int)((double)y2 + 0.5 * (double)this.ziel2.getImageLabel().getHeight());
            if (x1 > x2) {
                t1 = x1;
                x1 = x2;
                x2 = t1;
            }
            if (y1 > y2) {
                t1 = y1;
                y1 = y2;
                y2 = t1;
            }
            this.setBounds(x1 - 2, y1 - 2, x2 - x1 + 4, y2 - y1 + 4);
            LOG.trace("JCablePanel (" + this.hashCode() + "), bounds: " + x1 + "/" + y1 + ", " + x2 + "/" + y2 + "  (W:" + (x2 - x1) + ", H:" + (y2 - y1) + ")");
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int kp2;
        int kp1;
        super.paintComponent(g);
        int x1 = (int)((double)this.ziel1.getImageLabel().getX() + 0.5 * (double)this.ziel1.getImageLabel().getWidth());
        int x2 = (int)((double)this.ziel2.getImageLabel().getX() + 0.5 * (double)this.ziel2.getImageLabel().getWidth());
        int y1 = (int)((double)this.ziel1.getImageLabel().getY() + 0.5 * (double)this.ziel1.getImageLabel().getHeight());
        int y2 = (int)((double)this.ziel2.getImageLabel().getY() + 0.5 * (double)this.ziel2.getImageLabel().getHeight());
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(2.0f));
        if (this.isWireless()) {
            if (this.kabelFarbe.equals(this.farbeKabel)) {
                this.kabelFarbe = this.farbeWireless;
            }
            if (!this.kabelFarbe.equals(this.farbeBlinken)) {
                float[] dash = new float[]{10.0f};
                g2.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f));
            }
        }
        g.setColor(this.kabelFarbe);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (Information.getInformation().getIconMode().equals((Object)IconMode.SYMBOL)) {
            kp1 = (x1 - this.getX() + x2 - this.getX()) / 2;
            kp2 = (y1 - this.getY() + y2 - this.getY()) / 2;
        } else {
            kp1 = (x1 - this.getX() + x2 - this.getX()) / 4;
            if (x1 > x2 && y1 > y2 || x1 < x2 && y1 < y2) {
                kp1 = 3 * kp1;
            }
            kp2 = (y1 - this.getY() + y2 - this.getY()) / 4;
        }
        QuadCurve2D.Double myCurve = new QuadCurve2D.Double(x1 - this.getX(), y1 - this.getY(), kp1, kp2, x2 - this.getX(), y2 - this.getY());
        g2.draw(myCurve);
        this.currCurve = myCurve;
        this.setOpaque(false);
    }

    private boolean isWireless() {
        return this.getKabelItem() != null && this.getKabelItem().getDasKabel() != null && this.getKabelItem().getDasKabel().getWireless();
    }

    public boolean clicked(int x, int y) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (JCablePanel), clicked(" + x + "," + y + ")");
        int delta = 10;
        Rectangle2D.Double absolutePointerRect = new Rectangle2D.Double(x - delta, y - delta, 2 * delta, 2 * delta);
        boolean hitPanel = this.getBounds().intersects(absolutePointerRect);
        Rectangle2D.Double relativePointerRect = new Rectangle2D.Double(x - this.getX() - delta, y - this.getY() - delta, 2 * delta, 2 * delta);
        boolean hitCurve = this.currCurve.intersects(relativePointerRect);
        return hitCurve && hitPanel;
    }

    public GUIKnotenItem getZiel1() {
        return this.ziel1;
    }

    public void setZiel1(GUIKnotenItem ziel1) {
        this.ziel1 = ziel1;
    }

    public GUIKnotenItem getZiel2() {
        return this.ziel2;
    }

    public void setZiel2(GUIKnotenItem ziel2) {
        this.ziel2 = ziel2;
        this.updateBounds();
    }

    public void setKabelItem(GUIKabelItem value) {
        this.kabelItem = value;
    }

    public GUIKabelItem getKabelItem() {
        return this.kabelItem;
    }

    @Override
    public void update(Observable o, Object arg) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (JCablePanel), update(" + String.valueOf(o) + "," + String.valueOf(arg) + ")");
        LOG.trace("update cable: {}", arg);
        if (arg.equals(Boolean.TRUE)) {
            this.kabelFarbe = this.farbeBlinken;
        } else if (arg.equals(Hardware.FAILURE)) {
            LOG.debug("set cable color to red");
            this.kabelFarbe = this.farbeFailure;
        } else {
            this.resetColor();
        }
        this.updateUI();
    }

    private void resetColor() {
        this.kabelFarbe = this.isWireless() ? this.farbeWireless : this.farbeKabel;
    }
}

