/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.hardware.Kabel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Port;
import filius.hardware.Verbindung;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.LokalerKnoten;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.I18n;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JConnectionsDialog
extends JDialog
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(JConnectionsDialog.class);
    private static final int LINE_HEIGHT = 36;
    private final ImageIcon nicIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/rj45.png"));
    private Vermittlungsrechner internetSwitch;
    private Map<NetzwerkInterface, Knoten> nicToNodeMap = new HashMap<NetzwerkInterface, Knoten>();
    private JButton[] btnLocal = new JButton[8];
    private JLabel[] lblLocal = new JLabel[8];
    private JPanel buttonPanel;
    private JPanel cablePanel;
    private JPanel remoteInterfacesPanel;
    private JPanel localInterfacesPanel;
    private JButton[] btnRemote;
    private JButton btnAddInterface;
    private JButton btnRemoveInterface;
    private JLabel[] lblRemote;

    public JConnectionsDialog(Frame owner, Vermittlungsrechner internetSwitch) {
        super(owner, true);
        this.internetSwitch = internetSwitch;
        this.initComponents();
        this.updateAll();
    }

    private void updateNicToNodeMap(Vermittlungsrechner internetSwitch) {
        this.nicToNodeMap.clear();
        for (NetzwerkInterface nic : internetSwitch.getNetzwerkInterfaces()) {
            Knoten node = this.getConnectedComponent(nic);
            if (node == null) continue;
            this.nicToNodeMap.put(nic, node);
        }
    }

    private void updateRemoteInterfaces() {
        int nicNr = 0;
        for (NetzwerkInterface nic : this.internetSwitch.getNetzwerkInterfaces()) {
            ++nicNr;
            Knoten node = this.nicToNodeMap.get(nic);
            if (node != null) {
                Port[] ports;
                String remoteAddress = "";
                Kabel connection = this.getConnectedCable(nic);
                for (Port port : ports = connection.getAnschluesse()) {
                    if (port.getNIC() == null || port.getNIC() == nic) continue;
                    remoteAddress = port.getNIC().getIp();
                }
                this.btnRemote[nicNr - 1].setEnabled(false);
                if (node instanceof InternetKnoten) {
                    this.lblRemote[nicNr - 1].setText(node.holeAnzeigeName() + " (" + remoteAddress + ")");
                    continue;
                }
                this.lblRemote[nicNr - 1].setText(node.holeAnzeigeName());
                continue;
            }
            this.btnRemote[nicNr - 1].setEnabled(false);
            this.btnRemote[nicNr - 1].setVisible(false);
            this.lblRemote[nicNr - 1].setText("");
        }
        for (int i = nicNr; i < 8; ++i) {
            this.btnRemote[i].setEnabled(false);
            this.btnRemote[i].setVisible(false);
            this.lblRemote[i].setText("");
        }
    }

    private void updateLocalInterfaces() {
        int nicNr = 0;
        for (NetzwerkInterface nic : this.internetSwitch.getNetzwerkInterfaces()) {
            this.lblLocal[++nicNr - 1].setText("NIC " + nicNr + ": " + nic.getIp());
            Knoten node = this.getConnectedComponent(nic);
            if (node != null) {
                this.btnLocal[nicNr - 1].setOpaque(true);
                this.btnLocal[nicNr - 1].setBackground(Color.GREEN);
                this.btnLocal[nicNr - 1].setEnabled(true);
                continue;
            }
            this.btnLocal[nicNr - 1].setOpaque(true);
            this.btnLocal[nicNr - 1].setBackground(Color.RED);
            this.btnLocal[nicNr - 1].setEnabled(true);
        }
        this.btnAddInterface.setEnabled(nicNr != 8);
        this.btnRemoveInterface.setEnabled(nicNr != 0);
        for (int i = nicNr; i < 8; ++i) {
            this.btnLocal[nicNr].setOpaque(false);
            this.btnLocal[i].setEnabled(false);
            this.lblLocal[i].setText("");
        }
    }

    private void updateConnections() {
        this.cablePanel.removeAll();
        SpringLayout cableLayout = new SpringLayout();
        this.cablePanel.setLayout(cableLayout);
        int nicNr = 0;
        for (NetzwerkInterface nic : this.internetSwitch.getNetzwerkInterfaces()) {
            Knoten node = this.getConnectedComponent(nic);
            if (node != null) {
                LinePanel cable = new LinePanel();
                int yPos = 25 + (int)(((double)nicNr + 0.5) * 36.0);
                cable.setStartPoint(-2, yPos);
                cable.setEndPoint(282, yPos);
                cableLayout.putConstraint("West", (Component)cable, 0, "West", (Component)this.cablePanel);
                cableLayout.putConstraint("North", (Component)cable, 0, "North", (Component)this.cablePanel);
                cable.setPreferredSize(new Dimension(280, 700));
                this.cablePanel.add(cable);
            }
            ++nicNr;
        }
        this.cablePanel.repaint();
    }

    private void initComponents() {
        JPanel upperCompound = new JPanel();
        upperCompound.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upperCompound.setLayout(new BoxLayout(upperCompound, 0));
        upperCompound.setPreferredSize(new Dimension(700, 360));
        this.initRemoteInterfaces();
        this.initLocalInterfaces();
        this.cablePanel = new JPanel();
        this.cablePanel.setPreferredSize(new Dimension(240, 700));
        upperCompound.add(this.remoteInterfacesPanel);
        upperCompound.add(this.cablePanel);
        upperCompound.add(this.localInterfacesPanel);
        JPanel noteCompound = new JPanel();
        noteCompound.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextArea usageNote = new JTextArea(messages.getString("jvermittlungsrechnerkonfiguration_msg19"));
        usageNote.setOpaque(false);
        usageNote.setEditable(false);
        usageNote.setLineWrap(true);
        usageNote.setWrapStyleWord(true);
        usageNote.setFont(new Font("Dialog", 0, 12));
        usageNote.setSize(new Dimension(700, 200));
        noteCompound.add(Box.createVerticalGlue());
        noteCompound.add((Component)usageNote, "Center");
        noteCompound.setMinimumSize(new Dimension(700, 200));
        JPanel buttonCompound = new JPanel();
        buttonCompound.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton btnClose = new JButton(messages.getString("jvermittlungsrechnerkonfiguration_msg20"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Container c = (Container)arg0.getSource();
                while (!((c = c.getParent()) instanceof JDialog)) {
                }
                c.setVisible(false);
                GUIContainer.getGUIContainer().getProperty().reInit();
                GUIContainer.getGUIContainer().getProperty().maximieren();
            }
        });
        buttonCompound.add(btnClose);
        buttonCompound.setMinimumSize(new Dimension(200, 50));
        this.getContentPane().add((Component)upperCompound, "North");
        this.getContentPane().add((Component)noteCompound, "Center");
        this.getContentPane().add((Component)buttonCompound, "South");
    }

    private void initRemoteInterfaces() {
        this.remoteInterfacesPanel = new JPanel();
        this.remoteInterfacesPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.remoteInterfacesPanel.setPreferredSize(new Dimension(250, 700));
        this.remoteInterfacesPanel.setMaximumSize(this.remoteInterfacesPanel.getPreferredSize());
        this.remoteInterfacesPanel.setSize(400, this.remoteInterfacesPanel.getHeight());
        JLabel lblRemoteTitle = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg21"));
        this.remoteInterfacesPanel.add(lblRemoteTitle);
        this.btnRemote = new JButton[8];
        this.lblRemote = new JLabel[8];
        for (int i = 0; i < 8; ++i) {
            this.btnRemote[i] = new JButton(this.nicIcon);
            this.lblRemote[i] = new JLabel();
            this.remoteInterfacesPanel.add(this.btnRemote[i]);
            this.remoteInterfacesPanel.add(this.lblRemote[i]);
        }
        SpringLayout layoutRemote = new SpringLayout();
        layoutRemote.putConstraint("North", (Component)lblRemoteTitle, 5, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("HorizontalCenter", (Component)lblRemoteTitle, 0, "HorizontalCenter", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[0], 25, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[0], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[1], 61, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[1], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[2], 97, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[2], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[3], 133, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[3], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[4], 169, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[4], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[5], 205, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[5], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[6], 241, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[6], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("North", (Component)this.btnRemote[7], 277, "North", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("East", (Component)this.btnRemote[7], 0, "East", (Component)this.remoteInterfacesPanel);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[0], 0, "VerticalCenter", (Component)this.btnRemote[0]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[0], -10, "West", (Component)this.btnRemote[0]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[1], 0, "VerticalCenter", (Component)this.btnRemote[1]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[1], -10, "West", (Component)this.btnRemote[1]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[2], 0, "VerticalCenter", (Component)this.btnRemote[2]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[2], -10, "West", (Component)this.btnRemote[2]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[3], 0, "VerticalCenter", (Component)this.btnRemote[3]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[3], -10, "West", (Component)this.btnRemote[3]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[4], 0, "VerticalCenter", (Component)this.btnRemote[4]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[4], -10, "West", (Component)this.btnRemote[4]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[5], 0, "VerticalCenter", (Component)this.btnRemote[5]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[5], -10, "West", (Component)this.btnRemote[5]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[6], 0, "VerticalCenter", (Component)this.btnRemote[6]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[6], -10, "West", (Component)this.btnRemote[6]);
        layoutRemote.putConstraint("VerticalCenter", (Component)this.lblRemote[7], 0, "VerticalCenter", (Component)this.btnRemote[7]);
        layoutRemote.putConstraint("East", (Component)this.lblRemote[7], -10, "West", (Component)this.btnRemote[7]);
        this.remoteInterfacesPanel.setLayout(layoutRemote);
    }

    private void initLocalInterfaces() {
        this.localInterfacesPanel = new JPanel();
        this.localInterfacesPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.localInterfacesPanel.setPreferredSize(new Dimension(250, 700));
        this.localInterfacesPanel.setMaximumSize(this.localInterfacesPanel.getPreferredSize());
        this.localInterfacesPanel.setSize(400, this.localInterfacesPanel.getHeight());
        JLabel lblLocalTitle = new JLabel(messages.getString("jvermittlungsrechnerkonfiguration_msg22"));
        this.localInterfacesPanel.add(lblLocalTitle);
        for (int i = 0; i < 8; ++i) {
            this.btnLocal[i] = new JButton(this.nicIcon);
            this.btnLocal[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int currentIdx = -1;
                    int markedIdx = -1;
                    for (int i = 0; i < 8; ++i) {
                        if (JConnectionsDialog.this.btnLocal[i].equals(evt.getSource())) {
                            currentIdx = i;
                        }
                        if (!JConnectionsDialog.this.btnLocal[i].isOpaque() || !JConnectionsDialog.this.btnLocal[i].getBackground().equals(Color.YELLOW)) continue;
                        markedIdx = i;
                    }
                    if (markedIdx == currentIdx) {
                        JConnectionsDialog.this.updateLocalInterfaces();
                    } else if (markedIdx == -1) {
                        JConnectionsDialog.this.btnLocal[currentIdx].setBackground(Color.YELLOW);
                        JConnectionsDialog.this.btnLocal[currentIdx].setOpaque(true);
                    } else if (markedIdx >= 0) {
                        Port port1 = JConnectionsDialog.this.internetSwitch.getNetzwerkInterfaces().get(markedIdx).getPort();
                        Port port2 = JConnectionsDialog.this.internetSwitch.getNetzwerkInterfaces().get(currentIdx).getPort();
                        JConnectionsDialog.this.swapConnection(port1, port2);
                        JConnectionsDialog.this.updateAll();
                    }
                }
            });
            this.localInterfacesPanel.add(this.btnLocal[i]);
            this.lblLocal[i] = new JLabel();
            this.localInterfacesPanel.add(this.lblLocal[i]);
        }
        this.btnAddInterface = new JButton("+");
        this.btnRemoveInterface = new JButton("-");
        this.btnAddInterface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JConnectionsDialog.this.internetSwitch.hinzuAnschluss();
                JConnectionsDialog.this.updateAll();
            }
        });
        this.btnRemoveInterface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<NetzwerkInterface> nics = JConnectionsDialog.this.internetSwitch.getNetzwerkInterfaces();
                if (!nics.isEmpty()) {
                    NetzwerkInterface nic = nics.get(nics.size() - 1);
                    JConnectionsDialog.this.removeConnection(nic.getPort());
                    JConnectionsDialog.this.internetSwitch.removeNic(nic);
                    JConnectionsDialog.this.updateAll();
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.add(this.btnAddInterface);
        this.buttonPanel.add(this.btnRemoveInterface);
        this.localInterfacesPanel.add(this.buttonPanel);
        SpringLayout layoutLocal = new SpringLayout();
        layoutLocal.putConstraint("North", (Component)lblLocalTitle, 5, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("HorizontalCenter", (Component)lblLocalTitle, 0, "HorizontalCenter", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[0], 25, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[0], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[1], 61, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[1], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[2], 97, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[2], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[3], 133, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[3], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[4], 169, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[4], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[5], 205, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[5], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[6], 241, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[6], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("North", (Component)this.btnLocal[7], 277, "North", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("West", (Component)this.btnLocal[7], 0, "West", (Component)this.localInterfacesPanel);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[0], 0, "VerticalCenter", (Component)this.btnLocal[0]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[0], 10, "East", (Component)this.btnLocal[0]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[1], 0, "VerticalCenter", (Component)this.btnLocal[1]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[1], 10, "East", (Component)this.btnLocal[1]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[2], 0, "VerticalCenter", (Component)this.btnLocal[2]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[2], 10, "East", (Component)this.btnLocal[2]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[3], 0, "VerticalCenter", (Component)this.btnLocal[3]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[3], 10, "East", (Component)this.btnLocal[3]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[4], 0, "VerticalCenter", (Component)this.btnLocal[4]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[4], 10, "East", (Component)this.btnLocal[4]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[5], 0, "VerticalCenter", (Component)this.btnLocal[5]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[5], 10, "East", (Component)this.btnLocal[5]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[6], 0, "VerticalCenter", (Component)this.btnLocal[6]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[6], 10, "East", (Component)this.btnLocal[6]);
        layoutLocal.putConstraint("VerticalCenter", (Component)this.lblLocal[7], 0, "VerticalCenter", (Component)this.btnLocal[7]);
        layoutLocal.putConstraint("West", (Component)this.lblLocal[7], 10, "East", (Component)this.btnLocal[7]);
        layoutLocal.putConstraint("North", (Component)this.buttonPanel, 0, "South", (Component)this.btnLocal[7]);
        layoutLocal.putConstraint("HorizontalCenter", (Component)this.buttonPanel, 0, "HorizontalCenter", (Component)this.localInterfacesPanel);
        this.localInterfacesPanel.setLayout(layoutLocal);
    }

    private void updateAll() {
        this.updateNicToNodeMap(this.internetSwitch);
        this.updateRemoteInterfaces();
        this.updateLocalInterfaces();
        this.updateConnections();
    }

    private Knoten getConnectedComponent(NetzwerkInterface nic) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (JVermittlungsrechnerKonfiguration), holeVerbundeneKomponente(" + String.valueOf(nic) + ")");
        if (nic.getPort().getVerbindung() == null) {
            return null;
        }
        Port lokalerAnschluss = nic.getPort();
        Port[] ports = lokalerAnschluss.getVerbindung().getAnschluesse();
        Port entfernterAnschluss = ports[0] == lokalerAnschluss ? ports[1] : ports[0];
        for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
            Knoten knoten = knotenItem.getKnoten();
            if (knoten instanceof LokalerKnoten) {
                for (Port port : ((LokalerKnoten)knoten).getAnschluesse()) {
                    if (!port.equals(entfernterAnschluss)) continue;
                    return knoten;
                }
                continue;
            }
            if (!(knoten instanceof InternetKnoten)) continue;
            for (NetzwerkInterface networkInterface : ((InternetKnoten)knoten).getNetzwerkInterfaces()) {
                if (!networkInterface.getPort().equals(entfernterAnschluss)) continue;
                return knoten;
            }
        }
        return null;
    }

    private Kabel getConnectedCable(NetzwerkInterface nic) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (JVermittlungsrechnerKonfiguration), getConnectedCable(" + String.valueOf(nic) + ")");
        Verbindung nicConn = nic.getPort().getVerbindung();
        if (nicConn == null) {
            return null;
        }
        for (GUIKabelItem cable : GUIContainer.getGUIContainer().getCableItems()) {
            if (!nicConn.equals(cable.getDasKabel())) continue;
            return cable.getDasKabel();
        }
        return null;
    }

    private void removeConnection(Port port) {
        for (GUIKabelItem cableItem : GUIContainer.getGUIContainer().getCableItems()) {
            if (!cableItem.getDasKabel().getAnschluesse()[0].equals(port) && !cableItem.getDasKabel().getAnschluesse()[1].equals(port)) continue;
            cableItem.getDasKabel().anschluesseTrennen();
            GUIContainer.getGUIContainer().removeCableItem(cableItem);
            GUIContainer.getGUIContainer().updateViewport();
            break;
        }
    }

    private void swapConnection(Port port1, Port port2) {
        Verbindung kabel1 = null;
        int portIdx1 = 0;
        Verbindung kabel2 = null;
        int portIdx2 = 0;
        for (GUIKabelItem cableItem : GUIContainer.getGUIContainer().getCableItems()) {
            Kabel cable = cableItem.getDasKabel();
            if (cable.getAnschluesse()[0].equals(port1)) {
                kabel1 = cable;
                portIdx1 = 0;
                continue;
            }
            if (cable.getAnschluesse()[1].equals(port1)) {
                kabel1 = cable;
                portIdx1 = 1;
                continue;
            }
            if (cable.getAnschluesse()[0].equals(port2)) {
                kabel2 = cable;
                portIdx2 = 0;
                continue;
            }
            if (!cable.getAnschluesse()[1].equals(port2)) continue;
            kabel2 = cable;
            portIdx2 = 1;
        }
        if (kabel1 != null && kabel2 != null && kabel1 != kabel2) {
            kabel1.anschluesseTrennen();
            kabel2.anschluesseTrennen();
            anschluesse = kabel1.getAnschluesse();
            port2.setVerbindung(kabel1);
            anschluesse[portIdx1] = port2;
            kabel1.setAnschluesse(anschluesse);
            anschluesse = kabel2.getAnschluesse();
            port1.setVerbindung(kabel2);
            anschluesse[portIdx2] = port1;
            kabel2.setAnschluesse(anschluesse);
        } else if (kabel1 == null && kabel2 != null) {
            kabel2.anschluesseTrennen();
            port1.setVerbindung(kabel2);
            anschluesse = kabel2.getAnschluesse();
            anschluesse[portIdx2] = port1;
            kabel2.setAnschluesse(anschluesse);
        } else if (kabel1 != null && kabel2 == null) {
            kabel1.anschluesseTrennen();
            anschluesse = kabel1.getAnschluesse();
            port2.setVerbindung(kabel1);
            anschluesse[portIdx1] = port2;
            kabel1.setAnschluesse(anschluesse);
        }
    }

    private class LinePanel
    extends JPanel {
        Point lineStart = new Point(0, 0);
        Point lineEnd = new Point(0, 0);
        Color lineColor = new Color(64, 64, 64);

        LinePanel() {
            this.setOpaque(false);
        }

        public void setStartPoint(int x, int y) {
            this.lineStart = new Point(x, y);
        }

        public void setEndPoint(int x, int y) {
            this.lineEnd = new Point(x, y);
        }

        public void setColor(Color col) {
            this.lineColor = col;
        }

        @Override
        public String toString() {
            return "[name='" + this.getName() + "', start=(" + this.lineStart.x + "/" + this.lineStart.y + "), end=(" + this.lineEnd.x + "/" + this.lineEnd.y + "), color=" + this.lineColor.toString() + ", bounds=" + String.valueOf(this.getBounds()) + "]";
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.lineColor);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(this.lineStart.x, this.lineStart.y, this.lineEnd.x, this.lineEnd.y);
        }
    }
}

