/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.ComboBoxTableCellEditor;
import filius.gui.netzwerksicht.GatewayPortForwardingConfigTable;
import filius.rahmenprogramm.I18n;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPortForwardingDialog
extends JDialog
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(JPortForwardingDialog.class);
    private static final long serialVersionUID = 1L;
    private static final Color TAB_COLOR = new Color(240, 240, 240);
    JPortForwardingDialog jpfd = null;
    private LinkedList<String[]> staticNat;
    private GatewayPortForwardingConfigTable staticTable;

    public JPortForwardingDialog(LinkedList<String[]> staticNat2, JFrame dummyFrame) {
        super(dummyFrame, messages.getString("jgatewayconfiguration_msg19"), true);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", constr: JPortForwardingDialog(" + String.valueOf(staticNat2) + "," + String.valueOf(dummyFrame) + ")");
        this.staticNat = staticNat2;
        this.jpfd = this;
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(10));
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        DefaultTableModel model = new DefaultTableModel(0, 4);
        this.staticTable = new GatewayPortForwardingConfigTable((TableModel)model, true);
        this.staticTable.setParentGUI(this);
        this.staticTable.setSelectionMode(0);
        this.staticTable.setIntercellSpacing(new Dimension(10, 5));
        this.staticTable.setRowHeight(30);
        this.staticTable.setShowGrid(true);
        this.staticTable.setFillsViewportHeight(true);
        this.staticTable.setBackground(Color.WHITE);
        this.staticTable.setShowHorizontalLines(true);
        TableColumnModel columnModel = this.staticTable.getColumnModel();
        columnModel.getColumn(0).setHeaderValue(messages.getString("jportforwarding_msg4"));
        String[] protValues = new String[]{"TCP", "UDP"};
        columnModel.getColumn(0).setCellEditor(new ComboBoxTableCellEditor(protValues));
        columnModel.getColumn(1).setHeaderValue(messages.getString("jportforwarding_msg5"));
        columnModel.getColumn(2).setHeaderValue(messages.getString("jportforwarding_msg6"));
        columnModel.getColumn(3).setHeaderValue(messages.getString("jportforwarding_msg7"));
        columnModel.getColumn(0).setPreferredWidth(80);
        columnModel.getColumn(1).setPreferredWidth(60);
        columnModel.getColumn(2).setPreferredWidth(130);
        columnModel.getColumn(3).setPreferredWidth(60);
        JScrollPane scrollPane = new JScrollPane(this.staticTable);
        scrollPane.setPreferredSize(new Dimension(555, 300));
        vBox.add(scrollPane);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(10));
        JButton button = new JButton(messages.getString("jgatewayconfiguration_msg21"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPortForwardingDialog.this.neuerEintrag();
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(10));
        button = new JButton(messages.getString("jgatewayconfiguration_msg22"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPortForwardingDialog.this.markiertenEintragLoeschen();
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(10));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        this.getContentPane().add(vBox);
        this.getContentPane().setBackground(TAB_COLOR);
    }

    public void neuerEintrag() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", neuerEintrag()");
        this.aenderungenAnnehmen();
        Vector<String> eintrag = new Vector<String>();
        eintrag.addElement("TCP");
        eintrag.addElement("");
        eintrag.addElement("");
        eintrag.addElement("");
        ((DefaultTableModel)this.staticTable.getModel()).addRow(eintrag);
        this.staticTable.setRowSelectionInterval(this.staticTable.getModel().getRowCount() - 1, this.staticTable.getModel().getRowCount() - 1);
    }

    public void markiertenEintragLoeschen() {
        if (this.staticTable.getSelectedRow() > -1) {
            this.entferneEintrag(this.staticTable.getSelectedRow());
            this.aenderungenAnnehmen();
        }
    }

    private void entferneEintrag(int row) {
        ((DefaultTableModel)this.staticTable.getModel()).removeRow(row);
    }

    public void aenderungenAnnehmen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", aenderungenAnnehmen()");
        if (this.staticTable.getCellEditor() != null) {
            this.staticTable.getCellEditor().stopCellEditing();
        }
        Vector<Vector> tableData = ((DefaultTableModel)this.staticTable.getModel()).getDataVector();
        this.staticNat.clear();
        for (int i = 0; i < tableData.size(); ++i) {
            String[] portFordwardingEntry = this.extractRowData(i);
            this.addEintrag(portFordwardingEntry[0], portFordwardingEntry[1], portFordwardingEntry[2], portFordwardingEntry[3]);
        }
        this.updateAttribute();
    }

    private String[] extractRowData(int rowIdx) {
        Vector rowData = ((DefaultTableModel)this.staticTable.getModel()).getDataVector().elementAt(rowIdx);
        String[] portFordwardingEntry = new String[rowData.size()];
        for (int j = 0; j < portFordwardingEntry.length; ++j) {
            portFordwardingEntry[j] = (String)rowData.elementAt(j);
        }
        return portFordwardingEntry;
    }

    public void updateAttribute() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", updateAttribute()");
        DefaultTableModel model = (DefaultTableModel)this.staticTable.getModel();
        model.setRowCount(0);
        this.createStaticTable();
        model.fireTableDataChanged();
    }

    public void createStaticTable() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + ", createStaticTable()");
        DefaultTableModel model = (DefaultTableModel)this.staticTable.getModel();
        for (int i = 0; i < this.staticNat.size(); ++i) {
            model.addRow(this.staticNat.get(i));
        }
    }

    public LinkedList<String[]> getStaticNATTable() {
        return this.staticNat;
    }

    public void addEintrag(String protocol, String port, String lanIp, String lanPort) {
        String[] data = new String[]{protocol, port, lanIp, lanPort};
        this.staticNat.add(data);
    }
}

