/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.JMainFrame;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSidebarButton
extends JLabel
implements Observer,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(JSidebarButton.class);
    private static final int BORDER = 8;
    private String typ;
    private boolean selektiert;
    private boolean modemVerbunden;
    private boolean isTemporaryText;
    private String originalText;
    private Color originalTextColor;

    public boolean isSelektiert() {
        return this.selektiert;
    }

    public void setSelektiert(boolean selektiert) {
        this.selektiert = selektiert;
    }

    public String getTyp() {
        return this.typ;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public JSidebarButton() {
        this.initAlignment();
    }

    private void initAlignment() {
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setAlignmentX(0.5f);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
    }

    public JSidebarButton(Icon icon, String typ) {
        super(icon, 0);
        this.typ = typ;
        this.initAlignment();
    }

    public JSidebarButton(String text, Icon icon, String typ) {
        super(text, icon, 0);
        this.typ = typ;
        this.initAlignment();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle((int)super.getBounds().getX(), (int)super.getBounds().getY(), this.getWidth(), this.getHeight());
    }

    public boolean inBounds(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    @Override
    public int getWidth() {
        int width = 0;
        if (null != this.getText()) {
            width = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
        }
        if (this.getIcon() != null && this.getIcon().getIconWidth() > width) {
            width = this.getIcon().getIconWidth();
        }
        return width += 21;
    }

    @Override
    public int getHeight() {
        int height = this.getFontMetrics(this.getFont()).getHeight();
        if (this.getIcon() != null) {
            height += this.getIcon().getIconHeight();
        }
        return height += 5;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void setTextAndUpdateLocation(String text) {
        int icoW;
        int n = icoW = this.getIcon() != null ? this.getIcon().getIconWidth() : 0;
        if (icoW % 2 == 1) {
            --icoW;
        }
        int dW = (this.getWidth() - icoW) / 2;
        super.setText(text);
        int dW2 = (this.getWidth() - icoW) / 2;
        this.setBounds(this.getX() - dW2 + dW, this.getY(), this.getWidth(), this.getHeight());
    }

    public void initTextAndUpdateLocation(String text) {
        this.setTextAndUpdateLocation(text);
        this.setLocation(this.getX(), this.getY() + 10);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.selektiert) {
            g.setColor(new Color(0, 0, 0));
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f}, 0.0f);
            g2.setStroke(stroke);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(new Color(0.8f, 0.92f, 1.0f, 0.2f));
            g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (this.modemVerbunden) {
            g2d.setColor(new Color(0, 255, 0));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillOval(this.getWidth() / 2 - 6, this.getHeight() / 2 - 6, 12, 12);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        LOG.trace("(JSidebarButton), update(" + String.valueOf(o) + "," + String.valueOf(arg) + ")");
        if (arg != null && arg.equals(Boolean.TRUE)) {
            this.modemVerbunden = true;
        } else if (arg != null && arg.equals(Boolean.FALSE)) {
            this.modemVerbunden = false;
        } else if (arg != null && arg instanceof String) {
            JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), arg);
        } else if (arg != null && arg instanceof Host) {
            this.setText(((Host)arg).holeAnzeigeName());
        }
        if (arg != null && arg instanceof InternetKnoten) {
            this.updateTooltip((InternetKnoten)arg);
        }
        this.updateUI();
    }

    void updateTooltip(InternetKnoten knoten) {
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html><pre>");
        tooltip.append(messages.getString("jsidebar_tooltip_ipAddress")).append(":");
        String gateway = null;
        String dns = null;
        for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
            tooltip.append("\n ").append(nic.getIp()).append(" / ").append(nic.getSubnetzMaske());
            tooltip.append(" (").append(nic.getMac()).append(")");
            gateway = nic.getGateway();
            dns = nic.getDns();
        }
        tooltip.append("\n").append(messages.getString("jsidebar_tooltip_gateway")).append(": ").append(gateway);
        if (knoten instanceof Host) {
            tooltip.append("\n").append(messages.getString("jsidebar_tooltip_dnsServer")).append(": ").append(dns);
        }
        tooltip.append("</pre></html>");
        this.setToolTipText(tooltip.toString());
    }

    public void setTemporaryText(String text) {
        if (!this.isTemporaryText) {
            this.originalText = this.getText();
            this.originalTextColor = this.getForeground();
            this.isTemporaryText = true;
        }
        this.setForeground(Color.GRAY);
        this.setTextAndUpdateLocation(text);
    }

    public void resetText() {
        this.setForeground(this.originalTextColor);
        this.setTextAndUpdateLocation(this.originalText);
        this.isTemporaryText = false;
    }
}

