/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.schichtensicht;

import filius.gui.schichtensicht.LayerPathDialog;
import filius.gui.schichtensicht.LocalLayerPathPanel;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GlobalLayerPath
extends JPanel
implements I18n {
    private static final Lauscher LAUSCHER = Lauscher.getLauscher();
    private static final int MAX_TTL = 64;
    private final JFrame OWNER;
    private final String MAIN_INTERFACE_ID;
    private final Knoten MAIN_NODE;
    private final int MAIN_FRAME_NUMBER;
    private final EthernetFrame MAIN_FRAME;
    private final LayerPathDialog MAIN_DIALOG;
    private final LocalLayerPathPanel MAIN_LOCAL_PANEL;
    private int currentLocalPanelPathIndex = 0;
    private int currentLocalPanelParametersPathIndex = 0;
    private boolean activeBorderOfNextPanelAtEnd;
    ArrayList<EthernetFrame> framePath = new ArrayList();
    ArrayList<LocalLayerPathPanel> localPanelPath = new ArrayList();
    ArrayList<Object[]> localPanelParametersPath = new ArrayList();
    Object[] MAIN_LOCAL_PANEL_PARAMETERS;

    public GlobalLayerPath(JFrame owner, String interfaceId, SystemSoftware systemSoftware, int frameNumber) {
        this.OWNER = owner;
        this.MAIN_NODE = (InternetKnoten)systemSoftware.getKnoten();
        this.MAIN_LOCAL_PANEL_PARAMETERS = new Object[]{interfaceId, systemSoftware, frameNumber};
        this.MAIN_INTERFACE_ID = interfaceId;
        this.MAIN_FRAME_NUMBER = frameNumber;
        this.MAIN_FRAME = LAUSCHER.getFrame(this.MAIN_INTERFACE_ID, this.MAIN_FRAME_NUMBER);
        this.MAIN_DIALOG = new LayerPathDialog(owner, interfaceId, systemSoftware, frameNumber, this, true);
        this.MAIN_LOCAL_PANEL = this.MAIN_DIALOG.getLocalLayerPathPanel();
        this.MAIN_LOCAL_PANEL.setAsMainNode(true);
        this.MAIN_DIALOG.setTitle(messages.getString("schichten_globaler_weg_msg1"));
        this.fillFramePath();
        this.localPanelPath.add(this.MAIN_LOCAL_PANEL);
        this.fillLocalPanelParametersPath();
        this.currentLocalPanelParametersPathIndex = this.localPanelParametersPath.indexOf(this.MAIN_LOCAL_PANEL_PARAMETERS);
        this.MAIN_DIALOG.setVisible(true);
    }

    public boolean isActiveBorderOfNextPanelAtEnd() {
        return this.activeBorderOfNextPanelAtEnd;
    }

    private void fillFramePath() {
        if (this.MAIN_FRAME.getDaten() instanceof ArpPaket || this.MAIN_FRAME.getZielMacAdresse().equals("FF:FF:FF:FF:FF:FF") && !this.MAIN_FRAME.getQuellMacAdresse().equals(this.MAIN_INTERFACE_ID)) {
            this.addToFramePath(this.MAIN_FRAME);
        } else if (this.MAIN_FRAME.getDaten() instanceof IpPaket) {
            EthernetFrame frame;
            for (int ttl = 64; ttl > 0 && (frame = LAUSCHER.getFrameWithSameContentAndSpecificTTL(this.MAIN_FRAME, ttl)) != null; --ttl) {
                this.addToFramePath(frame);
            }
        }
    }

    private void addToFramePath(EthernetFrame frame) {
        if (frame.sameContent(this.MAIN_FRAME)) {
            this.framePath.add(this.MAIN_FRAME);
        } else {
            this.framePath.add(frame);
        }
    }

    private void fillLocalPanelParametersPath() {
        if (this.MAIN_FRAME.getZielMacAdresse().equals("FF:FF:FF:FF:FF:FF") && !this.MAIN_FRAME.getQuellMacAdresse().equals(this.MAIN_INTERFACE_ID)) {
            String interfaceId = this.MAIN_FRAME.getQuellMacAdresse();
            SystemSoftware systemSoftware = LAUSCHER.getSystemSoftwareByID(interfaceId);
            int frameNumber = LAUSCHER.getFrameNumber(interfaceId, this.MAIN_FRAME);
            this.addToLocalPanelPath(interfaceId, systemSoftware, frameNumber);
            interfaceId = this.MAIN_INTERFACE_ID;
            systemSoftware = LAUSCHER.getSystemSoftwareByID(interfaceId);
            frameNumber = LAUSCHER.getFrameNumber(interfaceId, this.MAIN_FRAME);
            this.addToLocalPanelPath(interfaceId, systemSoftware, frameNumber);
        } else {
            EthernetFrame firstFrame = this.framePath.get(0);
            String interfaceId = firstFrame.getQuellMacAdresse();
            SystemSoftware systemSoftware = LAUSCHER.getSystemSoftwareByID(interfaceId);
            int frameNumber = LAUSCHER.getFrameNumber(interfaceId, firstFrame);
            this.addToLocalPanelPath(interfaceId, systemSoftware, frameNumber);
            for (EthernetFrame frame : this.framePath) {
                interfaceId = frame.getZielMacAdresse();
                systemSoftware = LAUSCHER.getSystemSoftwareByID(interfaceId);
                frameNumber = LAUSCHER.getFrameNumber(interfaceId, frame);
                this.addToLocalPanelPath(interfaceId, systemSoftware, frameNumber);
            }
        }
    }

    private void addToLocalPanelPath(String interfaceId, SystemSoftware systemSoftware, int frameNumber) {
        EthernetFrame frame = LAUSCHER.getFrame(interfaceId, frameNumber);
        if (systemSoftware.getKnoten().equals(this.MAIN_NODE)) {
            if (!this.MAIN_LOCAL_PANEL.isForwarded()) {
                this.localPanelParametersPath.add(this.MAIN_LOCAL_PANEL_PARAMETERS);
                return;
            }
            if (this.MAIN_FRAME.getDaten() instanceof IpPaket && (this.MAIN_LOCAL_PANEL.isSent() && ((IpPaket)this.MAIN_FRAME.getDaten()).getTtl() == ((IpPaket)frame.getDaten()).getTtl() - 1 || !this.MAIN_LOCAL_PANEL.isSent() && ((IpPaket)this.MAIN_FRAME.getDaten()).getTtl() == ((IpPaket)frame.getDaten()).getTtl())) {
                this.localPanelParametersPath.add(this.MAIN_LOCAL_PANEL_PARAMETERS);
                return;
            }
        }
        this.localPanelParametersPath.add(new Object[]{interfaceId, systemSoftware, frameNumber});
    }

    public void switchPanel(Boolean switchForward) {
        LocalLayerPathPanel newPanel;
        LocalLayerPathPanel oldPanel = this.localPanelPath.get(this.currentLocalPanelPathIndex);
        oldPanel.setVisible(false);
        this.MAIN_DIALOG.remove(oldPanel);
        if (switchForward.booleanValue()) {
            ++this.currentLocalPanelPathIndex;
            ++this.currentLocalPanelParametersPathIndex;
            if (this.currentLocalPanelPathIndex - 1 < this.localPanelPath.size() - 1) {
                newPanel = this.localPanelPath.get(this.currentLocalPanelPathIndex);
            } else {
                Object[] parameters = this.localPanelParametersPath.get(this.currentLocalPanelParametersPathIndex);
                String interfaceId = (String)parameters[0];
                SystemSoftware systemSoftware = (SystemSoftware)parameters[1];
                int frameNumber = (Integer)parameters[2];
                this.activeBorderOfNextPanelAtEnd = false;
                newPanel = new LocalLayerPathPanel(this.OWNER, interfaceId, systemSoftware, frameNumber, this, false);
                this.localPanelPath.add(newPanel);
            }
        } else {
            --this.currentLocalPanelParametersPathIndex;
            if (this.currentLocalPanelPathIndex > 0) {
                --this.currentLocalPanelPathIndex;
                newPanel = this.localPanelPath.get(this.currentLocalPanelPathIndex);
                this.MAIN_DIALOG.add(newPanel);
            } else {
                Object[] parameters = this.localPanelParametersPath.get(this.currentLocalPanelParametersPathIndex);
                String interfaceId = (String)parameters[0];
                SystemSoftware systemSoftware = (SystemSoftware)parameters[1];
                int frameNumber = (Integer)parameters[2];
                this.activeBorderOfNextPanelAtEnd = true;
                newPanel = new LocalLayerPathPanel(this.OWNER, interfaceId, systemSoftware, frameNumber, this, false);
                this.localPanelPath.add(0, newPanel);
            }
        }
        newPanel.setDividerLocation(oldPanel.getDividerLocation());
        this.MAIN_DIALOG.add(newPanel);
        newPanel.setVisible(true);
    }
}

