/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.schichtensicht;

import filius.gui.nachrichtensicht.MessageDetailsTable;
import filius.gui.schichtensicht.GlobalLayerPath;
import filius.gui.schichtensicht.LocalLayerPathVisualisation;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.system.SystemSoftware;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.NoSuchElementException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class LocalLayerPathPanel
extends JPanel {
    private final Knoten NODE;
    private final String INTERFACE_ID;
    private final int FRAME_NUMBER;
    private final GlobalLayerPath globalLayerPath;
    private final boolean SENT;
    private final boolean FORWARDED;
    private final JSplitPane SPLIT_PANE;
    private static final int DEFAULT_DIVIDER_LOCATION = 475;
    private MessageDetailsTable tableSent;
    private MessageDetailsTable tableReceived;
    private final String CORR_INTERFACE_ID;
    private final Integer CORR_FRAME_NUMBER;
    private final int MAX_LAYER_INSIDE_FRAME;
    private final int MAX_LAYER_OF_OPERATION;
    private int hiddenLayers;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private boolean isMainNode;

    public LocalLayerPathPanel(JFrame owner, String interfaceId, SystemSoftware systemSoftware, int selectedFrameNumber, GlobalLayerPath globalLayerPath, boolean isMainNode) {
        this.NODE = systemSoftware.getKnoten();
        this.INTERFACE_ID = interfaceId;
        this.FRAME_NUMBER = selectedFrameNumber;
        this.globalLayerPath = globalLayerPath;
        this.isMainNode = isMainNode;
        this.MAX_LAYER_OF_OPERATION = ((InternetKnoten)this.getKnoten()).getMaxLayerOfOperation();
        this.SENT = LocalLayerPathPanel.isFrameSent(interfaceId, selectedFrameNumber);
        this.createPrimaryMessageDetailsTable();
        Object[] corrFrameData = Lauscher.getLauscher().getCorrespondingFrame(this.INTERFACE_ID, this.FRAME_NUMBER, (InternetKnoten)this.NODE);
        this.CORR_INTERFACE_ID = (String)corrFrameData[0];
        this.CORR_FRAME_NUMBER = (Integer)corrFrameData[1];
        this.FORWARDED = (this.NODE instanceof Vermittlungsrechner || this.NODE instanceof Gateway) && this.CORR_INTERFACE_ID != null && this.CORR_FRAME_NUMBER != null;
        this.createSecondaryMessageDetailsTable();
        if (this.SENT) {
            this.MAX_LAYER_INSIDE_FRAME = this.tableSent.getMaxLayerInsideFrame();
            this.tableSent.setLayersInvisible();
            if (this.FORWARDED) {
                this.tableReceived.setLayersInvisible();
            }
        } else {
            this.MAX_LAYER_INSIDE_FRAME = this.tableReceived.getMaxLayerInsideFrame();
            this.tableReceived.setLayersInvisible();
        }
        this.SPLIT_PANE = new JSplitPane();
        this.SPLIT_PANE.setOrientation(0);
        this.SPLIT_PANE.setDividerLocation(475);
        this.SPLIT_PANE.setEnabled(false);
        this.setFirstMessageDetails();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.SPLIT_PANE, "Center");
        this.SPLIT_PANE.setTopComponent(new LocalLayerPathVisualisation(this, globalLayerPath));
    }

    public Knoten getKnoten() {
        return this.NODE;
    }

    public String getInterfaceId() {
        return this.INTERFACE_ID;
    }

    public int getMaxLayerInsideFrame() {
        return this.MAX_LAYER_INSIDE_FRAME;
    }

    public int getMaxLayerOfOperation() {
        return this.MAX_LAYER_OF_OPERATION;
    }

    public String getCorrInterfaceId() {
        return this.CORR_INTERFACE_ID;
    }

    public boolean isSent() {
        return this.SENT;
    }

    public boolean isForwarded() {
        return this.FORWARDED;
    }

    public int getDefaultDividerLocation() {
        return 475;
    }

    public void setDividerLocation(int dividerLocation) {
        this.SPLIT_PANE.setDividerLocation(dividerLocation);
    }

    public int getDividerLocation() {
        return this.SPLIT_PANE.getDividerLocation();
    }

    public static Color getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    public boolean isMainNode() {
        return this.isMainNode;
    }

    public void setAsMainNode(boolean isMainNode) {
        this.isMainNode = isMainNode;
    }

    public Dimension getSizeOfMessageDetailsTable() {
        return MessageDetailsTable.getSizeOfMessageDetailsTable();
    }

    public static boolean isFrameSent(String interfaceId, int selectedFrameNumber) {
        return interfaceId.equals(Lauscher.getLauscher().getFrame(interfaceId, selectedFrameNumber).getQuellMacAdresse());
    }

    private void createPrimaryMessageDetailsTable() {
        if (this.SENT) {
            this.tableSent = new MessageDetailsTable(this.INTERFACE_ID, this.FRAME_NUMBER, BACKGROUND_COLOR);
        } else {
            this.tableReceived = new MessageDetailsTable(this.INTERFACE_ID, this.FRAME_NUMBER, BACKGROUND_COLOR);
        }
    }

    private void createSecondaryMessageDetailsTable() {
        if (this.FORWARDED) {
            if (this.SENT) {
                this.tableReceived = new MessageDetailsTable(this.CORR_INTERFACE_ID, this.CORR_FRAME_NUMBER, BACKGROUND_COLOR);
            } else {
                this.tableSent = new MessageDetailsTable(this.CORR_INTERFACE_ID, this.CORR_FRAME_NUMBER, BACKGROUND_COLOR);
            }
        }
    }

    private void setFirstMessageDetails() {
        if (this.SENT) {
            this.SPLIT_PANE.setBottomComponent(this.tableSent);
            if (this.NODE instanceof Host) {
                if (this.globalLayerPath == null || !this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()) {
                    for (int i = 1; i < this.MAX_LAYER_INSIDE_FRAME; ++i) {
                        this.hideLayerData(i, this.tableSent);
                    }
                    this.hiddenLayers = this.MAX_LAYER_INSIDE_FRAME - 1;
                } else {
                    this.hiddenLayers = 0;
                }
            } else if (this.NODE instanceof Vermittlungsrechner || this.NODE instanceof Gateway) {
                this.hideLayerData(1, this.tableSent);
                this.hiddenLayers = 1;
                if (this.FORWARDED) {
                    this.hideLayerData(1, this.tableReceived);
                }
            }
        } else if (this.globalLayerPath != null && this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()) {
            this.SPLIT_PANE.setBottomComponent(this.tableSent);
        } else {
            this.SPLIT_PANE.setBottomComponent(this.tableReceived);
        }
        if (this.SENT) {
            this.updateGreyedOutCells(this.tableSent);
            if (this.FORWARDED) {
                this.updateGreyedOutCells(this.tableReceived);
            }
        } else {
            this.updateGreyedOutCells(this.tableReceived);
            if (this.FORWARDED) {
                this.updateGreyedOutCells(this.tableSent);
            }
        }
    }

    public void updateMessageDetailsDisplay(boolean senderSideIsActive, boolean senderSideWasActive) {
        if (senderSideIsActive != senderSideWasActive) {
            if (senderSideIsActive) {
                int currentDividerLocation = this.SPLIT_PANE.getDividerLocation();
                this.SPLIT_PANE.setBottomComponent(this.tableSent);
                this.SPLIT_PANE.setDividerLocation(currentDividerLocation);
            } else {
                int currentDividerLocation = this.SPLIT_PANE.getDividerLocation();
                this.SPLIT_PANE.setBottomComponent(this.tableReceived);
                this.SPLIT_PANE.setDividerLocation(currentDividerLocation);
            }
        }
    }

    public void hideNextHigherLayer() {
        if (this.hiddenLayers <= 2 && this.hiddenLayers >= 0) {
            ++this.hiddenLayers;
            if (this.SENT) {
                this.updateGreyedOutCells(this.tableSent);
                this.hideLayerData(this.hiddenLayers, this.tableSent);
                if (this.FORWARDED) {
                    this.updateGreyedOutCells(this.tableReceived);
                    this.hideLayerData(this.hiddenLayers, this.tableReceived);
                }
            } else {
                this.updateGreyedOutCells(this.tableReceived);
                this.hideLayerData(this.hiddenLayers, this.tableReceived);
                if (this.FORWARDED) {
                    this.updateGreyedOutCells(this.tableSent);
                    this.hideLayerData(this.hiddenLayers, this.tableSent);
                }
            }
        }
    }

    public void showNextLowerLayer() {
        if (this.hiddenLayers <= 3 && this.hiddenLayers >= 1) {
            --this.hiddenLayers;
            if (this.SENT) {
                this.updateGreyedOutCells(this.tableSent);
                this.showLayerData(this.hiddenLayers + 1, this.tableSent);
                if (this.FORWARDED) {
                    this.updateGreyedOutCells(this.tableReceived);
                    this.showLayerData(this.hiddenLayers + 1, this.tableReceived);
                }
            } else {
                this.updateGreyedOutCells(this.tableReceived);
                this.showLayerData(this.hiddenLayers + 1, this.tableReceived);
                if (this.FORWARDED) {
                    this.updateGreyedOutCells(this.tableSent);
                    this.showLayerData(this.hiddenLayers + 1, this.tableSent);
                }
            }
        }
    }

    private void hideLayerData(int layerNumber, MessageDetailsTable table) throws NoSuchElementException {
        if (layerNumber > 3 || layerNumber < 1) {
            throw new NoSuchElementException("layerNumber has to be an integer from 1 to 3.");
        }
        HashSet<Integer> columns = new HashSet<Integer>();
        int firstColumn = (layerNumber - 1) * 2;
        columns.add(firstColumn);
        columns.add(firstColumn + 1);
        for (Component component : table.getComponents()) {
            if (!columns.contains(table.getGridBagLayout().getConstraints((Component)component).gridx) || table.getGridBagLayout().getConstraints((Component)component).gridy <= 1) continue;
            component.setBackground(table.getBackground());
            component.setForeground(table.getBackground());
            table.setBorderVisible(component, false);
        }
    }

    private void showLayerData(int layerNumber, MessageDetailsTable table) throws NoSuchElementException {
        if (layerNumber > 3 || layerNumber < 1) {
            throw new NoSuchElementException("layerNumber has to be an integer from 1 to 3.");
        }
        HashSet<Integer> columns = new HashSet<Integer>();
        int firstColumn = (layerNumber - 1) * 2;
        columns.add(firstColumn);
        columns.add(firstColumn + 1);
        for (Component component : table.getComponents()) {
            int gridy;
            if (!columns.contains(table.getGridBagLayout().getConstraints((Component)component).gridx) || (gridy = table.getGridBagLayout().getConstraints((Component)component).gridy) <= 1) continue;
            component.setForeground(MessageDetailsTable.getLayerColorVar("foregroundColor", layerNumber));
            if (gridy == 0) {
                component.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorFine", layerNumber));
                continue;
            }
            component.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColor", layerNumber));
            table.setBorderVisible(component, true);
        }
    }

    private void updateGreyedOutCells(MessageDetailsTable table) {
        HashSet<Integer> columns = new HashSet<Integer>();
        for (int columnNo = (this.hiddenLayers + 1) * 2; columnNo <= 6; ++columnNo) {
            columns.add(columnNo);
        }
        for (Component component : table.getComponents()) {
            int xCoord = table.getGridBagLayout().getConstraints((Component)component).gridx;
            int yCoord = table.getGridBagLayout().getConstraints((Component)component).gridy;
            if (yCoord < 2) continue;
            if (columns.contains(xCoord)) {
                if (xCoord >= 2 && xCoord <= 3) {
                    this.setComponentGreyedOut(component, 2);
                    continue;
                }
                if (xCoord >= 4 && xCoord <= 5) {
                    this.setComponentGreyedOut(component, 3);
                    continue;
                }
                if (xCoord != 6) continue;
                this.setComponentGreyedOut(component, 4);
                continue;
            }
            if (xCoord == 7) continue;
            if (xCoord >= 2 && xCoord <= 3) {
                this.resetComponentFromGreyedOut(component, 2);
                continue;
            }
            if (xCoord >= 4 && xCoord <= 5) {
                this.resetComponentFromGreyedOut(component, 3);
                continue;
            }
            if (xCoord != 6) continue;
            this.resetComponentFromGreyedOut(component, 4);
        }
    }

    private void setComponentGreyedOut(Component component, int layerNumber) {
        component.setForeground(MessageDetailsTable.getLayerColorVar("foregroundColorGreyedOut", layerNumber));
        component.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", layerNumber));
    }

    private void resetComponentFromGreyedOut(Component component, int layerNumber) {
        if (this.hiddenLayers < layerNumber) {
            component.setForeground(Color.BLACK);
            component.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColor", layerNumber));
        }
    }
}

