/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.schichtensicht;

import filius.gui.nachrichtensicht.MessageDetailsTable;
import filius.gui.schichtensicht.GlobalLayerPath;
import filius.gui.schichtensicht.LocalLayerPathPanel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class LocalLayerPathVisualisation
extends JPanel
implements I18n {
    private final LocalLayerPathPanel LAYER_PATH_PANEL;
    private final GlobalLayerPath globalLayerPath;
    private final GridBagLayout GB_LAYOUT = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private int pointInTime;
    private int minPointInTime;
    private int maxPointInTime;
    private boolean senderSideIsActive;
    private boolean senderSideWasActive;
    private int pointInTimeForSenderSide;
    private static final int X_OFFSET = 2;
    private static final int Y_OFFSET = 1;
    private static final int GAP_BETWEEN_CELLS = 12;
    private static final int RECTANGLE_WIDTH = 200;
    private static final int RECTANGLE_RATIO = 3;
    private static final int RECTANGLE_HEIGHT = 66;
    private static final int MAIN_BORDER_WIDTH = 1;
    private static final int INDENT_NESTED_MSGS = 20;
    private static final int BORDER_NESTED_MSGS = 5;
    private static final int SQUARE_SIDE_LENGTH = 66;
    private static final int NODE_NAME_CELL_HEIGHT = 19;
    private static final int NODE_INFO_CELL_HEIGHT = (int)Math.round(103.35917312661499);
    private static final Color ACTIVE_BORDER_COLOR_OUTSIDE = Color.decode("#00E000");
    private static final Color ACTIVE_BORDER_COLOR_INSIDE = Color.decode("#00CCC00");
    private static final Color INACTIVE_BORDER_COLOR = Color.decode("#8C8C8C");
    private static final Color INACTIVE_ARROW_COLOR = Color.BLACK;
    private static final Color ACTIVE_ARROW_COLOR = ACTIVE_BORDER_COLOR_INSIDE;
    private static final Color MAIN_NODE_NAME_BG_COLOR = Color.decode("#AEECB7");
    private static final Color MAIN_NODE_INFO_BG_COLOR = Color.decode("#ECFAEE");
    private static final Color NODE_NAME_BG_COLOR = Color.decode("#D7D7D7");
    private static final Color NODE_INFO_BG_COLOR = Color.decode("#F7F7F7");
    private final JButton FORTH_IN_TIME;
    private final JButton BACK_IN_TIME;

    public LocalLayerPathVisualisation(LocalLayerPathPanel layerPathPanel, GlobalLayerPath globalLayerPath) {
        this.LAYER_PATH_PANEL = layerPathPanel;
        this.globalLayerPath = globalLayerPath;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setBackground(LocalLayerPathPanel.getBackgroundColor());
        this.setLayout(this.GB_LAYOUT);
        this.setBackground(LocalLayerPathPanel.getBackgroundColor());
        this.c.anchor = 11;
        this.c.fill = 0;
        BufferedImage arrowRightBI = null;
        BufferedImage arrowLeftBI = null;
        try {
            arrowRightBI = ImageIO.read(this.getClass().getResource("/gfx/allgemein/arrow_right.png"));
            arrowLeftBI = ImageIO.read(this.getClass().getResource("/gfx/allgemein/arrow_left.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Image arrowRight = arrowRightBI.getScaledInstance(200, NODE_INFO_CELL_HEIGHT, 4);
        Image arrowLeft = arrowLeftBI.getScaledInstance(200, NODE_INFO_CELL_HEIGHT, 4);
        this.FORTH_IN_TIME = new JButton(new ImageIcon(arrowRight));
        this.FORTH_IN_TIME.setFocusable(false);
        this.BACK_IN_TIME = new JButton(new ImageIcon(arrowLeft));
        this.BACK_IN_TIME.setFocusable(false);
        this.FORTH_IN_TIME.setPreferredSize(new Dimension(200, NODE_INFO_CELL_HEIGHT));
        this.BACK_IN_TIME.setPreferredSize(new Dimension(200, NODE_INFO_CELL_HEIGHT));
        this.backAndForth();
        if (globalLayerPath == null && (!this.LAYER_PATH_PANEL.isSent() || !this.LAYER_PATH_PANEL.isForwarded() && this.LAYER_PATH_PANEL.isSent())) {
            this.BACK_IN_TIME.setEnabled(false);
        }
        this.senderSideWasActive = this.senderSideIsActive = this.LAYER_PATH_PANEL.isSent();
        if (!this.LAYER_PATH_PANEL.isForwarded()) {
            this.addSidePanel(this.BACK_IN_TIME, 0);
            this.addSidePanel(this.FORTH_IN_TIME, 7);
            if (this.LAYER_PATH_PANEL.isSent()) {
                this.minPointInTime = 4 - this.LAYER_PATH_PANEL.getMaxLayerInsideFrame();
                this.maxPointInTime = 4;
                this.pointInTimeForSenderSide = -1;
            } else {
                this.minPointInTime = 0;
                this.maxPointInTime = Math.min(this.LAYER_PATH_PANEL.getMaxLayerInsideFrame(), this.LAYER_PATH_PANEL.getMaxLayerOfOperation());
                this.pointInTimeForSenderSide = 5;
            }
            this.pointInTime = globalLayerPath == null ? this.minPointInTime : (globalLayerPath.isActiveBorderOfNextPanelAtEnd() ? this.maxPointInTime : this.minPointInTime);
            this.visualisationSentOrReceived();
        } else {
            this.addSidePanel(this.BACK_IN_TIME, 0);
            this.addSidePanel(this.FORTH_IN_TIME, 12);
            this.minPointInTime = 0;
            this.maxPointInTime = 5;
            this.pointInTime = globalLayerPath == null || !globalLayerPath.isActiveBorderOfNextPanelAtEnd() ? (this.LAYER_PATH_PANEL.isSent() ? this.minPointInTime + 3 : this.minPointInTime) : this.maxPointInTime;
            this.pointInTimeForSenderSide = this.minPointInTime + 3;
            this.visualisationForwarded();
        }
    }

    public int getPointInTime() {
        return this.pointInTime;
    }

    public int getMaxPointInTime() {
        return this.maxPointInTime;
    }

    public int getMinPointInTime() {
        return this.minPointInTime;
    }

    private void visualisationSentOrReceived() {
        int xCoord3;
        int xCoord2;
        int xCoord1;
        int xCoord0;
        this.c = new GridBagConstraints();
        if (this.LAYER_PATH_PANEL.isSent()) {
            xCoord0 = 2;
            xCoord1 = 3;
            xCoord2 = 4;
            xCoord3 = 5;
            if (this.globalLayerPath == null) {
                this.coloredLayerIndicators(1, 66, true);
            } else {
                this.coloredLayerIndicators(1, 476, true);
            }
            this.coloredLayerIndicators(3, 66, false);
            this.coloredLayerIndicators(4, 66, false);
            this.coloredLayerIndicators(5, 66, false);
            this.coloredLayerIndicators(6, 66, true);
        } else {
            xCoord0 = 5;
            xCoord1 = 4;
            xCoord2 = 3;
            xCoord3 = 2;
            this.coloredLayerIndicators(1, 66, true);
            this.coloredLayerIndicators(2, 66, false);
            this.coloredLayerIndicators(3, 66, false);
            this.coloredLayerIndicators(4, 66, false);
            if (this.globalLayerPath == null) {
                this.coloredLayerIndicators(6, 66, true);
            } else {
                this.coloredLayerIndicators(6, 476, true);
            }
        }
        JLabel label = this.setEmptyCell(this, xCoord0, 1, 1, 1);
        this.setSize(label, 200, 12);
        label = this.setLabel(this, this.LAYER_PATH_PANEL.getKnoten().holeAnzeigeName(), xCoord0, 2, 1, 1, true);
        this.setSize(label, 200, 19);
        label.setHorizontalAlignment(0);
        if (this.LAYER_PATH_PANEL.isMainNode()) {
            label.setBackground(MAIN_NODE_NAME_BG_COLOR);
        } else {
            label.setBackground(NODE_NAME_BG_COLOR);
        }
        label = this.setEmptyCell(this, xCoord0, 3, 1, 1);
        this.setSize(label, 200, 12);
        String nodeInfo = this.createNodeInfoByMac(this.LAYER_PATH_PANEL.getInterfaceId());
        JEditorPane editorPane = this.setEditorPane(this, nodeInfo, xCoord0, 4, 1, 1, true);
        this.setSize(editorPane, 200, NODE_INFO_CELL_HEIGHT);
        if (this.LAYER_PATH_PANEL.isMainNode()) {
            editorPane.setBackground(MAIN_NODE_INFO_BG_COLOR);
        } else {
            editorPane.setBackground(NODE_INFO_BG_COLOR);
        }
        label = this.setEmptyCell(this, xCoord0, 5, 1, 1);
        this.setSize(label, 200, 12);
        this.createRectangularNestedMessages(xCoord0, null);
        label = new WireWithArrow(null, true, 66, 66, this.globalLayerPath != null && this.globalLayerPath.isActiveBorderOfNextPanelAtEnd());
        this.setFinishedLabel(this, label, xCoord1, 12, 1, 1);
        label = new NestedMessagesVisualisation(1, 66, 1, !this.LAYER_PATH_PANEL.isSent() || this.globalLayerPath != null && this.globalLayerPath.isActiveBorderOfNextPanelAtEnd());
        this.setFinishedLabel(this, label, xCoord2, 12, 1, 1);
        label = new WireWithArrow(null, true, 66, 66, !this.LAYER_PATH_PANEL.isSent());
        this.setFinishedLabel(this, label, xCoord3, 12, 1, 1);
    }

    private void visualisationForwarded() {
        String nodeInfoRight;
        String nodeInfoLeft;
        this.c = new GridBagConstraints();
        this.coloredLayerIndicators(1, 66, true);
        this.coloredLayerIndicators(2, 66, false);
        this.coloredLayerIndicators(3, 66, false);
        this.coloredLayerIndicators(4, 66, false);
        this.coloredLayerIndicators(8, 66, false);
        this.coloredLayerIndicators(9, 66, false);
        this.coloredLayerIndicators(10, 66, false);
        this.coloredLayerIndicators(11, 66, true);
        JLabel label = new WireWithArrow(null, true, 66, 66, !this.LAYER_PATH_PANEL.isSent() && (this.globalLayerPath == null || !this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()));
        this.setFinishedLabel(this, label, 2, 12, 1, 1);
        label = new WireWithArrow(null, true, 66, 66, false);
        this.setFinishedLabel(this, label, 10, 12, 1, 1);
        label = new NestedMessagesVisualisation(1, 66, 1, !this.LAYER_PATH_PANEL.isSent() && (this.globalLayerPath == null || !this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()));
        this.setFinishedLabel(this, label, 3, 12, 1, 1);
        label = new NestedMessagesVisualisation(1, 66, 1, this.globalLayerPath != null && this.globalLayerPath.isActiveBorderOfNextPanelAtEnd());
        this.setFinishedLabel(this, label, 9, 12, 1, 1);
        label = new WireWithArrow(null, true, 66, 66, false);
        this.setFinishedLabel(this, label, 4, 12, 1, 1);
        label = new WireWithArrow(null, true, 66, 66, this.globalLayerPath != null && this.globalLayerPath.isActiveBorderOfNextPanelAtEnd());
        this.setFinishedLabel(this, label, 8, 12, 1, 1);
        label = this.setEmptyCell(this, 5, 1, 3, 1);
        this.setSize(label, 200, 12);
        label = this.setLabel(this, this.LAYER_PATH_PANEL.getKnoten().holeAnzeigeName(), 5, 2, 3, 1, true);
        this.setSize(label, 412, 19);
        label.setHorizontalAlignment(0);
        if (this.LAYER_PATH_PANEL.isMainNode()) {
            label.setBackground(MAIN_NODE_NAME_BG_COLOR);
        } else {
            label.setBackground(NODE_NAME_BG_COLOR);
        }
        label = this.setEmptyCell(this, 5, 3, 3, 1);
        this.setSize(label, 200, 12);
        if (this.LAYER_PATH_PANEL.isSent()) {
            nodeInfoLeft = this.createNodeInfoByMac(this.LAYER_PATH_PANEL.getCorrInterfaceId());
            nodeInfoRight = this.createNodeInfoByMac(this.LAYER_PATH_PANEL.getInterfaceId());
        } else {
            nodeInfoLeft = this.createNodeInfoByMac(this.LAYER_PATH_PANEL.getInterfaceId());
            nodeInfoRight = this.createNodeInfoByMac(this.LAYER_PATH_PANEL.getCorrInterfaceId());
        }
        JEditorPane editorPane = this.setEditorPane(this, nodeInfoLeft, 5, 4, 1, 1, true);
        this.setSize(editorPane, 200, NODE_INFO_CELL_HEIGHT);
        label = this.setEmptyCell(this, 5, 5, 1, 1);
        if (this.LAYER_PATH_PANEL.isMainNode()) {
            editorPane.setBackground(MAIN_NODE_INFO_BG_COLOR);
        } else {
            editorPane.setBackground(NODE_INFO_BG_COLOR);
        }
        this.setSize(label, 200, 12);
        editorPane = this.setEditorPane(this, nodeInfoRight, 7, 4, 1, 1, true);
        this.setSize(editorPane, 200, NODE_INFO_CELL_HEIGHT);
        if (this.LAYER_PATH_PANEL.isMainNode()) {
            editorPane.setBackground(MAIN_NODE_INFO_BG_COLOR);
        } else {
            editorPane.setBackground(NODE_INFO_BG_COLOR);
        }
        label = this.setEmptyCell(this, 7, 5, 1, 1);
        this.setSize(label, 200, 12);
        this.createRectangularNestedMessages(5, false);
        this.createRectangularNestedMessages(7, true);
        label = new Arrow(null, true, 12, 66, this.LAYER_PATH_PANEL.isSent() && (this.globalLayerPath == null || !this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()));
        this.setFinishedLabel(this, label, 6, 10, 1, 1);
        label = this.setLabel(this, "", 6, 6, 1, 1, false);
        this.setSize(label, 12, 66);
        label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 4));
        label = this.setLabel(this, "", 6, 8, 1, 1, false);
        this.setSize(label, 12, 66);
        label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 3));
        label = this.setLabel(this, "", 6, 12, 1, 1, false);
        this.setSize(label, 12, 66);
        label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 1));
    }

    private void coloredLayerIndicators(int xCoord, int width, boolean includingLayer1) {
        JLabel label;
        this.c = new GridBagConstraints();
        for (int layerNumber = 4; layerNumber >= 2; --layerNumber) {
            label = this.setLabel(this, "", xCoord + 0, 5 + 2 * (4 - layerNumber) + 1, 1, 1, false);
            this.setSize(label, width, 66);
            label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", layerNumber));
        }
        if (includingLayer1) {
            label = this.setLabel(this, "", xCoord + 0, 12, 1, 1, false);
            this.setSize(label, width, 66);
            label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 1));
        }
    }

    private String createNodeInfoByMac(String interfaceId) {
        InternetKnoten node = (InternetKnoten)this.LAYER_PATH_PANEL.getKnoten();
        NetzwerkInterface ni = node.getNetzwerkInterfaceByMac(interfaceId);
        String[] nodeInfos = new String[]{"<b>" + messages.getString("schichten_lokaler_weg_msg6") + "</b> " + ni.getIp() + "<br />", "<b>" + messages.getString("schichten_lokaler_weg_msg7") + "</b> " + ni.getSubnetzMaske() + "<br />", "<b>" + messages.getString("schichten_lokaler_weg_msg8") + "</b> " + ni.getMac() + "<br />", "<b>" + messages.getString("schichten_lokaler_weg_msg9") + "</b> " + ni.getGateway() + "<br />", "<b>" + messages.getString("schichten_lokaler_weg_msg10") + "</b> " + ni.getDns()};
        Object nodeInfo = "";
        for (int i = 0; i < nodeInfos.length; ++i) {
            nodeInfo = (String)nodeInfo + nodeInfos[i];
        }
        return nodeInfo;
    }

    private void createRectangularNestedMessages(int xCoord, Boolean isSenderSideWhenForwarded) {
        int layerOfActiveBorder = Math.min(this.LAYER_PATH_PANEL.getMaxLayerInsideFrame(), this.LAYER_PATH_PANEL.getMaxLayerOfOperation());
        for (int layerNumber = 4; layerNumber >= 1; --layerNumber) {
            boolean arrowPointsDown;
            boolean activeBorder;
            if (!this.LAYER_PATH_PANEL.isForwarded()) {
                activeBorder = this.LAYER_PATH_PANEL.isSent() && (this.globalLayerPath == null || this.globalLayerPath != null && !this.globalLayerPath.isActiveBorderOfNextPanelAtEnd()) ? layerNumber == layerOfActiveBorder : false;
                arrowPointsDown = this.LAYER_PATH_PANEL.isSent();
            } else if (isSenderSideWhenForwarded.booleanValue()) {
                activeBorder = this.LAYER_PATH_PANEL.isSent() ? layerNumber == layerOfActiveBorder : false;
                arrowPointsDown = true;
            } else {
                activeBorder = false;
                arrowPointsDown = false;
            }
            JLabel label = new NestedMessagesVisualisation(layerNumber, 200, 3, activeBorder);
            this.setFinishedLabel(this, label, xCoord, 5 + 2 * (4 - layerNumber) + 1, 1, 1);
            int maxLayerOfOperation = ((InternetKnoten)this.LAYER_PATH_PANEL.getKnoten()).getMaxLayerOfOperation();
            if (layerNumber > Math.min(this.LAYER_PATH_PANEL.getMaxLayerInsideFrame(), maxLayerOfOperation) || layerNumber < 2) continue;
            label = new Arrow(arrowPointsDown, null, 200, 12, false);
            this.setFinishedLabel(this, label, xCoord, 6 + 2 * (4 - layerNumber) + 1, 1, 1);
        }
    }

    private void addSidePanel(JButton backOrForthButton, int xCoord) {
        this.setStandards(backOrForthButton, xCoord + 0, 4, 1, 1);
        this.add((Component)backOrForthButton, this.c);
        String[] layers = new String[]{messages.getString("rp_lauscher_msg11"), messages.getString("rp_lauscher_msg10"), messages.getString("rp_lauscher_msg9"), messages.getString("rp_lauscher_msg8")};
        for (int layerNumber = 4; layerNumber >= 1; --layerNumber) {
            JLabel label = this.setEmptyCell(this, xCoord + 0, 4 + 2 * (4 - layerNumber) + 1, 1, 1);
            this.setSize(label, 200, 12);
            label = this.setLabel(this, layers[4 - layerNumber], xCoord + 0, 5 + 2 * (4 - layerNumber) + 1, 1, 1, false);
            this.setSize(label, 200, 66);
            label.setHorizontalAlignment(0);
            label.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorFine", layerNumber));
            label.setBorder(BorderFactory.createEtchedBorder(1));
        }
    }

    private JLabel setLabel(JPanel container, String text, int x_pos, int y_pos, int width, int height, boolean needsBorder) {
        JLabel label = new JLabel(text);
        this.setStandards(label, x_pos, y_pos, width, height);
        label.setOpaque(true);
        if (needsBorder) {
            Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
            EmptyBorder marginBorder = new EmptyBorder(5, 5, 5, 5);
            label.setBorder(new CompoundBorder(lineBorder, marginBorder));
        }
        container.add((Component)label, this.c);
        return label;
    }

    private JEditorPane setEditorPane(JPanel container, String text, int x_pos, int y_pos, int width, int height, boolean needsBorder) {
        JEditorPane editorPane = new JEditorPane("text/html", text);
        this.setStandards(editorPane, x_pos, y_pos, width, height);
        editorPane.setOpaque(true);
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setFont(new Font("Dialog", 0, 12));
        if (needsBorder) {
            Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
            EmptyBorder marginBorder = new EmptyBorder(5, 5, 5, 5);
            editorPane.setBorder(new CompoundBorder(lineBorder, marginBorder));
        }
        container.add((Component)editorPane, this.c);
        return editorPane;
    }

    private void setFinishedLabel(JPanel container, JLabel label, int x_pos, int y_pos, int width, int height) {
        this.setStandards(label, x_pos, y_pos, width, height);
        label.setOpaque(false);
        container.add((Component)label, this.c);
    }

    private JLabel setEmptyCell(JPanel container, int x_pos, int y_pos, int width, int height) {
        JLabel label = new JLabel();
        this.setStandards(label, x_pos, y_pos, width, height);
        label.setOpaque(false);
        label.setBorder(BorderFactory.createEmptyBorder());
        container.add((Component)label, this.c);
        return label;
    }

    private void setStandards(Component component, int x_pos, int y_pos, int width, int height) {
        this.c.gridx = x_pos;
        this.c.gridy = y_pos;
        this.c.gridwidth = width;
        this.c.gridheight = height;
    }

    private void setSize(Component component, int width, int height) {
        Dimension dimensionOfComponent = new Dimension(width, height);
        component.setPreferredSize(dimensionOfComponent);
        component.setMinimumSize(dimensionOfComponent);
        component.setMaximumSize(dimensionOfComponent);
    }

    private void backAndForth() {
        this.FORTH_IN_TIME.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalLayerPathVisualisation.this.forthButtonPressLogic();
            }
        });
        this.BACK_IN_TIME.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalLayerPathVisualisation.this.backButtonPressLogic();
            }
        });
    }

    private void forthButtonPressLogic() {
        if (this.pointInTime < this.maxPointInTime) {
            ++this.pointInTime;
            this.updateButtonsIfForth();
            this.updateSenderSide();
            this.LAYER_PATH_PANEL.updateMessageDetailsDisplay(this.senderSideIsActive, this.senderSideWasActive);
            this.hideOrShowLayersIfForth();
            this.updateActiveBorder(true);
        } else if (this.globalLayerPath != null) {
            this.globalLayerPath.switchPanel(true);
        }
    }

    private void backButtonPressLogic() {
        if (this.pointInTime > this.minPointInTime) {
            --this.pointInTime;
            this.updateButtonsIfBack();
            this.updateSenderSide();
            this.LAYER_PATH_PANEL.updateMessageDetailsDisplay(this.senderSideIsActive, this.senderSideWasActive);
            this.hideOrShowLayersIfBack();
            this.updateActiveBorder(false);
        } else if (this.globalLayerPath != null) {
            this.globalLayerPath.switchPanel(false);
        }
    }

    private void updateButtonsIfForth() {
        this.BACK_IN_TIME.setEnabled(true);
        if (this.pointInTime == this.maxPointInTime) {
            if (this.globalLayerPath == null) {
                this.FORTH_IN_TIME.setEnabled(false);
            } else if (!this.LAYER_PATH_PANEL.isSent() && !this.LAYER_PATH_PANEL.isForwarded()) {
                this.FORTH_IN_TIME.setEnabled(false);
            }
        }
    }

    private void updateButtonsIfBack() {
        this.FORTH_IN_TIME.setEnabled(true);
        if (this.pointInTime == this.minPointInTime) {
            if (this.globalLayerPath == null) {
                this.BACK_IN_TIME.setEnabled(false);
            } else if (this.LAYER_PATH_PANEL.isSent() && !this.LAYER_PATH_PANEL.isForwarded()) {
                this.BACK_IN_TIME.setEnabled(false);
            }
        }
    }

    private void hideOrShowLayersIfForth() {
        if (!this.LAYER_PATH_PANEL.isForwarded()) {
            if (this.LAYER_PATH_PANEL.isSent() && this.pointInTime < this.maxPointInTime) {
                this.LAYER_PATH_PANEL.showNextLowerLayer();
            } else if (!this.LAYER_PATH_PANEL.isSent() && this.pointInTime > 1) {
                this.LAYER_PATH_PANEL.hideNextHigherLayer();
            }
        } else {
            switch (this.pointInTime) {
                case 2: {
                    this.LAYER_PATH_PANEL.hideNextHigherLayer();
                    break;
                }
                case 4: {
                    this.LAYER_PATH_PANEL.showNextLowerLayer();
                }
            }
        }
    }

    private void hideOrShowLayersIfBack() {
        if (!this.LAYER_PATH_PANEL.isForwarded()) {
            if (this.LAYER_PATH_PANEL.isSent() && this.pointInTime < this.maxPointInTime - 1) {
                this.LAYER_PATH_PANEL.hideNextHigherLayer();
            } else if (!this.LAYER_PATH_PANEL.isSent() && this.pointInTime > 0) {
                this.LAYER_PATH_PANEL.showNextLowerLayer();
            }
        } else {
            switch (this.pointInTime) {
                case 3: {
                    this.LAYER_PATH_PANEL.hideNextHigherLayer();
                    break;
                }
                case 1: {
                    this.LAYER_PATH_PANEL.showNextLowerLayer();
                }
            }
        }
    }

    private void updateSenderSide() {
        this.senderSideWasActive = this.senderSideIsActive;
        this.senderSideIsActive = this.pointInTime >= this.pointInTimeForSenderSide;
    }

    private void updateActiveBorder(boolean isForth) {
        List gridBagCoordsWithIncomingArrows;
        List gridBagCoordsWithBorders;
        int lastPointInTime;
        int n = lastPointInTime = isForth ? this.pointInTime - 1 : this.pointInTime + 1;
        if (!this.LAYER_PATH_PANEL.isForwarded()) {
            if (this.LAYER_PATH_PANEL.isSent()) {
                gridBagCoordsWithBorders = Collections.unmodifiableList(Arrays.asList({2, 6}, {2, 8}, {2, 10}, {2, 12}, {4, 12}));
                gridBagCoordsWithIncomingArrows = Collections.unmodifiableList(Arrays.asList({-1, -1}, {2, 7}, {2, 9}, {2, 11}, {3, 12}));
            } else {
                gridBagCoordsWithBorders = Collections.unmodifiableList(Arrays.asList({3, 12}, {5, 12}, {5, 10}, {5, 8}, {5, 6}));
                gridBagCoordsWithIncomingArrows = Collections.unmodifiableList(Arrays.asList({2, 12}, {4, 12}, {5, 11}, {5, 9}, {5, 7}));
            }
        } else {
            gridBagCoordsWithBorders = Collections.unmodifiableList(Arrays.asList({3, 12}, {5, 12}, {5, 10}, {7, 10}, {7, 12}, {9, 12}));
            gridBagCoordsWithIncomingArrows = Collections.unmodifiableList(Arrays.asList({2, 12}, {4, 12}, {5, 11}, {6, 10}, {7, 11}, {8, 12}));
        }
        for (Component component : this.getComponents()) {
            int gridx = this.GB_LAYOUT.getConstraints((Component)component).gridx;
            int gridy = this.GB_LAYOUT.getConstraints((Component)component).gridy;
            if (gridx == ((int[])gridBagCoordsWithBorders.get(this.pointInTime))[0] && gridy == ((int[])gridBagCoordsWithBorders.get(this.pointInTime))[1]) {
                ((NestedMessagesVisualisation)component).createAndSetBorder(true);
                continue;
            }
            if (gridx == ((int[])gridBagCoordsWithBorders.get(lastPointInTime))[0] && gridy == ((int[])gridBagCoordsWithBorders.get(lastPointInTime))[1]) {
                ((NestedMessagesVisualisation)component).createAndSetBorder(false);
                continue;
            }
            if (gridx == ((int[])gridBagCoordsWithIncomingArrows.get(this.pointInTime))[0] && gridy == ((int[])gridBagCoordsWithIncomingArrows.get(this.pointInTime))[1]) {
                ((Arrow)component).setColor(ACTIVE_ARROW_COLOR);
                ((Arrow)component).repaint();
                continue;
            }
            if (gridx != ((int[])gridBagCoordsWithIncomingArrows.get(lastPointInTime))[0] || gridy != ((int[])gridBagCoordsWithIncomingArrows.get(lastPointInTime))[1]) continue;
            ((Arrow)component).setColor(INACTIVE_ARROW_COLOR);
            ((Arrow)component).repaint();
        }
    }

    protected class WireWithArrow
    extends Arrow {
        private WireWithArrow(Boolean pointsDown, Boolean pointsRight, int rectangleWidth, int rectangleHeight, boolean activeArrow) {
            super(pointsDown, pointsRight, rectangleWidth, rectangleHeight, activeArrow);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setOpaque(true);
            this.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 1));
            super.paintComponent(g);
            g.setColor(Color.BLACK);
            g.setColor(MessageDetailsTable.getLayerColorVar("backgroundColor", 1));
            g.fillRect(0, this.rectangleHeight - 6, this.rectangleWidth, 6);
        }
    }

    private class NestedMessagesVisualisation
    extends JLabel {
        private int layerNumber;
        private boolean isSquare;
        private int widthWithBorder;
        private int heightWithBorder;
        private int widthInsideBorder;
        private int heightInsideBorder;

        private NestedMessagesVisualisation(int layerNumber, int widthWithBorder, int ratio, boolean activeBorder) {
            this.layerNumber = layerNumber;
            this.isSquare = ratio == 1;
            this.widthWithBorder = widthWithBorder;
            this.heightWithBorder = widthWithBorder / ratio;
            this.widthInsideBorder = widthWithBorder - 2;
            this.heightInsideBorder = this.heightWithBorder - 2;
            if (layerNumber <= LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerInsideFrame() && layerNumber <= LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerOfOperation()) {
                this.createAndSetBorder(activeBorder);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.widthWithBorder, this.heightWithBorder);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int xPos = 1;
            int yPos = 1;
            int width = this.widthInsideBorder;
            int height = this.heightInsideBorder;
            FilledRectangle rect = new FilledRectangle();
            rect.setX(xPos);
            rect.setY(yPos);
            if (this.layerNumber <= LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerInsideFrame() && this.layerNumber <= LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerOfOperation()) {
                rect.setFillColor(MessageDetailsTable.getLayerColorVar("backgroundColor", this.layerNumber));
                rect.paintFilledRectangle(g, width, height);
                if (this.layerNumber < LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerInsideFrame()) {
                    for (int i = this.layerNumber + 1; i <= LocalLayerPathVisualisation.this.LAYER_PATH_PANEL.getMaxLayerInsideFrame(); ++i) {
                        if (!this.isSquare) {
                            width = width - 20 - 5;
                            height -= 10;
                            xPos += 20;
                            yPos += 5;
                        } else {
                            width -= 10;
                            height -= 10;
                            xPos += 5;
                            yPos += 5;
                        }
                        rect.setX(xPos);
                        rect.setY(yPos);
                        rect.setFillColor(MessageDetailsTable.getLayerColorVar("backgroundColor", i));
                        rect.paintFilledRectangle(g, width, height);
                    }
                }
            } else {
                this.setOpaque(true);
                this.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", this.layerNumber));
            }
        }

        private void createAndSetBorder(boolean activeBorder) {
            AbstractBorder border;
            if (activeBorder) {
                MatteBorder outside = BorderFactory.createMatteBorder(1, 1, 1, 1, ACTIVE_BORDER_COLOR_OUTSIDE);
                MatteBorder inside = BorderFactory.createMatteBorder(2, 2, 2, 2, ACTIVE_BORDER_COLOR_INSIDE);
                border = BorderFactory.createCompoundBorder(outside, inside);
            } else {
                border = BorderFactory.createMatteBorder(1, 1, 1, 1, INACTIVE_BORDER_COLOR);
            }
            this.setBorder(border);
        }
    }

    protected class Arrow
    extends JLabel {
        protected int rectangleWidth;
        protected int rectangleHeight;
        private Boolean pointsDown;
        private Boolean pointsRight;
        private Color color;

        private Arrow(Boolean pointsDown, Boolean pointsRight, int rectangleWidth, int rectangleHeight, boolean activeArrow) {
            this.pointsDown = pointsDown;
            this.pointsRight = pointsRight;
            this.rectangleWidth = rectangleWidth;
            this.rectangleHeight = rectangleHeight;
            this.color = activeArrow ? ACTIVE_ARROW_COLOR : INACTIVE_ARROW_COLOR;
        }

        private void setColor(Color color) {
            this.color = color;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.rectangleWidth, this.rectangleHeight);
        }

        @Override
        public void paintComponent(Graphics g) {
            int headHeight;
            super.paintComponent(g);
            g.setColor(this.color);
            int xMiddle = this.rectangleWidth / 2;
            int yMiddle = this.rectangleHeight / 2;
            int overallLength = this.pointsDown != null && (this.pointsDown != false || this.pointsDown == false) ? this.rectangleHeight : this.rectangleWidth;
            int arrowRectangleWidth = 4;
            int halfOfHeadWidth = headHeight = 6;
            if (this.pointsDown != null && this.pointsDown.booleanValue()) {
                g.fillRect(xMiddle - arrowRectangleWidth / 2, 0, arrowRectangleWidth, overallLength - headHeight);
                int x1 = xMiddle - halfOfHeadWidth;
                int x2 = xMiddle + halfOfHeadWidth;
                int x3 = xMiddle;
                int y1 = overallLength - headHeight;
                int y2 = overallLength - headHeight;
                int y3 = overallLength;
                g.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
            } else if (this.pointsDown != null && !this.pointsDown.booleanValue()) {
                int correction = 1;
                g.fillRect(xMiddle - arrowRectangleWidth / 2, headHeight - 1, arrowRectangleWidth, overallLength - headHeight + correction);
                int x1 = xMiddle - halfOfHeadWidth;
                int x2 = xMiddle + halfOfHeadWidth;
                int x3 = xMiddle;
                int y1 = headHeight - correction;
                int y2 = headHeight - correction;
                int y3 = -1;
                g.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
            } else if (this.pointsRight != null && this.pointsRight.booleanValue()) {
                this.setOpaque(true);
                this.setBackground(MessageDetailsTable.getLayerColorVar("backgroundColorUltraFine", 2));
                g.fillRect(0, yMiddle - arrowRectangleWidth / 2, overallLength - headHeight, arrowRectangleWidth);
                int x1 = overallLength - headHeight;
                int x2 = overallLength;
                int x3 = overallLength - headHeight;
                int y1 = yMiddle - halfOfHeadWidth;
                int y2 = yMiddle;
                int y3 = yMiddle + halfOfHeadWidth;
                g.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
            } else if (this.pointsRight != null && !this.pointsRight.booleanValue()) {
                g.fillRect(headHeight, yMiddle - arrowRectangleWidth / 2, overallLength - headHeight, arrowRectangleWidth);
                int x1 = headHeight;
                int x2 = 0;
                int x3 = headHeight;
                int y1 = yMiddle - halfOfHeadWidth;
                int y2 = yMiddle;
                int y3 = yMiddle + halfOfHeadWidth;
                g.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
            }
        }
    }

    private class FilledRectangle {
        private int xPos;
        private int yPos;
        private Color fillColor;

        private FilledRectangle() {
        }

        public void setX(int xPos) {
            this.xPos = xPos;
        }

        public void setY(int yPos) {
            this.yPos = yPos;
        }

        public void setFillColor(Color fillColor) {
            this.fillColor = fillColor;
        }

        public void paintFilledRectangle(Graphics g, int width, int height) {
            g.setColor(this.fillColor);
            g.fillRect(this.xPos, this.yPos, width, height);
        }
    }
}

