/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware;

import filius.hardware.NetzwerkInterface;
import filius.hardware.Verbindung;
import filius.software.netzzugangsschicht.EthernetFrame;
import java.io.Serializable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Port
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(Port.class);
    private static final long serialVersionUID = 1L;
    private LinkedList<EthernetFrame> eingangsPuffer = new LinkedList();
    private LinkedList<EthernetFrame> ausgangsPuffer = new LinkedList();
    private Verbindung verbindung = null;
    private NetzwerkInterface nic = null;

    public Port(NetzwerkInterface nic) {
        this.nic = nic;
    }

    public Port() {
    }

    public NetzwerkInterface getNIC() {
        return this.nic;
    }

    public boolean isPortFrei() {
        return this.verbindung == null;
    }

    public boolean setVerbindung(Verbindung verbindung) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Port), setVerbindung(" + String.valueOf(verbindung) + ")");
        if (this.isPortFrei()) {
            this.verbindung = verbindung;
            return true;
        }
        return false;
    }

    public void entferneVerbindung() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Port), entferneVerbindung()");
        this.verbindung = null;
    }

    public LinkedList<EthernetFrame> holeAusgangsPuffer() {
        return this.ausgangsPuffer;
    }

    public LinkedList<EthernetFrame> holeEingangsPuffer() {
        return this.eingangsPuffer;
    }

    public void setzeEingangsPuffer(LinkedList<EthernetFrame> puffer) {
        this.eingangsPuffer = puffer;
    }

    public Verbindung getVerbindung() {
        return this.verbindung;
    }
}

