/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware.knoten;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.system.GatewayFirmware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gateway
extends InternetKnoten
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(Gateway.class);
    public static final String TYPE = messages.getString("hw_gateway_msg1");

    @Override
    public String holeHardwareTyp() {
        return TYPE;
    }

    public Gateway() {
        this.setMaxLayerOfOperation(2);
        this.setzeAnzahlAnschluesse(2);
        this.holeWANInterface().setIp("42.0.0.10");
        this.holeWANInterface().setSubnetzMaske("255.0.0.0");
        this.setSystemSoftware(new GatewayFirmware());
        this.getSystemSoftware().setKnoten(this);
        this.setName(TYPE);
        LOG.debug("New gateway created.");
    }

    public NetzwerkInterface holeWANInterface() {
        return this.getNetzwerkInterfaces().get(0);
    }

    public NetzwerkInterface holeLANInterface() {
        return this.getNetzwerkInterfaces().get(1);
    }

    public boolean checkWANPortUnconnected() {
        return this.holeWANInterface().getPort().isPortFrei();
    }

    public boolean checkLANPortUnconnected() {
        return this.holeLANInterface().getPort().isPortFrei();
    }
}

