/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware.knoten;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.software.system.Betriebssystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Host
extends InternetKnoten {
    private static Logger LOG = LoggerFactory.getLogger(Host.class);
    private boolean useIPAsName = false;
    private boolean useMACAsName = false;

    public boolean isUseIPAsName() {
        return this.useIPAsName;
    }

    public void setUseIPAsName(boolean useIPAsName) {
        this.useIPAsName = useIPAsName;
    }

    public boolean isUseMACAsName() {
        return this.useMACAsName;
    }

    public void setUseMACAsName(boolean useMACAsName) {
        this.useMACAsName = useMACAsName;
    }

    public Host() {
        this.setMaxLayerOfOperation(4);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Host), constr: Host()");
        this.setzeAnzahlAnschluesse(1);
        this.setSystemSoftware(new Betriebssystem());
        this.getSystemSoftware().setKnoten(this);
        LOG.debug("Host " + this.hashCode() + " has OS " + this.getSystemSoftware().hashCode());
    }

    @Override
    public String holeAnzeigeName() {
        if (this.useIPAsName && this.useMACAsName) {
            return this.getNetzwerkInterfaces().get(0).getIp() + " (" + this.getNetzwerkInterfaces().get(0).getMac() + ")";
        }
        if (this.useIPAsName) {
            return this.getNetzwerkInterfaces().get(0).getIp();
        }
        if (this.useMACAsName) {
            return this.getNetzwerkInterfaces().get(0).getMac();
        }
        return this.getName();
    }

    public void setIpAdresse(String ip) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Host), setIpAdresse(" + ip + ")");
        NetzwerkInterface nic = this.getNetzwerkInterfaces().get(0);
        nic.setIp(ip);
    }

    public String getMac() {
        NetzwerkInterface nic = this.getNetzwerkInterfaces().get(0);
        return nic.getMac();
    }
}

