/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware.knoten;

import filius.hardware.Hardware;
import filius.hardware.Port;
import filius.software.system.SystemSoftware;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Knoten
extends Hardware {
    private static Logger LOG = LoggerFactory.getLogger(Knoten.class);
    private String name;
    private SystemSoftware systemAnwendung;

    public abstract Port holeFreienPort();

    protected abstract boolean hasPort(Port var1);

    protected abstract List<Port> defineConnectedPorts();

    public boolean checkConnected(Knoten knoten) {
        boolean alreadyConnected = false;
        for (Port port : this.defineConnectedPorts()) {
            if (!knoten.hasPort(port)) continue;
            alreadyConnected = true;
            break;
        }
        return alreadyConnected;
    }

    public String holeAnzeigeName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.systemAnwendung != null) {
            LOG.debug("node with SystemSoftware (" + this.systemAnwendung.hashCode() + ") now has name '" + name + "'");
        }
    }

    public SystemSoftware getSystemSoftware() {
        return this.systemAnwendung;
    }

    public void setSystemSoftware(SystemSoftware systemAnwendung) {
        this.systemAnwendung = systemAnwendung;
    }
}

