/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware.knoten;

import filius.hardware.Port;
import filius.hardware.Verbindung;
import filius.hardware.knoten.Knoten;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LokalerKnoten
extends Knoten {
    private static Logger LOG = LoggerFactory.getLogger(LokalerKnoten.class);
    private LinkedList<Port> anschluesse = new LinkedList();

    @Override
    public Port holeFreienPort() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (LokalerKnoten), holeFreienPort()");
        for (Port anschluss : this.anschluesse) {
            if (!anschluss.isPortFrei()) continue;
            return anschluss;
        }
        return null;
    }

    @Override
    protected List<Port> defineConnectedPorts() {
        ArrayList<Port> connectedPorts = new ArrayList<Port>();
        for (Port port : this.anschluesse) {
            Verbindung connection = port.getVerbindung();
            if (connection == null) continue;
            try {
                connectedPorts.add(connection.findConnectedPort(port));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        return connectedPorts;
    }

    @Override
    protected boolean hasPort(Port portToLookup) {
        boolean result = false;
        for (Port port : this.anschluesse) {
            if (!port.equals(portToLookup)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Port getErstenAnschluss() {
        if (this.anschluesse != null && this.anschluesse.size() > 0) {
            return this.anschluesse.getFirst();
        }
        return null;
    }

    public LinkedList<Port> getAnschluesse() {
        return this.anschluesse;
    }

    public void setAnschluesse(LinkedList<Port> anschluesse) {
        this.anschluesse = anschluesse;
    }

    public int holeAnzahlAnschluesse() {
        return this.anschluesse.size();
    }

    public void setzeAnzahlAnschluesse(int anzahlAnschluesse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (LokalerKnoten), setzeAnzahlAnschluesse(" + anzahlAnschluesse + ")");
        LinkedList<Port> anschluesse = new LinkedList<Port>();
        for (int i = 0; i < anzahlAnschluesse; ++i) {
            anschluesse.add(new Port());
        }
        this.setAnschluesse(anschluesse);
    }
}

