/*
 * Decompiled with CFR 0.152.
 */
package filius.rahmenprogramm;

import filius.rahmenprogramm.Information;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class FiliusArgs {
    public String argsString = "";
    public String currWD = Information.initArbeitsbereichPfad;
    public String projectFile;
    public boolean log = false;
    public String newWD = null;
    public boolean nativeLookAndFeel = false;
    public boolean verbose = false;
    public boolean help = false;
    public int rtt = 1;
    public boolean lowResolution;
    private Options options = new Options();

    public FiliusArgs() {
        this.options.addOption("h", false, "Show usage info and exit");
        this.options.addOption("v", false, "Activate verbose log");
        this.options.addOption("w", "wd", true, "The working directory that is used during program execution");
        this.options.addOption("l", false, "Activate logging to log file");
        this.options.addOption("r", true, "Factor to adapt round-trip-time in Filius network: 1 (default) to 5");
        this.options.addOption("n", false, "Activate native look and feel graphical user interface");
        this.options.addOption("s", false, "Adapt Filius ui for small screen resolution (less than 1024x768)");
    }

    public void parseCommandLine(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args);
        if (cmd.hasOption("l")) {
            this.log = true;
        }
        if (cmd.hasOption("h")) {
            this.help = true;
        }
        if (cmd.hasOption("v")) {
            this.verbose = true;
        }
        if (cmd.hasOption("w")) {
            this.currWD = cmd.getOptionValue("w");
        }
        if (cmd.hasOption("n")) {
            this.nativeLookAndFeel = true;
        }
        if (cmd.hasOption("s")) {
            this.lowResolution = true;
        }
        if (cmd.hasOption("r")) {
            try {
                this.rtt = Integer.parseInt(cmd.getOptionValue("r"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (cmd.getArgs().length == 1) {
            try {
                File projectfile = new File(cmd.getArgs()[0]);
                if (projectfile.exists()) {
                    this.projectFile = projectfile.getAbsolutePath();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showUsageInformation() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("filius [OPTIONS] [FILE]", this.options);
    }
}

