/*
 * Decompiled with CFR 0.152.
 */
package filius.software;

import filius.rahmenprogramm.Information;
import filius.software.AnwendungObservable;
import filius.software.system.InternetKnotenBetriebssystem;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Anwendung
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger(Anwendung.class);
    private String anwendungsName;
    private LinkedList<Object[]> kommandos = new LinkedList();
    protected InternetKnotenBetriebssystem betriebssystem;
    private AnwendungObservable observable = new AnwendungObservable();
    protected boolean running = false;

    public Anwendung() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), constr: Anwendung()");
        try {
            for (Map<String, String> appInfo : Information.getInformation().ladeProgrammListe()) {
                if (!this.getClass().getCanonicalName().equals(appInfo.get("Klasse"))) continue;
                this.setzeAnwendungsName(appInfo.get("Anwendung").toString());
                break;
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
        }
    }

    public void hinzuBeobachter(Observer beobachter) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), hinzuBeobachter(" + String.valueOf(beobachter) + ")");
        this.observable.addObserver(beobachter);
    }

    public void benachrichtigeBeobachter(Object daten) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), benachrichtigeBeobachter(" + String.valueOf(daten) + ")");
        this.observable.notifyObservers(daten);
    }

    public void benachrichtigeBeobachter() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), benachrichtigeBeobachter()");
        this.observable.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), starten()");
        this.running = true;
        Object object = this.kommandos;
        synchronized (object) {
            this.kommandos.clear();
            this.benachrichtigeBeobachter();
        }
        if (this.getState().equals((Object)Thread.State.NEW)) {
            this.start();
        } else {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beenden() {
        Object object;
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), beenden()");
        this.running = false;
        if (this.kommandos != null) {
            object = this.kommandos;
            synchronized (object) {
                this.kommandos.clear();
                this.kommandos.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ausfuehren(String methode, Object[] args) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), ausfuehren(" + methode + "," + String.valueOf(args) + ")");
        Object[] aufruf = new Object[]{methode, args};
        LinkedList<Object[]> linkedList = this.kommandos;
        synchronized (linkedList) {
            this.kommandos.addLast(aufruf);
            this.kommandos.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Anwendung), run()");
        block13: while (true) {
            if (this.running) {
                Class[] argumentKlassen;
                LinkedList<Object[]> linkedList = this.kommandos;
                synchronized (linkedList) {
                    if (this.kommandos.size() < 1) {
                        try {
                            this.kommandos.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.kommandos.size() <= 0) continue;
                Object[] aufruf = this.kommandos.removeFirst();
                String methodenName = aufruf[0].toString();
                Object[] args = (Object[])aufruf[1];
                if (args != null) {
                    argumentKlassen = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null) continue;
                        argumentKlassen[i] = args[i].getClass();
                    }
                } else {
                    argumentKlassen = null;
                }
                Class<?> klasse = this.getClass();
                while (true) {
                    if (klasse == null) continue block13;
                    try {
                        Method method = klasse.getDeclaredMethod(methodenName, argumentKlassen);
                        method.setAccessible(true);
                        method.invoke((Object)this, args);
                        klasse = null;
                    }
                    catch (NoSuchMethodException e) {
                        klasse = klasse.getSuperclass();
                    }
                    catch (Exception e) {
                        LOG.debug("an unexpected error occurred during processing in application.", e);
                        klasse = null;
                    }
                }
            }
            Anwendung anwendung = this;
            synchronized (anwendung) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public String holeAnwendungsName() {
        return this.anwendungsName;
    }

    public void setzeAnwendungsName(String anwendungsName) {
        this.anwendungsName = anwendungsName;
    }

    public void setAnwendungsName(String anwendungsName) {
        this.setzeAnwendungsName(anwendungsName);
    }

    public void setSystemSoftware(InternetKnotenBetriebssystem bs) {
        this.betriebssystem = bs;
    }

    public InternetKnotenBetriebssystem getSystemSoftware() {
        return this.betriebssystem;
    }
}

