/*
 * Decompiled with CFR 0.152.
 */
package filius.software.clientserver;

import filius.exception.ServerSocketException;
import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.software.Anwendung;
import filius.software.clientserver.ServerMitarbeiter;
import filius.software.transportschicht.ServerSocket;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerAnwendung
extends Anwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(ServerAnwendung.class);
    protected int transportProtokoll;
    private List<NetzwerkInterface> boundNICs = Collections.emptyList();
    protected SocketSchnittstelle socket;
    protected int port = 55555;
    protected boolean aktiv = false;
    protected LinkedList<ServerMitarbeiter> mitarbeiter;

    public ServerAnwendung(int transportProtokoll) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + ", constr: ServerAnwendung(" + transportProtokoll + ")");
        this.transportProtokoll = transportProtokoll;
    }

    public void bindAddress(List<NetzwerkInterface> bind) {
        this.boundNICs = bind;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isAktiv() {
        return this.aktiv;
    }

    public synchronized void setAktiv(boolean flag) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ServerAnwendung), setAktiv(" + flag + ")");
        this.aktiv = flag;
        if (this.getState().equals((Object)Thread.State.WAITING)) {
            this.notifyAll();
        }
        if (!flag) {
            if (this.socket != null) {
                this.socket.schliessen();
            }
            if (null != this.mitarbeiter) {
                for (ServerMitarbeiter thread : this.mitarbeiter) {
                    thread.shutdown(true);
                }
                this.mitarbeiter.clear();
            }
            this.benachrichtigeBeobachter(messages.getString("sw_serveranwendung_msg1"));
        } else {
            this.benachrichtigeBeobachter(messages.getString("sw_serveranwendung_msg2"));
        }
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ServerAnwendung), starten()");
        super.starten();
        this.mitarbeiter = new LinkedList();
        this.ausfuehren("annehmenVerbindungen", null);
    }

    public boolean isStarted() {
        return this.socket != null;
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ServerAnwendung), beenden()");
        super.beenden();
        if (null != this.mitarbeiter) {
            for (ServerMitarbeiter thread : this.mitarbeiter) {
                thread.beenden();
            }
        }
        if (this.socket != null) {
            this.socket.beenden();
        }
        this.socket = null;
    }

    protected abstract void neuerMitarbeiter(Socket var1);

    public void entferneMitarbeiter(ServerMitarbeiter thread) {
        this.mitarbeiter.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annehmenVerbindungen() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (ServerAnwendung), annehmenVerbindungen()");
        while (this.running) {
            if (this.aktiv) {
                if (this.socket == null) {
                    this.socket = new ServerSocket(this.getSystemSoftware(), this.port, this.transportProtokoll, this.boundNICs);
                }
                if (this.socket == null) continue;
                try {
                    Socket transportSocket = ((ServerSocket)this.socket).oeffnen();
                    if (transportSocket == null || transportSocket.holeZielIPAdresse() == null) continue;
                    this.neuerMitarbeiter(transportSocket);
                    this.benachrichtigeBeobachter(messages.getString("sw_serveranwendung_msg4") + " " + transportSocket.holeZielIPAdresse() + ":" + transportSocket.holeZielPort() + " " + messages.getString("sw_serveranwendung_msg5"));
                }
                catch (ServerSocketException e) {
                    this.benachrichtigeBeobachter(messages.getString("sw_serveranwendung_msg6"));
                    this.setAktiv(false);
                    LOG.debug("tried to establish connection to client - but failed.", e);
                }
                catch (Exception e) {
                    this.benachrichtigeBeobachter(e.getMessage());
                    LOG.debug("", e);
                }
                continue;
            }
            if (this.socket != null) {
                this.socket.schliessen();
                this.benachrichtigeBeobachter(messages.getString("sw_serveranwendung_msg3"));
            }
            this.socket = null;
            ServerAnwendung serverAnwendung = this;
            synchronized (serverAnwendung) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

