/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dhcp;

import filius.exception.NoValidDhcpResponseException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.gui.GUIContainer;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.hardware.Verbindung;
import filius.hardware.knoten.Knoten;
import filius.software.clientserver.ClientAnwendung;
import filius.software.dhcp.DHCPMessage;
import filius.software.dhcp.DHCPMessageType;
import filius.software.dhcp.DHCPServer;
import filius.software.dhcp.IpConfig;
import filius.software.system.Betriebssystem;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SystemSoftware;
import filius.software.transportschicht.UDPSocket;
import filius.software.vermittlungsschicht.ARP;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPClient
extends ClientAnwendung {
    private static Logger LOG = LoggerFactory.getLogger(DHCPClient.class);
    private static final String IP_ADDRESS_CURRENT_NETWORK = "0.0.0.0";
    private static final int MAX_ERROR_COUNT = 10;
    private State zustand;

    @Override
    public void starten() {
        LOG.debug("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (DHCPClient), starten()");
        super.starten();
        this.ausfuehren("configure", null);
    }

    void waitUntilDhcpServerStarted() {
        boolean activeDHCPserversStarted = false;
        try {
            while (!activeDHCPserversStarted && this.running) {
                activeDHCPserversStarted = true;
                for (DHCPServer dhcpServer : this.getDHCPServers()) {
                    if (!dhcpServer.isAktiv() || dhcpServer.isStarted()) continue;
                    activeDHCPserversStarted = false;
                    LOG.debug("DHCP client is waiting for DHCP server on '" + dhcpServer.getSystemSoftware().getKnoten().holeAnzeigeName() + "'. Server has NOT yet started.");
                    break;
                }
                Thread.sleep(100L);
            }
            LOG.debug("DHCP client on '" + this.getSystemSoftware().getKnoten().holeAnzeigeName() + "' finished check for DHCP server.");
        }
        catch (InterruptedException e) {
            LOG.debug("", e);
        }
    }

    private List<DHCPServer> getDHCPServers() {
        ArrayList<DHCPServer> activeDHCPServers = new ArrayList<DHCPServer>();
        for (GUIKnotenItem knotenItem : GUIContainer.getGUIContainer().getKnotenItems()) {
            SystemSoftware syssoft = knotenItem.getKnoten().getSystemSoftware();
            if (!(syssoft instanceof Betriebssystem) || !((Betriebssystem)syssoft).getDHCPServer().isAktiv()) continue;
            activeDHCPServers.add(((Betriebssystem)syssoft).getDHCPServer());
        }
        return activeDHCPServers;
    }

    public void configure() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (DHCPClient), starteDatenaustausch()");
        int fehlerzaehler = 0;
        this.zustand = State.INIT;
        String oldIpAddress = this.resetIpConfig();
        this.updateOberserver();
        IpConfig config = null;
        UDPSocket udpSocket = null;
        InternetKnotenBetriebssystem operatingSystem = this.getSystemSoftware();
        block10: while (this.zustand != State.FINISH && fehlerzaehler < 10 && this.running) {
            try {
                switch (this.zustand) {
                    case INIT: {
                        this.waitUntilDhcpServerStarted();
                        udpSocket = this.initUdpSocket();
                        this.zustand = State.DISCOVER;
                        continue block10;
                    }
                    case DISCOVER: {
                        config = this.discover(udpSocket, operatingSystem.dhcpEnabledMACAddress(), Verbindung.holeRTT());
                        this.zustand = State.VALIDATE;
                        continue block10;
                    }
                    case VALIDATE: {
                        boolean validAddress = this.validateOfferedAddress(this.getSystemSoftware().holeARP(), config.getIpAddress());
                        this.zustand = validAddress ? State.REQUEST : State.DECLINE;
                        continue block10;
                    }
                    case DECLINE: {
                        this.decline(udpSocket, operatingSystem.dhcpEnabledMACAddress(), config, Verbindung.holeRTT());
                        this.zustand = State.DISCOVER;
                        continue block10;
                    }
                    case REQUEST: {
                        boolean acknowledged = this.request(udpSocket, operatingSystem.dhcpEnabledMACAddress(), config, Verbindung.holeRTT());
                        this.zustand = acknowledged ? State.ASSIGN_IP : State.DISCOVER;
                        continue block10;
                    }
                    case ASSIGN_IP: {
                        operatingSystem.setzeIPAdresse(config.getIpAddress());
                        operatingSystem.setzeNetzmaske(config.getSubnetMask());
                        operatingSystem.setStandardGateway(config.getRouter());
                        operatingSystem.setDNSServer(config.getDnsServer());
                    }
                }
                this.zustand = State.FINISH;
            }
            catch (NoValidDhcpResponseException | TimeOutException | VerbindungsException e) {
                ++fehlerzaehler;
            }
        }
        if (fehlerzaehler == 10 || !this.running) {
            LOG.error("kein DHCPACK erhalten");
            operatingSystem.setzeIPAdresse(oldIpAddress);
        }
        udpSocket.schliessen();
        this.updateOberserver();
    }

    private void updateOberserver() {
        InternetKnotenBetriebssystem operatingSystem = this.getSystemSoftware();
        Knoten node = operatingSystem.getKnoten();
        node.benachrichtigeBeobachter();
        operatingSystem.benachrichtigeBeobacher(node);
    }

    private String resetIpConfig() {
        InternetKnotenBetriebssystem operatingSystem = this.getSystemSoftware();
        String oldIpAddress = operatingSystem.primaryIPAdresse();
        operatingSystem.setzeIPAdresse(IP_ADDRESS_CURRENT_NETWORK);
        return oldIpAddress;
    }

    UDPSocket initUdpSocket() throws VerbindungsException {
        this.socket = new UDPSocket(this.getSystemSoftware(), "255.255.255.255", 67, 68);
        ((UDPSocket)this.socket).verbinden();
        return (UDPSocket)this.socket;
    }

    boolean request(UDPSocket socket, String clientMacAddress, IpConfig config, long socketTimeoutMillis) throws NoValidDhcpResponseException, TimeOutException {
        socket.sendeBroadcast(IP_ADDRESS_CURRENT_NETWORK, DHCPMessage.createRequestMessage(clientMacAddress, config.getIpAddress(), config.getDhcpServer()).toString());
        DHCPMessage result = this.receiveResponse(socket, socketTimeoutMillis, clientMacAddress, config.getDhcpServer(), DHCPMessageType.ACK, DHCPMessageType.NACK);
        return null != result && result.getType() == DHCPMessageType.ACK;
    }

    void decline(UDPSocket socket, String clientMacAddress, IpConfig config, long socketTimeoutMillis) throws NoValidDhcpResponseException {
        socket.sendeBroadcast(IP_ADDRESS_CURRENT_NETWORK, DHCPMessage.createDeclineMessage(clientMacAddress, config.getIpAddress(), config.getDhcpServer()).toString());
    }

    IpConfig discover(UDPSocket socket, String clientMacAddress, long socketTimeoutMillis) throws NoValidDhcpResponseException, TimeOutException {
        socket.sendeBroadcast(IP_ADDRESS_CURRENT_NETWORK, DHCPMessage.createDiscoverMessage(clientMacAddress).toString());
        DHCPMessage offer = this.receiveResponse(socket, socketTimeoutMillis, clientMacAddress, null, DHCPMessageType.OFFER);
        return new IpConfig(offer.getYiaddr(), offer.getRouter(), offer.getSubnetMask(), offer.getDnsServer(), offer.getServerIdentifier());
    }

    private DHCPMessage receiveResponse(UDPSocket socket, long socketTimeoutMillis, String clientMacAddress, String serverIdentifier, DHCPMessageType ... messageTypes) throws NoValidDhcpResponseException, TimeOutException {
        DHCPMessage responseMessage = null;
        long start = System.currentTimeMillis();
        long duration = 0L;
        do {
            boolean fromOtherServer;
            String response;
            if (null == (response = socket.empfangen(socketTimeoutMillis - duration))) {
                throw new TimeOutException("No response from DHCP server received.");
            }
            responseMessage = DHCPMessage.fromString(response);
            boolean invalidMessageType = !ArrayUtils.contains((Object[])messageTypes, (Object)responseMessage.getType());
            boolean forOtherClient = !clientMacAddress.equalsIgnoreCase(responseMessage.getChaddr());
            boolean bl = fromOtherServer = null != serverIdentifier && !serverIdentifier.equals(responseMessage.getServerIdentifier());
            if (invalidMessageType || forOtherClient || fromOtherServer) {
                responseMessage = null;
            }
            duration = System.currentTimeMillis() - start;
        } while (null == responseMessage && duration < socketTimeoutMillis);
        if (null == responseMessage) {
            throw new NoValidDhcpResponseException("No valid server response received");
        }
        return responseMessage;
    }

    boolean validateOfferedAddress(ARP arp, String offeredAddress) {
        String macAddress = arp.holeARPTabellenEintrag(offeredAddress, 1, false);
        return null == macAddress;
    }

    static enum State {
        ASSIGN_IP,
        FINISH,
        DISCOVER,
        REQUEST,
        VALIDATE,
        DECLINE,
        INIT;

    }
}

