/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.hardware.Verbindung;
import filius.software.dns.DNSNachricht;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.UDPSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSQueryAgent {
    private static final Logger LOG = LoggerFactory.getLogger(DNSQueryAgent.class);

    public DNSNachricht query(String typ, String domainname, String dnsServer, InternetKnotenBetriebssystem os) throws TimeOutException {
        DNSNachricht antwort = null;
        if (dnsServer != null && !dnsServer.equals("")) {
            try {
                DNSNachricht anfrage = new DNSNachricht(0);
                anfrage.hinzuQuery(domainname + " " + typ + " IN");
                UDPSocket socket = new UDPSocket(os, dnsServer, 53);
                socket.verbinden();
                socket.senden(anfrage.toString());
                String tmp = socket.empfangen(5 * Verbindung.holeRTT());
                socket.schliessen();
                if (tmp == null) {
                    LOG.debug("Timeout while waiting for DNS query response");
                    throw new TimeOutException();
                }
                antwort = new DNSNachricht(tmp);
            }
            catch (VerbindungsException e) {
                LOG.debug("Could not connect to DNS server", e);
            }
        }
        return antwort;
    }
}

