/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.software.clientserver.ServerMitarbeiter;
import filius.software.dns.DNSNachricht;
import filius.software.dns.DNSServer;
import filius.software.dns.Query;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.UDPSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSServerMitarbeiter
extends ServerMitarbeiter {
    private static Logger LOG = LoggerFactory.getLogger(DNSServerMitarbeiter.class);

    public DNSServerMitarbeiter(DNSServer server, Socket socket) {
        super(server, socket);
    }

    @Override
    protected void verarbeiteNachricht(String dateneinheit) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (DNSServerMitarbeiter), verarbeiteNachricht(" + dateneinheit + ")");
        DNSNachricht nachricht = new DNSNachricht(dateneinheit);
        DNSNachricht antwort = new DNSNachricht(1);
        antwort.setId(nachricht.getId());
        for (Query query : nachricht.holeQueries()) {
            DNSNachricht queryResponse = ((DNSServer)this.server).answer(query);
            antwort.hinzuAntwortResourceRecords(queryResponse.holeAntwortResourceRecords());
            antwort.hinzuAuthoritativeResourceRecords(queryResponse.holeAuthoritativeResourceRecords());
        }
        if (this.socket != null) {
            ((UDPSocket)this.socket).senden(antwort.toString());
            this.server.benachrichtigeBeobachter(messages.getString("sw_dnsservermitarbeiter_msg2") + "\n>>>>\n" + antwort.toString() + "<<<<");
        }
    }
}

