/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.software.clientserver.ServerMitarbeiter;
import filius.software.email.Email;
import filius.software.email.EmailKonto;
import filius.software.email.EmailServer;
import filius.software.email.POP3Server;
import filius.software.transportschicht.TCPSocket;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POP3Mitarbeiter
extends ServerMitarbeiter {
    private static Logger LOG = LoggerFactory.getLogger(POP3Mitarbeiter.class);
    private EmailServer emailServer;
    private String benutzername;
    private String password;
    private boolean benAuth = false;
    private boolean transactionState = false;
    private boolean authenticationState = true;
    private EmailKonto aktivesKonto;

    public POP3Mitarbeiter(TCPSocket socket, POP3Server pop3Server) {
        super(pop3Server, socket);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), constr: POP3Mitarbeiter(" + String.valueOf(socket) + "," + String.valueOf(pop3Server) + ")");
        this.socket = socket;
        this.emailServer = pop3Server.holeEmailServer();
        this.emailServer.benachrichtigeBeobachter("----");
        this.sendeAntwort("+OK POP3 server ready");
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), verarbeiteNachricht(" + nachricht + ")");
        this.emailServer.benachrichtigeBeobachter(this.socket.holeZielIPAdresse() + "< " + nachricht);
        String befehl = "";
        String[] incoming = new String[3];
        incoming = nachricht.split(" ");
        befehl = incoming[0];
        if (befehl.equalsIgnoreCase("USER")) {
            String antwort = "";
            if (!(this.isTransactionState() && this.isBenAuth() || !this.isAuthenticationState())) {
                antwort = this.user(incoming[1]);
                if (this.isBenAuth()) {
                    this.benutzername = incoming[1];
                }
            } else {
                antwort = "-ERR Please enter USER";
            }
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("PASS")) {
            String antwort = "";
            if (!this.isTransactionState() && this.isBenAuth()) {
                antwort = this.pass(incoming[1]);
                this.password = incoming[1];
                this.aktivesKonto = this.emailServer.sucheKonto(this.benutzername, this.password);
            } else {
                antwort = "-ERR Please enter PASS";
            }
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("STAT")) {
            String antwort = this.stat(this.aktivesKonto);
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("LIST")) {
            if (incoming.length < 1) {
                String antwort = this.list(Integer.parseInt(incoming[1]), this.aktivesKonto);
                this.sendeAntwort(antwort);
            } else {
                String antwort = this.list(this.aktivesKonto);
                this.sendeAntwort(antwort);
            }
        } else if (befehl.equalsIgnoreCase("RETR")) {
            String antwort = this.retr(Integer.parseInt(incoming[1]), this.aktivesKonto);
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("DELE")) {
            String antwort = this.dele(Integer.parseInt(incoming[1]), this.aktivesKonto);
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("RSET")) {
            String antwort = this.rset(this.aktivesKonto);
            this.sendeAntwort(antwort);
        } else if (befehl.equalsIgnoreCase("QUIT")) {
            String antwort = this.quit(this.aktivesKonto);
            try {
                this.sendeAntwort(antwort);
                this.schliesseSocket();
            }
            catch (Exception e) {
                this.schliesseSocket();
            }
        } else if (befehl.equalsIgnoreCase("NOOP")) {
            String antwort = this.noop();
            this.sendeAntwort(antwort);
        }
    }

    public void schliesseSocket() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), schliesseSocket()");
        if (this.socket != null) {
            this.socket.schliessen();
            this.socket = null;
            this.beenden();
        }
    }

    public String user(String benutzername) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), user(" + benutzername + ")");
        String ergebnis = "";
        if (this.sucheBenutzer(benutzername)) {
            this.setBenAuth(true);
            ergebnis = "+OK enter password";
        } else {
            ergebnis = "-ERR user or password wrong";
        }
        return ergebnis;
    }

    public String pass(String passwort) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), pass(" + passwort + ")");
        String ergebnis = "";
        try {
            if (this.pruefePasswort(passwort)) {
                if (this.isBenAuth()) {
                    this.setTransactionState(true);
                    ergebnis = "+OK Mailbox locked and ready";
                }
            } else {
                ergebnis = "-ERR user or password wrong";
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
            ergebnis = "-ERR user or password wrong";
        }
        return ergebnis;
    }

    public String stat(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), stat(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        Object daten = "";
        if (this.isTransactionState()) {
            try {
                int[] a = this.anzahlEmailsImPostfach(uebergebenesAktivesKonto);
                daten = "+OK " + a[1] + " " + a[0];
            }
            catch (Exception e) {
                daten = "-ERR please try again";
            }
        }
        return daten;
    }

    public String list(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), list(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        Object ergebnis = "";
        if (this.isTransactionState()) {
            try {
                ergebnis = this.stat(this.aktivesKonto) + "\n";
                String a = this.emailsAuflisten(uebergebenesAktivesKonto);
                String[] ergServer = a.split(" ");
                for (int i = 0; i < ergServer.length; i += 2) {
                    ergebnis = (String)ergebnis + ergServer[i] + " " + ergServer[i + 1] + "\n";
                }
            }
            catch (Exception e) {
                LOG.debug("", e);
                ergebnis = "-ERR no such message";
            }
        }
        return ergebnis;
    }

    public String list(int i, EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), list(" + i + "," + String.valueOf(uebergebenesAktivesKonto) + ")");
        Object ergebnis = "";
        if (this.isTransactionState()) {
            try {
                String a = this.emailsAuflisten(uebergebenesAktivesKonto);
                String[] ergServer = a.split(" ");
                int j = 0;
                while (j < ergServer.length) {
                    if (j == i) {
                        ergebnis = "+OK " + ergServer[i] + " " + ergServer[i + 1];
                    }
                    i += 2;
                }
            }
            catch (Exception e) {
                LOG.debug("", e);
                ergebnis = "-ERR no such message";
            }
        }
        return ergebnis;
    }

    public String retr(int i, EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), retr(" + i + "," + String.valueOf(uebergebenesAktivesKonto) + ")");
        Email abgerufeneEmail = this.emailsAbrufen(i, uebergebenesAktivesKonto);
        Object ergebnis = "";
        if (this.isTransactionState()) {
            try {
                if (abgerufeneEmail.getDelete() || !abgerufeneEmail.getNeu()) {
                    ergebnis = "-ERR no such message";
                } else {
                    ergebnis = "+OK message follows \n" + abgerufeneEmail.toString();
                    abgerufeneEmail.setNeu(false);
                }
            }
            catch (Exception e) {
                LOG.debug("", e);
                ergebnis = "-ERR no such message";
            }
        }
        return ergebnis;
    }

    public String dele(int i, EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), dele(" + i + "," + String.valueOf(uebergebenesAktivesKonto) + ")");
        String ergebnis = "";
        if (this.isTransactionState()) {
            try {
                if (this.emailsAlsGeloeschtMarkieren(i, uebergebenesAktivesKonto)) {
                    ergebnis = "+OK message marked for delete";
                }
            }
            catch (Exception e) {
                LOG.debug("", e);
                ergebnis = "-ERR no such message";
            }
        }
        return ergebnis;
    }

    public String rset(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), rset(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        String ergebnis = "";
        if (this.isTransactionState()) {
            try {
                ListIterator<Email> iter = uebergebenesAktivesKonto.getNachrichten().listIterator();
                while (iter.hasNext()) {
                    Email email = iter.next();
                    email.setDelete(false);
                }
                ergebnis = "+OK";
            }
            catch (Exception e) {
                LOG.debug("", e);
            }
        }
        return ergebnis;
    }

    public String quit(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), quit(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        String ergebnis = "";
        if (this.isTransactionState()) {
            try {
                for (int idx = uebergebenesAktivesKonto.getNachrichten().size() - 1; idx >= 0; --idx) {
                    if (!uebergebenesAktivesKonto.getNachrichten().get(idx).getDelete()) continue;
                    uebergebenesAktivesKonto.getNachrichten().remove(idx);
                }
                ergebnis = "+OK";
            }
            catch (Exception e) {
                LOG.debug("EXCEPTION (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), quit: ");
                LOG.debug("", e);
            }
        }
        this.benutzername = "";
        this.password = "";
        this.emailServer.benachrichtigeBeobachter();
        return ergebnis;
    }

    public String noop() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), noop()");
        String ergebnis = "";
        try {
            ergebnis = this.isTransactionState() ? "+OK" : "-ERR unknown command";
        }
        catch (Exception e) {
            ergebnis = "-ERR unknown command";
            LOG.debug("", e);
        }
        return ergebnis;
    }

    public boolean sucheBenutzer(String benutzernamen) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), sucheBenutzer(" + benutzernamen + ")");
        ListIterator<EmailKonto> iter = this.emailServer.getListeBenutzerkonten().listIterator();
        while (iter.hasNext()) {
            EmailKonto konto = iter.next();
            if (!konto.getBenutzername().equalsIgnoreCase(benutzernamen)) continue;
            return true;
        }
        return false;
    }

    public boolean pruefePasswort(String passwort) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), pruefePasswort(" + passwort + ")");
        boolean erfolg = false;
        EmailKonto nowKonto = this.emailServer.sucheKonto(this.benutzername);
        if (nowKonto != null && nowKonto.getPasswort().equals(passwort)) {
            erfolg = true;
        }
        return erfolg;
    }

    public boolean emailsAlsGeloeschtMarkieren(int i, EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), emailsAlsGeloeschtMarkieren(" + i + "," + String.valueOf(uebergebenesAktivesKonto) + ")");
        List<Email> emails = uebergebenesAktivesKonto.getNachrichten();
        try {
            if (i >= emails.size()) {
                return false;
            }
            emails.get(i).setDelete(true);
            this.emailServer.kontenSpeichern();
            return true;
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.emailServer.kontenSpeichern();
            return false;
        }
    }

    public Email emailsAbrufen(int i, EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), emailsAbrufen(" + i + "," + String.valueOf(uebergebenesAktivesKonto) + ")");
        List<Object> gespeicherteEmails = new LinkedList();
        Email abgerufeneEmail = new Email();
        try {
            gespeicherteEmails = uebergebenesAktivesKonto.getNachrichten();
            abgerufeneEmail = (Email)gespeicherteEmails.get(i);
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.emailServer.kontenSpeichern();
        }
        return abgerufeneEmail;
    }

    public String emailsAuflisten(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), emailsAuflisten(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        StringBuilder str = new StringBuilder();
        try {
            int index = 0;
            for (Email email : uebergebenesAktivesKonto.getNachrichten()) {
                if (email.getDelete()) continue;
                String emailgroesse = email.getText() + String.valueOf(email.getAbsender()) + email.getBetreff() + String.valueOf(email.getEmpfaenger()) + email.getDateReceived();
                str.append(index++);
                str.append(" ");
                str.append(emailgroesse.length());
                str.append(" ");
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.emailServer.kontenSpeichern();
        }
        return str.toString();
    }

    public int[] anzahlEmailsImPostfach(EmailKonto uebergebenesAktivesKonto) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), anzahlEmailsImPostfach(" + String.valueOf(uebergebenesAktivesKonto) + ")");
        Object str = "";
        int[] a = new int[2];
        int i = 0;
        a[0] = 0;
        a[1] = 0;
        try {
            for (Email email : uebergebenesAktivesKonto.getNachrichten()) {
                if (email.getDelete()) continue;
                str = (String)str + email.getText() + String.valueOf(email.getAbsender()) + email.getBetreff() + String.valueOf(email.getEmpfaenger()) + email.getDateReceived();
                ++i;
            }
            a[0] = ((String)str).length();
            a[1] = i;
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.emailServer.kontenSpeichern();
        }
        return a;
    }

    public void sendeAntwort(String daten) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (POP3Mitarbeiter), sendeAntwort(" + daten + ")");
        try {
            if (this.isTransactionState() || this.isBenAuth()) {
                this.emailServer.kontenSpeichern();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.emailServer.benachrichtigeBeobachter(this.socket.holeZielIPAdresse() + "> " + daten);
        this.sendeNachricht(daten);
    }

    public String holeBenutzername() {
        return this.benutzername;
    }

    public void setzeBenutzername(String benutzername) {
        this.benutzername = benutzername;
    }

    public String holePassword() {
        return this.password;
    }

    public void setzePassword(String password) {
        this.password = password;
    }

    public boolean isTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(boolean transactionState) {
        this.transactionState = transactionState;
    }

    public boolean isBenAuth() {
        return this.benAuth;
    }

    public void setBenAuth(boolean benAuth) {
        this.benAuth = benAuth;
    }

    public boolean isAuthenticationState() {
        return this.authenticationState;
    }

    public void setAuthenticationState(boolean authenticationState) {
        this.authenticationState = authenticationState;
    }

    public EmailServer getEmailServer() {
        return this.emailServer;
    }

    public void setEmailServer(EmailServer emailServer) {
        this.emailServer = emailServer;
    }
}

