/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.Anwendung;
import filius.software.clientserver.ClientAnwendung;
import filius.software.email.AddressEntry;
import filius.software.email.Email;
import filius.software.email.EmailAnwendung;
import filius.software.email.EmailServer;
import filius.software.transportschicht.TCPSocket;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPClient
extends ClientAnwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(SMTPClient.class);
    private Anwendung anwendung = null;

    public SMTPClient(Anwendung anwendung) {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), constr: SMTPClient(" + String.valueOf(anwendung) + ")");
        this.anwendung = anwendung;
        this.setSystemSoftware(anwendung.getSystemSoftware());
    }

    public void versendeEmail(String defaultServerIP, Email email, String absender, String rcpts) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), versendeEmail(" + defaultServerIP + "," + String.valueOf(email) + "," + absender + "," + rcpts + ")");
        String[] zuSendenAn = rcpts.split(",");
        ArrayList<String> recipientTo = new ArrayList<String>();
        for (String empfaengerAdresse : zuSendenAn) {
            if (empfaengerAdresse.trim().length() <= 0) continue;
            recipientTo.add(new AddressEntry(empfaengerAdresse.trim()).getMailAddress());
        }
        ArrayList<String> unknownRecipients = new ArrayList<String>();
        for (String empfaengerAdresse : recipientTo) {
            String serverAdresse;
            if (defaultServerIP == null) {
                serverAdresse = this.loeseURLauf(empfaengerAdresse);
                LOG.debug(String.valueOf(this.getClass()) + "\n\tServer Adresse bei Weiterleitung fuer Maildomain " + empfaengerAdresse + " ist: " + serverAdresse);
            } else {
                serverAdresse = defaultServerIP;
            }
            if (serverAdresse == null) {
                unknownRecipients.add(empfaengerAdresse);
                continue;
            }
            Object[] args = new Object[]{serverAdresse, new Integer(25)};
            this.ausfuehren("initialisiereSocket", args);
            args = new Object[]{email, absender, empfaengerAdresse};
            this.ausfuehren("versenden", args);
            this.ausfuehren("schliesseSocket", null);
        }
        if (!unknownRecipients.isEmpty() && this.anwendung instanceof EmailServer) {
            ((EmailServer)this.anwendung).sendUnknownReceiverResponse(email, absender, unknownRecipients);
        }
    }

    public void initialisiereSocket(String zielAdresse, Integer port) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), initialisiereSocket(" + zielAdresse + "," + port + ")");
        this.anwendung.benachrichtigeBeobachter("----");
        try {
            this.socket = new TCPSocket(this.getSystemSoftware(), zielAdresse, (int)port);
            this.socket.verbinden();
            if (this.socket.istVerbunden()) {
                this.anwendung.benachrichtigeBeobachter(messages.getString("sw_smtpclient_msg1") + " " + this.socket.holeZielIPAdresse() + ":" + this.socket.holeZielPort() + " " + messages.getString("sw_smtpclient_msg2"));
            }
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.socket = null;
            this.anwendung.benachrichtigeBeobachter(e);
        }
    }

    public void schliesseSocket() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schliesseSocket()");
        if (this.socket != null) {
            this.socket.schliessen();
            this.anwendung.benachrichtigeBeobachter(messages.getString("sw_smtpclient_msg1") + " " + this.socket.holeZielIPAdresse() + ":" + this.socket.holeZielPort() + " " + messages.getString("sw_smtpclient_msg3"));
            this.socket = null;
        }
    }

    private boolean schickeHelo() throws Exception {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeHelo()");
        String empfang = this.socket.empfangen();
        if (empfang.startsWith("220")) {
            this.socket.senden("HELO " + this.getSystemSoftware().primaryIPAdresse());
            empfang = this.socket.empfangen();
            if (empfang.startsWith("250")) {
                return true;
            }
            throw new Exception(empfang);
        }
        return false;
    }

    public boolean versenden(Email email, String absender, String rcpts) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), versenden(" + String.valueOf(email) + "," + absender + "," + rcpts + ")");
        boolean erfolg = true;
        if (this.socket == null) {
            return false;
        }
        try {
            erfolg = this.schickeHelo();
            if (erfolg) {
                erfolg = this.schickeMailFrom(absender);
            }
            if (erfolg) {
                erfolg = this.schickeRcptTo(rcpts);
            }
            if (erfolg) {
                erfolg = this.schickeDataBeginn();
            }
            if (erfolg) {
                erfolg = this.schickeData(email);
            }
            if (erfolg) {
                this.schickeQuit();
            }
            if (erfolg && this.anwendung instanceof EmailAnwendung) {
                ((EmailAnwendung)this.anwendung).addGesendeteNachricht(email);
            }
            this.anwendung.benachrichtigeBeobachter(messages.getString("sw_smtpclient_msg4") + " " + rcpts);
            this.anwendung.benachrichtigeBeobachter();
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.anwendung.benachrichtigeBeobachter(e);
            erfolg = false;
        }
        return erfolg;
    }

    public String loeseURLauf(String url) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), loeseURLauf(" + url + ")");
        String[] teileDerEmail = url.split("@");
        try {
            return this.getSystemSoftware().holeDNSClient().holeIPAdresseMailServer(teileDerEmail[1]);
        }
        catch (TimeOutException e) {
            LOG.debug("", e);
            return null;
        }
    }

    private boolean schickeMailFrom(String absender) throws Exception {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeMailFrom(" + absender + ")");
        AddressEntry senderAddress = new AddressEntry(absender);
        if (senderAddress.getMailAddress().length() == 0 || EingabenUeberpruefung.isGueltig(senderAddress.getMailAddress(), EingabenUeberpruefung.musterEmailAdresse)) {
            this.socket.senden("MAIL FROM: <" + senderAddress.getMailAddress() + ">");
            String empfangen = this.socket.empfangen();
            if (empfangen.substring(0, 3).equals("250")) {
                return true;
            }
            throw new Exception(empfangen);
        }
        return false;
    }

    private boolean schickeRcptTo(String rcpts) throws Exception {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeRcptTo(" + rcpts + ")");
        String[] empfaenger = rcpts.split(",");
        for (int i = 0; i < empfaenger.length; ++i) {
            if (EingabenUeberpruefung.isGueltig(empfaenger[i], EingabenUeberpruefung.musterEmailAdresse)) {
                this.socket.senden("RCPT TO:<" + empfaenger[i] + ">");
                String empfangen2 = this.socket.empfangen();
                if (empfangen2.substring(0, 3).equals("250") || empfangen2.substring(0, 3).equals("251")) continue;
                throw new Exception(empfangen2);
            }
            return false;
        }
        return true;
    }

    private boolean schickeDataBeginn() throws Exception {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeDataBeginn()");
        this.socket.senden("DATA");
        String empfangen3 = this.socket.empfangen();
        if (empfangen3.substring(0, 3).equals("354")) {
            return true;
        }
        throw new Exception(empfangen3);
    }

    private boolean schickeData(Email email) throws Exception {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeData(" + String.valueOf(email) + ")");
        if (email != null) {
            this.socket.senden(email.toString() + "\r\n.\r\n");
            String empfangen34 = this.socket.empfangen();
            if (empfangen34.startsWith("250")) {
                return true;
            }
            throw new Exception(empfangen34);
        }
        return false;
    }

    private boolean schickeQuit() throws VerbindungsException, TimeOutException {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPClient), schickeQuit()");
        this.socket.senden("QUIT");
        String empfangen = this.socket.empfangen();
        return empfangen.startsWith("221");
    }
}

