/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.software.clientserver.ServerMitarbeiter;
import filius.software.email.Email;
import filius.software.email.EmailKonto;
import filius.software.email.EmailServer;
import filius.software.email.SMTPServer;
import filius.software.transportschicht.TCPSocket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPMitarbeiter
extends ServerMitarbeiter {
    private static Logger LOG = LoggerFactory.getLogger(SMTPMitarbeiter.class);
    private static final int START = 0;
    private static final int ENVELOPE = 1;
    private static final int DATA = 2;
    private static final int END = 3;
    private EmailServer emailServer;
    private int zustand = 0;
    private List<String> rcptTo = new LinkedList<String>();
    private String mailFrom;
    private String quelltext = "";
    private Email email = null;
    private EmailKonto empfaengerKonto = new EmailKonto();

    public SMTPMitarbeiter(TCPSocket socket, SMTPServer server) {
        super(server, socket);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPMitarbeiter), constr: SMTPMitarbeiter(" + String.valueOf(socket) + "," + String.valueOf(server) + ")");
        this.socket = socket;
        this.emailServer = server.holeEmailServer();
        this.emailServer.benachrichtigeBeobachter("----");
        this.senden(messages.getString("sw_smtpmitarbeiter_msg1") + " " + this.emailServer.getMailDomain());
    }

    @Override
    protected void verarbeiteNachricht(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPMitarbeiter), verarbeiteNachricht(" + nachricht + ")");
        this.emailServer.benachrichtigeBeobachter(this.socket.holeZielIPAdresse() + "< " + nachricht);
        if (nachricht.trim().equalsIgnoreCase("QUIT")) {
            this.senden(messages.getString("sw_smtpmitarbeiter_msg2"));
            this.socket.schliessen();
        } else if (this.zustand == 0) {
            int pos = nachricht.indexOf(" ");
            String tmp = pos > 0 ? nachricht.substring(0, pos).trim() : nachricht.trim();
            if (tmp.equalsIgnoreCase("HELO") || tmp.equalsIgnoreCase("EHLO")) {
                tmp = pos > 0 ? nachricht.substring(pos, nachricht.length()).trim() : "";
                this.senden("250 Hello " + tmp);
                this.zustand = 1;
            } else if (tmp.equalsIgnoreCase("NOOP")) {
                this.senden(messages.getString("sw_smtpmitarbeiter_msg3"));
            }
        } else if (this.zustand == 1) {
            int pos = nachricht.indexOf(":");
            String tmp = pos > 0 ? nachricht.substring(0, pos).trim() : nachricht.trim();
            if (tmp.equalsIgnoreCase("MAIL FROM")) {
                pos = nachricht.indexOf("<");
                int pos2 = nachricht.indexOf(">");
                if (pos > 0 && pos2 > pos) {
                    this.mailFrom = nachricht.substring(pos + 1, pos2).trim();
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg4"));
                } else {
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg5"));
                }
            } else if (tmp.equalsIgnoreCase("RCPT TO")) {
                pos = nachricht.indexOf("<");
                int pos2 = nachricht.indexOf(">");
                if (pos > 0 && pos2 > pos) {
                    this.rcptTo.add(nachricht.substring(pos + 1, pos2).trim());
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg6"));
                } else {
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg7"));
                }
            } else if (tmp.equalsIgnoreCase("DATA")) {
                if (this.mailFrom != null && this.rcptTo.size() > 0) {
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg8"));
                    this.zustand = 2;
                } else {
                    this.senden(messages.getString("sw_smtpmitarbeiter_msg9"));
                }
            } else if (tmp.equalsIgnoreCase("NOOP")) {
                this.senden("250 OK");
            }
        } else if (this.zustand == 2) {
            String[] tokens = nachricht.split("\n");
            if (tokens.length > 0 && tokens[tokens.length - 1].trim().equals(".") || tokens.length > 1 && tokens[tokens.length - 2].trim().equals(".") && tokens[tokens.length - 2].trim().equals("")) {
                this.quelltext = this.quelltext + nachricht.substring(0, nachricht.lastIndexOf("."));
                this.email = new Email(this.quelltext);
                this.senden(messages.getString("sw_smtpmitarbeiter_msg10"));
                this.verarbeiteEmail();
                this.zustand = 3;
            } else {
                this.quelltext = this.quelltext + nachricht;
            }
        } else if (this.zustand == 3) {
            this.senden(messages.getString("sw_smtpmitarbeiter_msg11"));
            this.zustand = 1;
        }
    }

    private void verarbeiteEmail() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPMitarbeiter), verarbeiteEmail()");
        StringBuilder weitereEmpfaenger = new StringBuilder();
        ArrayList<String> unknownRecipients = new ArrayList<String>();
        for (String aktuellerEmpfaenger : this.rcptTo) {
            String[] temp = aktuellerEmpfaenger.split("@");
            String benutzer = temp[0];
            if (this.emailServer.pruefeAufSelbeDomain(aktuellerEmpfaenger)) {
                this.empfaengerKonto = this.emailServer.sucheKonto(benutzer);
                if (this.empfaengerKonto != null) {
                    this.empfaengerKonto.getNachrichten().add(new Email(this.email.toString()));
                    this.emailServer.benachrichtigeBeobachter(messages.getString("sw_smtpmitarbeiter_msg12") + " " + this.empfaengerKonto.getBenutzername() + " " + messages.getString("sw_smtpmitarbeiter_msg13"));
                    continue;
                }
                unknownRecipients.add(aktuellerEmpfaenger);
                continue;
            }
            weitereEmpfaenger.append(aktuellerEmpfaenger);
            weitereEmpfaenger.append(",");
        }
        this.emailServer.kontenSpeichern();
        if (weitereEmpfaenger.length() > 0) {
            this.emailServer.emailWeiterleiten(new Email(this.email.toString()), this.mailFrom, weitereEmpfaenger.toString());
        }
        if (!unknownRecipients.isEmpty()) {
            this.emailServer.sendUnknownReceiverResponse(this.email, this.mailFrom, unknownRecipients);
        }
    }

    private void senden(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (SMTPMitarbeiter), senden(" + nachricht + ")");
        try {
            this.socket.senden(nachricht);
            this.emailServer.benachrichtigeBeobachter(this.socket.holeZielIPAdresse() + "> " + nachricht);
        }
        catch (Exception e) {
            LOG.debug("", e);
            this.emailServer.benachrichtigeBeobachter(messages.getString("sw_smtpmitarbeiter_msg14") + " " + this.socket.holeZielIPAdresse());
        }
    }
}

