/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.I18n;
import filius.software.Anwendung;
import filius.software.firewall.FirewallRule;
import filius.software.firewall.FirewallThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.TcpSegment;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Firewall
extends Anwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(Firewall.class);
    private Vector<FirewallRule> ruleset = new Vector();
    private short defaultPolicy = 0;
    private boolean activated = true;
    private boolean dropICMP = false;
    private boolean filterSYNSegmentsOnly = true;
    private boolean filterUdp = true;
    private LinkedList<FirewallThread> firewallThreads = new LinkedList();

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Firewall), starten()");
        super.starten();
        this.initFirewallThreads();
    }

    protected void initFirewallThreads() {
        for (NetzwerkInterface nic : this.getAllNetworkInterfaces()) {
            FirewallThread thread = new FirewallThread(this, nic, this.betriebssystem);
            this.addAndStartThread(thread);
        }
    }

    protected void addAndStartThread(FirewallThread thread) {
        thread.starten();
        this.firewallThreads.add(thread);
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Firewall), beenden()");
        super.beenden();
        this.beendeFirewallThread(null);
    }

    private void beendeFirewallThread(NetzwerkInterface nic) {
        for (FirewallThread thread : this.firewallThreads) {
            if (nic == null) {
                thread.beenden();
                continue;
            }
            if (nic != thread.getNetzwerkInterface()) continue;
            thread.beenden();
            break;
        }
    }

    public boolean acceptIPPacket(IpPaket ipPacket) {
        boolean accept = true;
        if (this.isActivated()) {
            if (ipPacket.getProtocol() == 1) {
                accept = this.checkAcceptIcmp(ipPacket);
            } else if (ipPacket.getProtocol() == 6) {
                accept = this.checkAcceptTCP(ipPacket);
            } else if (ipPacket.getProtocol() == 17) {
                accept = this.checkAcceptUDP(ipPacket);
            } else {
                this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg9") + " " + (this.defaultPolicy == 1 ? messages.getString("jfirewalldialog_msg33") : messages.getString("jfirewalldialog_msg34")));
                accept = this.defaultPolicy == 1;
            }
        }
        return accept;
    }

    public boolean moveUp(int idx) {
        if (idx <= this.ruleset.size() && idx > 1) {
            FirewallRule currRule = this.ruleset.get(idx - 1);
            this.ruleset.remove(idx - 1);
            this.ruleset.insertElementAt(currRule, idx - 2);
            return true;
        }
        return false;
    }

    boolean checkAcceptIcmp(IpPaket packet) {
        boolean accept;
        boolean bl = accept = !(packet instanceof IcmpPaket) || !this.dropICMP;
        if (!accept) {
            this.benachrichtigeBeobachter(messages.getString("firewallthread_msg1") + " " + packet.getSender() + " -> " + packet.getEmpfaenger() + " (code: " + ((IcmpPaket)packet).getIcmpCode() + ", type: " + ((IcmpPaket)packet).getIcmpType() + ")");
        }
        return accept;
    }

    boolean checkAcceptTCP(IpPaket packet) {
        boolean accept = true;
        if (packet.getProtocol() == 6 && this.isSegmentApplicable(packet)) {
            boolean foundRule = false;
            Segment segment = packet.getSegment();
            for (int i = 0; i < this.ruleset.size() && !foundRule; ++i) {
                boolean ruleToBeApplied;
                FirewallRule firewallRule = this.ruleset.get(i);
                boolean bl = ruleToBeApplied = this.isProtocolApplicable(packet, firewallRule) && this.isEndpointsApplicable(packet.getSender(), packet.getEmpfaenger(), segment.getZielPort(), firewallRule);
                if (!ruleToBeApplied) continue;
                this.notifyRuleApplication(i, firewallRule);
                accept = firewallRule.action == 1;
                foundRule = true;
            }
            if (!foundRule) {
                accept = this.defaultPolicy == 1;
            }
        }
        return accept;
    }

    private boolean isEndpointsApplicable(String endpoint1IPAddress, String endpoint2IPAddress, int endpoint2Port, FirewallRule firewallRule) {
        boolean ruleToBeApplied = this.isSourceAddressApplicable(endpoint1IPAddress, firewallRule);
        ruleToBeApplied = ruleToBeApplied && this.isDestAddressApplicable(endpoint2IPAddress, firewallRule);
        ruleToBeApplied = ruleToBeApplied && this.isPortApplicable(endpoint2Port, firewallRule);
        return ruleToBeApplied;
    }

    private void notifyRuleApplication(int i, FirewallRule firewallRule) {
        this.benachrichtigeBeobachter(messages.getString("sw_firewall_msg8") + " #" + (i + 1) + " (" + firewallRule.toString(this.getAllNetworkInterfaces()) + ")  -> " + (firewallRule.action == 1 ? messages.getString("jfirewalldialog_msg33") : messages.getString("jfirewalldialog_msg34")));
    }

    private boolean isSegmentApplicable(IpPaket packet) {
        boolean isApplicable = false;
        if (packet.getProtocol() == 6) {
            TcpSegment segment = (TcpSegment)packet.getSegment();
            isApplicable = !this.filterSYNSegmentsOnly || segment.isSyn() && !segment.isAck();
        } else if (packet.getProtocol() == 17) {
            isApplicable = this.filterUdp;
        }
        return isApplicable;
    }

    boolean checkAcceptUDP(IpPaket packet) {
        boolean accept = true;
        if (packet.getProtocol() == 17 && this.isSegmentApplicable(packet)) {
            boolean foundRule = false;
            Segment segment = packet.getSegment();
            for (int i = 0; i < this.ruleset.size() && !foundRule; ++i) {
                boolean ruleToBeApplied;
                FirewallRule firewallRule = this.ruleset.get(i);
                boolean applicableOnRequest = this.isEndpointsApplicable(packet.getSender(), packet.getEmpfaenger(), segment.getZielPort(), firewallRule);
                boolean applicableOnResponse = -1 != firewallRule.port && this.isEndpointsApplicable(packet.getEmpfaenger(), packet.getSender(), segment.getQuellPort(), firewallRule);
                boolean bl = ruleToBeApplied = this.isProtocolApplicable(packet, firewallRule) && (applicableOnRequest || applicableOnResponse);
                if (!ruleToBeApplied) continue;
                this.notifyRuleApplication(i, firewallRule);
                accept = firewallRule.action == 1;
                foundRule = true;
            }
            if (!foundRule) {
                accept = this.defaultPolicy == 1;
            }
        }
        return accept;
    }

    private boolean isPortApplicable(int port, FirewallRule firewallRule) {
        return firewallRule.port == -1 || port == firewallRule.port;
    }

    private boolean isProtocolApplicable(IpPaket packet, FirewallRule firewallRule) {
        return firewallRule.protocol == -1 || packet.getProtocol() == firewallRule.protocol;
    }

    private boolean isDestAddressApplicable(String ipAddress, FirewallRule firewallRule) {
        return firewallRule.destIP.isEmpty() || VermittlungsProtokoll.gleichesRechnernetz(ipAddress, firewallRule.destIP, firewallRule.destMask);
    }

    private boolean isSourceAddressApplicable(String ipAddress, FirewallRule firewallRule) {
        boolean ruleToBeApplied = false;
        if (firewallRule.srcIP.isEmpty()) {
            ruleToBeApplied = true;
        } else if (firewallRule.srcIP.equals(FirewallRule.SAME_NETWORK)) {
            for (NetzwerkInterface iface : ((InternetKnoten)this.getSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
                if (!VermittlungsProtokoll.gleichesRechnernetz(ipAddress, iface.getIp(), iface.getSubnetzMaske())) continue;
                ruleToBeApplied = true;
                break;
            }
        } else {
            ruleToBeApplied = VermittlungsProtokoll.gleichesRechnernetz(ipAddress, firewallRule.srcIP, firewallRule.srcMask);
        }
        return ruleToBeApplied;
    }

    public boolean moveDown(int idx) {
        if (idx >= 0 && idx < this.ruleset.size()) {
            FirewallRule currRule = this.ruleset.get(idx - 1);
            this.ruleset.remove(idx - 1);
            this.ruleset.insertElementAt(currRule, idx);
            return true;
        }
        return false;
    }

    public void addRule() {
        this.ruleset.add(new FirewallRule());
    }

    public void addRule(FirewallRule rule) {
        this.ruleset.add(rule);
    }

    public boolean updateRule(int idx, FirewallRule rule) {
        if (idx >= 0 && idx < this.ruleset.size()) {
            this.ruleset.set(idx, rule);
        }
        return true;
    }

    public void deleteRule(int idx) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (Firewall), entferneRegel(" + idx + ")");
        if (idx >= 0 && idx < this.ruleset.size()) {
            this.ruleset.remove(idx);
        }
    }

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem bs) {
        super.setSystemSoftware(bs);
    }

    public Vector<FirewallRule> getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Vector<FirewallRule> rules) {
        this.ruleset = rules;
    }

    public void setFilterUdp(boolean filterUdp) {
        this.filterUdp = filterUdp;
    }

    public boolean getFilterUdp() {
        return this.filterUdp;
    }

    protected List<NetzwerkInterface> getAllNetworkInterfaces() {
        InternetKnoten host = (InternetKnoten)this.getSystemSoftware().getKnoten();
        return host.getNetzwerkInterfaces();
    }

    public void setDefaultPolicy(short defPol) {
        this.defaultPolicy = defPol;
    }

    public short getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDropICMP(boolean selState) {
        this.dropICMP = selState;
    }

    public boolean getDropICMP() {
        return this.dropICMP;
    }

    @Deprecated
    public void setAllowRelatedPackets(boolean selState) {
        this.filterSYNSegmentsOnly = selState;
    }

    public void setFilterSYNSegmentsOnly(boolean selState) {
        this.filterSYNSegmentsOnly = selState;
    }

    public boolean getFilterSYNSegmentsOnly() {
        return this.filterSYNSegmentsOnly;
    }

    public void setActivated(boolean selState) {
        this.activated = selState;
    }

    public boolean isActivated() {
        return this.activated;
    }
}

