/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.ProtokollThread;
import filius.software.firewall.Firewall;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallThread
extends ProtokollThread<EthernetFrame>
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(FirewallThread.class);
    private LinkedList<EthernetFrame> ausgangsPuffer;
    protected SystemSoftware systemSoftware;
    private Firewall firewall;
    private NetzwerkInterface netzwerkInterface = null;

    public NetzwerkInterface getNetzwerkInterface() {
        return this.netzwerkInterface;
    }

    public FirewallThread(Firewall firewall, NetzwerkInterface nic, SystemSoftware systemSoftware) {
        super(new LinkedList());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FirewallThread), constr: FirewallThread(" + String.valueOf(firewall) + ")");
        this.firewall = firewall;
        this.netzwerkInterface = nic;
        this.systemSoftware = systemSoftware;
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FirewallThread), starten()");
        super.starten();
        this.ausgangsPuffer = this.netzwerkInterface.getPort().holeEingangsPuffer();
        LinkedList<EthernetFrame> eingangsPuffer = this.holeEingangsPuffer();
        this.netzwerkInterface.getPort().setzeEingangsPuffer(eingangsPuffer);
    }

    @Override
    public void beenden() {
        super.beenden();
        this.netzwerkInterface.getPort().setzeEingangsPuffer(this.ausgangsPuffer);
    }

    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame frame) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FirewallThread), verarbeiteDatenEinheit(" + frame.toString() + ")");
        Lauscher.getLauscher().addDatenEinheit(this.netzwerkInterface, this.systemSoftware, frame);
        if (!this.checkDiscardByFirewall(frame)) {
            this.forwardFrame(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardFrame(EthernetFrame frame) {
        LinkedList<EthernetFrame> linkedList = this.ausgangsPuffer;
        synchronized (linkedList) {
            this.ausgangsPuffer.add(frame);
            this.ausgangsPuffer.notify();
        }
    }

    protected boolean checkDiscardByFirewall(EthernetFrame frame) {
        return frame.getDaten() != null && frame.getDaten() instanceof IpPaket && !this.firewall.acceptIPPacket((IpPaket)frame.getDaten());
    }
}

