/*
 * Decompiled with CFR 0.152.
 */
package filius.software.lokal;

import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.Anwendung;
import filius.software.system.Datei;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExplorer
extends Anwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(FileExplorer.class);
    private HashMap<String, String> fileTypeMap;

    public FileExplorer() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), constr: FileExplorer()");
        this.initFileTypeMap();
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), beenden()");
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), starten()");
    }

    public String addFile(String pfadname, String dateiname, DefaultMutableTreeNode ordner, String neuerName) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), addFile(" + pfadname + "," + dateiname + "," + String.valueOf(ordner) + "," + neuerName + ")");
        String ergebnis = messages.getString("sw_fileexplorer_msg1");
        File file = new File(pfadname + dateiname);
        if (!file.exists() || file.length() > 150000L) {
            return ergebnis + "\n" + messages.getString("sw_fileexplorer_msg3");
        }
        if (ordner.getUserObject().getClass().equals(Datei.class)) {
            LOG.debug("ERROR (" + this.hashCode() + "): Es k\u00f6nnen keine Dateien in Dateien angeleget werden!");
        } else {
            Datei tempDatei;
            String dateityp;
            if (neuerName.equals("")) {
                neuerName = "noName";
            }
            if ((dateityp = this.getFileType(dateiname)) != null && dateityp.equals("text")) {
                Object txtInhalt = "";
                try {
                    String str;
                    BufferedReader in = new BufferedReader(new FileReader(pfadname + dateiname));
                    while ((str = in.readLine()) != null) {
                        txtInhalt = (String)txtInhalt + str + "\r\n";
                    }
                    in.close();
                    ergebnis = messages.getString("sw_fileexplorer_msg2");
                }
                catch (IOException e) {
                    LOG.debug("", e);
                }
                tempDatei = new Datei(neuerName, dateityp, (String)txtInhalt);
            } else {
                tempDatei = new Datei(neuerName, dateityp, Base64.encodeFromFile(pfadname + dateiname));
                tempDatei.setSize(file.length());
                ergebnis = messages.getString("sw_fileexplorer_msg2");
            }
            this.getSystemSoftware().getDateisystem().speicherDatei(ordner, tempDatei);
        }
        return ergebnis;
    }

    public String getFileType(String dateiname) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), getFileType(" + dateiname + ")");
        String tmpType = "";
        dateiname = dateiname.toLowerCase();
        StringTokenizer st = new StringTokenizer(dateiname, ".");
        int counting = st.countTokens();
        if (counting > 1) {
            for (int i = 1; i < counting; ++i) {
                st.nextToken();
            }
            String a = st.nextToken();
            tmpType = this.fileTypeMap.get(a);
        } else {
            tmpType = "text";
        }
        return tmpType;
    }

    public void initFileTypeMap() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileExplorer), getFileTypeMap()");
        this.fileTypeMap = new HashMap();
        try {
            String line;
            RandomAccessFile configFile = new RandomAccessFile(ResourceUtil.getResourcePath("config/filetypes.txt"), "r");
            while ((line = configFile.readLine()) != null) {
                StringTokenizer stx = new StringTokenizer(line, ";");
                String tmpType = stx.nextToken();
                StringTokenizer sty = new StringTokenizer(stx.nextToken(), ",");
                while (sty.hasMoreElements()) {
                    this.fileTypeMap.put(sty.nextToken(), tmpType);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("", e);
        }
        catch (IOException e) {
            LOG.debug("", e);
        }
    }
}

