/*
 * Decompiled with CFR 0.152.
 */
package filius.software.lokal;

import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.I18n;
import filius.software.Anwendung;
import filius.software.system.Datei;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImporter
extends Anwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(FileImporter.class);
    private HashMap<String, String> fileTypeMap;

    public FileImporter() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), constr: FileImporter()");
        this.getFileTypeMap();
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), starten()");
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), beenden()");
    }

    public String addFile(String pfadname, String dateiname, DefaultMutableTreeNode ordner, String neuerName) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), addFile(" + pfadname + "," + dateiname + "," + String.valueOf(ordner) + "," + neuerName + ")");
        Object ergebnis = messages.getString("sw_fileimporter_msg1");
        try {
            if (!ordner.getUserObject().getClass().equals(Datei.class)) {
                if (dateiname.equals("")) {
                    String dateityp = this.getFileType(dateiname);
                    Datei tempDatei = new Datei("noName", this.getFileType(dateiname), Base64.encodeFromFile(pfadname + dateiname));
                    if (dateityp.equals("text")) {
                        tempDatei.setDateiInhalt(Base64.decodeToObject(tempDatei.getDateiInhalt()).toString());
                    }
                    this.getSystemSoftware().getDateisystem().speicherDatei(ordner, tempDatei);
                } else {
                    String dateityp = this.getFileType(dateiname);
                    Datei tempDatei = new Datei(dateiname, dateityp, Base64.encodeFromFile(pfadname + dateiname));
                    if (dateityp.equals("text")) {
                        tempDatei.setDateiInhalt(Base64.decodeToObject(tempDatei.getDateiInhalt()).toString());
                    }
                    this.getSystemSoftware().getDateisystem().speicherDatei(ordner, tempDatei);
                }
                ergebnis = messages.getString("sw_fileimporter_msg2") + "\n\t" + pfadname + dateiname;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ergebnis;
    }

    public String getFileType(String dateiname) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), getFileType(" + dateiname + ")");
        String tmpType = "";
        dateiname = dateiname.toLowerCase();
        StringTokenizer st = new StringTokenizer(dateiname, ".");
        int counting = st.countTokens();
        if (counting > 1) {
            for (int i = 1; i < counting; ++i) {
                st.nextToken();
            }
            String a = st.nextToken();
            tmpType = this.fileTypeMap.get(a);
        } else {
            tmpType = "text";
        }
        return tmpType;
    }

    public void getFileTypeMap() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + String.valueOf(this.getClass()) + " (FileImporter), getFileTypeMap()");
        this.fileTypeMap = new HashMap();
        try {
            String line;
            RandomAccessFile configFile = new RandomAccessFile("config/filetypes.txt", "r");
            while ((line = configFile.readLine()) != null) {
                StringTokenizer stx = new StringTokenizer(line, ";");
                String tmpType = stx.nextToken();
                StringTokenizer sty = new StringTokenizer(stx.nextToken(), ",");
                while (sty.hasMoreElements()) {
                    this.fileTypeMap.put(sty.nextToken(), tmpType);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("", e);
        }
        catch (IOException e) {
            LOG.debug("", e);
        }
    }
}

