/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.hardware.knoten.Gateway;
import filius.rahmenprogramm.I18n;
import filius.software.firewall.Firewall;
import filius.software.nat.InetAddress;
import filius.software.nat.NatGatewayLANThread;
import filius.software.nat.NatGatewayWANThread;
import filius.software.nat.NatType;
import filius.software.nat.NetworkAddressTranslationTable;
import filius.software.system.GatewayFirmware;
import filius.software.vermittlungsschicht.IpPaket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatGateway
extends Firewall
implements I18n {
    static final int PSEUDO_PORT_ICMP = 0;
    private static Logger LOG = LoggerFactory.getLogger(NatGateway.class);
    private NetworkAddressTranslationTable natTable = new NetworkAddressTranslationTable();

    @Override
    protected void initFirewallThreads() {
        Gateway gateway = (Gateway)this.getSystemSoftware().getKnoten();
        this.addAndStartThread(new NatGatewayLANThread(this, gateway.holeLANInterface(), gateway.holeWANInterface(), this.betriebssystem));
        this.addAndStartThread(new NatGatewayWANThread(this, gateway.holeWANInterface(), gateway.holeLANInterface(), this.betriebssystem));
        LOG.debug("Threads for WAN and LAN nic are started on {}", (Object)gateway.getName());
    }

    public void insertNewConnection(int protocol, String lanIpAddress, int lanPort, String wanIpAddress, int wanPort) {
        InetAddress lanAddress = new InetAddress(lanIpAddress, lanPort, protocol);
        Gateway gateway = (Gateway)this.getSystemSoftware().getKnoten();
        if (!this.natTable.hasConnection(lanAddress)) {
            int port = 0;
            if (protocol == 6) {
                port = this.getSystemSoftware().holeTcp().reserviereFreienPort();
            } else if (protocol == 17) {
                port = this.getSystemSoftware().holeUdp().reserviereFreienPort();
            }
            LOG.debug("New connection in NAT table: protocol={}, port={}, address={}", protocol, port, lanAddress);
            this.natTable.addDynamic(port, wanIpAddress, protocol, lanAddress, NatType.DynamicEntry);
            this.natTable.print();
            ((GatewayFirmware)gateway.getSystemSoftware()).fireNATPropertyChange();
        }
    }

    public void replaceSource(IpPaket packet) {
        Gateway gateway = (Gateway)this.getSystemSoftware().getKnoten();
        if (packet.getProtocol() == 6 || packet.getProtocol() == 17) {
            InetAddress lanAddress = new InetAddress(packet.getSender(), packet.getSegment().getQuellPort(), packet.getProtocol());
            int port = this.natTable.findPort(lanAddress);
            packet.getSegment().setQuellPort(port);
        }
        packet.setSender(gateway.holeWANInterface().getIp());
    }

    public void replaceDestination(IpPaket packet) {
        int protocol = packet.getProtocol();
        int port = protocol == 6 || protocol == 17 ? packet.getSegment().getZielPort() : 0;
        String sender = protocol == 6 || protocol == 17 ? packet.getSender() : "";
        InetAddress dest = this.natTable.find(port, sender, protocol);
        Gateway gateway = (Gateway)this.getSystemSoftware().getKnoten();
        ((GatewayFirmware)gateway.getSystemSoftware()).fireNATPropertyChange();
        if (dest != null) {
            packet.setEmpfaenger(dest.getIpAddress());
            if (packet.getProtocol() == 6 || packet.getProtocol() == 17) {
                packet.getSegment().setZielPort(dest.getPort());
            }
        }
    }

    public NetworkAddressTranslationTable getNATTable() {
        return this.natTable;
    }

    public boolean eintragExistiert(IpPaket packet) {
        int protocol = packet.getProtocol();
        int port = protocol == 6 || protocol == 17 ? packet.getSegment().getZielPort() : 0;
        String sender = protocol == 6 || protocol == 17 ? packet.getSender() : "";
        return this.natTable.find(port, sender, protocol) != null;
    }
}

