/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.firewall.FirewallThread;
import filius.software.nat.NatGateway;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SystemSoftware;
import filius.software.transportschicht.TcpSegment;
import filius.software.transportschicht.UdpSegment;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;

public class NatGatewayLANThread
extends FirewallThread
implements I18n {
    private NatGateway natGateway;
    private NetzwerkInterface lanNic;
    private NetzwerkInterface wanNic;

    public NatGatewayLANThread(NatGateway natGateway, NetzwerkInterface nic, NetzwerkInterface wanNic, SystemSoftware systemSoftware) {
        super(natGateway, nic, systemSoftware);
        this.lanNic = nic;
        this.wanNic = wanNic;
        this.natGateway = natGateway;
    }

    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame frame) {
        Lauscher.getLauscher().addDatenEinheit(this.lanNic, this.systemSoftware, frame);
        if (!this.checkDiscardByFirewall(frame) && !this.checkTTLExceeded(frame)) {
            this.updateNatTable(frame);
            EthernetFrame modifiedFrame = this.modifyOutgoingFrame(frame);
            this.forwardFrame(modifiedFrame);
        }
    }

    boolean checkTTLExceeded(EthernetFrame frame) {
        IpPaket packet;
        boolean exceeded = false;
        if (frame.getDaten() instanceof IpPaket && (packet = (IpPaket)frame.getDaten()).getTtl() <= 1 && this.isOutgoingPacket(packet)) {
            int seqNo = 0;
            if (packet instanceof IcmpPaket) {
                seqNo = ((IcmpPaket)packet).getSeqNr();
            }
            this.natGateway.getSystemSoftware().holeICMP().sendeTimeExceededReply(packet.getSender(), seqNo);
            exceeded = true;
        }
        return exceeded;
    }

    protected EthernetFrame modifyOutgoingFrame(EthernetFrame frame) {
        IpPaket packet;
        EthernetFrame modifiedFrame = frame.clone();
        if (modifiedFrame.getDaten() instanceof IpPaket && !((IpPaket)modifiedFrame.getDaten()).getEmpfaenger().equals(this.wanNic.getIp()) && this.isOutgoingPacket(packet = (IpPaket)modifiedFrame.getDaten())) {
            this.natGateway.replaceSource(packet);
        }
        return modifiedFrame;
    }

    protected void updateNatTable(EthernetFrame frame) {
        IpPaket packet;
        if (frame.getDaten() instanceof IpPaket && this.isOutgoingPacket(packet = (IpPaket)frame.getDaten())) {
            if (packet.getSegment() instanceof TcpSegment) {
                TcpSegment tcpSegment = (TcpSegment)packet.getSegment();
                if (tcpSegment.isSyn() && !tcpSegment.isAck()) {
                    this.natGateway.insertNewConnection(packet.getProtocol(), packet.getSender(), tcpSegment.getQuellPort(), packet.getEmpfaenger(), tcpSegment.getZielPort());
                }
            } else if (packet.getSegment() instanceof UdpSegment) {
                UdpSegment udpSegment = (UdpSegment)packet.getSegment();
                this.natGateway.insertNewConnection(packet.getProtocol(), packet.getSender(), udpSegment.getQuellPort(), packet.getEmpfaenger(), udpSegment.getZielPort());
            } else if (packet.getProtocol() == 1) {
                this.natGateway.insertNewConnection(packet.getProtocol(), packet.getSender(), 0, packet.getEmpfaenger(), 0);
            }
        }
    }

    protected boolean isOutgoingPacket(IpPaket packet) {
        return !VermittlungsProtokoll.gleichesRechnernetz(packet.getEmpfaenger(), this.lanNic.getIp(), this.lanNic.getSubnetzMaske()) && !VermittlungsProtokoll.isBroadcast(packet.getEmpfaenger(), packet.getSender(), this.lanNic.getSubnetzMaske()) && !packet.getEmpfaenger().equals(this.wanNic.getIp());
    }
}

