/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.firewall.FirewallThread;
import filius.software.nat.NatGateway;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.IpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatGatewayWANThread
extends FirewallThread
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(NatGatewayWANThread.class);
    private NatGateway natGateway;
    private NetzwerkInterface lanNic;
    private NetzwerkInterface wanNic;

    public NatGatewayWANThread(NatGateway natGateway, NetzwerkInterface nic, NetzwerkInterface lanNic, SystemSoftware systemSoftware) {
        super(natGateway, nic, systemSoftware);
        this.natGateway = natGateway;
        this.wanNic = nic;
        this.lanNic = lanNic;
    }

    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame frame) {
        Lauscher.getLauscher().addDatenEinheit(this.wanNic, this.systemSoftware, frame);
        boolean applyNATForwarding = true;
        if (frame.getDaten() instanceof IpPaket) {
            IpPaket packet = (IpPaket)frame.getDaten();
            applyNATForwarding = this.natGateway.eintragExistiert(packet);
        }
        if (this.checkToLANAddress(frame)) {
            LOG.debug("Discarded frame addressed to LAN address but received on WAN port: {}", (Object)frame);
        } else if (this.checkDiscardByFirewall(frame)) {
            LOG.debug("Discarded frame by firewall: {}", (Object)frame);
        } else if (applyNATForwarding) {
            this.forwardFrame(this.modifyIncomingFrame(frame));
        } else {
            this.forwardFrame(frame);
        }
    }

    private EthernetFrame modifyIncomingFrame(EthernetFrame frame) {
        IpPaket packet;
        EthernetFrame modifiedFrame = frame.clone();
        if (modifiedFrame.getDaten() instanceof IpPaket && (packet = (IpPaket)modifiedFrame.getDaten()).getEmpfaenger().contentEquals(this.wanNic.getIp())) {
            this.natGateway.replaceDestination(packet);
        }
        return modifiedFrame;
    }

    private boolean checkToLANAddress(EthernetFrame frame) {
        IpPaket packet;
        boolean toLANAddress = false;
        if (null != this.lanNic && frame.getDaten() instanceof IpPaket && VermittlungsProtokoll.gleichesRechnernetz((packet = (IpPaket)frame.getDaten()).getEmpfaenger(), this.lanNic.getIp(), this.lanNic.getSubnetzMaske())) {
            toLANAddress = true;
        }
        return toLANAddress;
    }
}

