/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.software.nat.InetAddress;
import filius.software.nat.NatEntry;
import filius.software.nat.NatType;
import filius.software.nat.PortProtocolPair;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressTranslationTable {
    private static Logger LOG = LoggerFactory.getLogger(NetworkAddressTranslationTable.class);
    private ConcurrentHashMap<PortProtocolPair, NatEntry> dynamicNATTable = new ConcurrentHashMap();
    private Map<PortProtocolPair, NatEntry> staticNATTable = new HashMap<PortProtocolPair, NatEntry>();

    public Map<PortProtocolPair, NatEntry> getStaticNATTable() {
        return Collections.unmodifiableMap(this.staticNATTable);
    }

    public ConcurrentHashMap<PortProtocolPair, NatEntry> getDynamicNATTable() {
        return this.dynamicNATTable;
    }

    public void setStaticNATTable(Map<PortProtocolPair, NatEntry> staticNATTable) {
        this.staticNATTable = new HashMap<PortProtocolPair, NatEntry>(staticNATTable);
    }

    public void resetStaticNATTable() {
        this.staticNATTable.clear();
    }

    void addDynamic(int port, String wanAddress, int protocol, InetAddress lanAddress, NatType natType) {
        if (lanAddress != null) {
            NatEntry entry = new NatEntry();
            entry.setInetAddress(lanAddress);
            entry.setNatType(natType);
            entry.setLastUpdate(new Date());
            this.dynamicNATTable.put(new PortProtocolPair(protocol == 1 ? "" : wanAddress, port, protocol), entry);
        }
    }

    public void addStatic(int port, int protocol, InetAddress lanAddress) {
        if (lanAddress != null) {
            NatEntry entry = new NatEntry();
            entry.setInetAddress(lanAddress);
            entry.setNatType(NatType.StaticEntry);
            this.staticNATTable.put(new PortProtocolPair("", port, protocol), entry);
        }
    }

    public InetAddress find(int port, String address, int protocol) {
        PortProtocolPair lookup = new PortProtocolPair(address, port, protocol);
        NatEntry natEntry = this.dynamicNATTable.get(lookup);
        InetAddress IpAddress = null;
        if (natEntry == null) {
            lookup = new PortProtocolPair("", port, protocol);
            natEntry = this.staticNATTable.get(lookup);
            if (natEntry != null) {
                IpAddress = natEntry.getInetAddress();
                this.addDynamic(port, address, protocol, IpAddress, NatType.DynamicEnryFromStatic);
            }
        } else {
            natEntry.setLastUpdate(new Date());
            IpAddress = natEntry.getInetAddress();
        }
        return IpAddress;
    }

    public boolean hasConnection(InetAddress lanAddress) {
        boolean exists = false;
        for (PortProtocolPair key : this.dynamicNATTable.keySet()) {
            if (!this.dynamicNATTable.get(key).getInetAddress().equals(lanAddress)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            for (PortProtocolPair key : this.staticNATTable.keySet()) {
                if (!this.staticNATTable.get(key).getInetAddress().equals(lanAddress)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public int findPort(InetAddress lanAddress) {
        int port = 0;
        for (PortProtocolPair key : this.dynamicNATTable.keySet()) {
            if (!this.dynamicNATTable.get(key).getInetAddress().equals(lanAddress)) continue;
            port = key.getPort();
            break;
        }
        if (port == 0) {
            for (PortProtocolPair key : this.staticNATTable.keySet()) {
                if (!this.staticNATTable.get(key).getInetAddress().equals(lanAddress)) continue;
                port = key.getPort();
                break;
            }
        }
        return port;
    }

    public void print() {
        for (Map.Entry<PortProtocolPair, NatEntry> natEntry : this.staticNATTable.entrySet()) {
            LOG.debug("{} -> {}", (Object)natEntry.getKey(), (Object)natEntry.getValue());
        }
        for (Map.Entry<PortProtocolPair, NatEntry> entry : this.dynamicNATTable.entrySet()) {
            LOG.debug("{} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }
}

