/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.InternetKnoten;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.ProtocolDataUnit;
import filius.software.Protokoll;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.netzzugangsschicht.EthernetThread;
import filius.software.system.SystemSoftware;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.ArrayList;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ethernet
extends Protokoll {
    private static Logger LOG = LoggerFactory.getLogger(Ethernet.class);
    public static final String ETHERNET_BROADCAST = "FF:FF:FF:FF:FF:FF";
    private LinkedList<EthernetThread> threads = new LinkedList();
    private LinkedList<ArpPaket> arpPakete = new LinkedList();
    private LinkedList<IpPaket> ipPakete = new LinkedList();
    private LinkedList<IcmpPaket> icmpPakete = new LinkedList();

    public Ethernet(SystemSoftware systemSoftware) {
        super(systemSoftware);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Ethernet), constr: Ethernet(" + String.valueOf(systemSoftware) + ")");
    }

    public LinkedList<ArpPaket> holeARPPuffer() {
        return this.arpPakete;
    }

    public LinkedList<IpPaket> holeIPPuffer() {
        return this.ipPakete;
    }

    public LinkedList<IcmpPaket> holeICMPPuffer() {
        return this.icmpPakete;
    }

    public void setzeIPPuffer(LinkedList<IpPaket> puffer) {
        this.ipPakete = puffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void senden(ProtocolDataUnit daten, String startMAC, String zielMAC, String typ, NetzwerkInterface useNic) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Ethernet), senden(" + String.valueOf(daten) + "," + startMAC + "," + zielMAC + "," + typ + ")");
        EthernetFrame ethernetFrame = new EthernetFrame(daten, startMAC, zielMAC, typ);
        ArrayList<NetzwerkInterface> senderNICs = new ArrayList<NetzwerkInterface>();
        if (null != useNic) {
            LOG.trace("Ethernet: send via specific nic {}", (Object)useNic);
            senderNICs.add(useNic);
        }
        if (senderNICs.isEmpty()) {
            for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
                if (!nic.getMac().equalsIgnoreCase(zielMAC)) continue;
                LOG.error("Ethernet: send via nic selected by target MAC ({})", (Object)zielMAC);
                senderNICs.add(nic);
            }
        }
        if (senderNICs.isEmpty()) {
            for (NetzwerkInterface nic : ((InternetKnoten)this.holeSystemSoftware().getKnoten()).getNetzwerkInterfaces()) {
                if (!nic.getMac().equalsIgnoreCase(startMAC)) continue;
                senderNICs.add(nic);
            }
        }
        for (NetzwerkInterface nic : senderNICs) {
            LinkedList<EthernetFrame> linkedList = nic.getPort().holeAusgangsPuffer();
            synchronized (linkedList) {
                nic.getPort().holeAusgangsPuffer().add(ethernetFrame);
                nic.getPort().holeAusgangsPuffer().notify();
            }
            Lauscher.getLauscher().addDatenEinheit(nic, this.holeSystemSoftware(), ethernetFrame);
        }
    }

    public LinkedList<EthernetThread> getEthernetThreads() {
        return this.threads;
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Ethernet), starten()");
        if (this.arpPakete.size() > 0) {
            LOG.debug("Clear ARP buffer. Still data left from last run.");
            this.arpPakete.clear();
        }
        if (this.icmpPakete.size() > 0) {
            LOG.debug("Clear ICMP buffer. Still data left from last run.");
            this.icmpPakete.clear();
        }
        if (this.ipPakete.size() > 0) {
            LOG.debug("Clear IP buffer. Still data left from last run.");
            this.ipPakete.clear();
        }
        if (this.holeSystemSoftware().getKnoten() instanceof InternetKnoten) {
            InternetKnoten knoten = (InternetKnoten)this.holeSystemSoftware().getKnoten();
            for (NetzwerkInterface nic : knoten.getNetzwerkInterfaces()) {
                EthernetThread interfaceBeobachter = new EthernetThread(this, nic, this.holeSystemSoftware());
                interfaceBeobachter.starten();
                try {
                    this.threads.add(interfaceBeobachter);
                }
                catch (Exception e) {
                    LOG.debug("", e);
                }
            }
        }
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (Ethernet), beenden()");
        for (int x = 0; x < this.threads.size(); ++x) {
            EthernetThread interfaceBeobachter = this.threads.get(x);
            interfaceBeobachter.beenden();
        }
    }
}

