/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.software.ProtocolDataUnit;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetFrame
extends ProtocolDataUnit {
    private static Logger LOG = LoggerFactory.getLogger(EthernetFrame.class);
    private static final long serialVersionUID = 1L;
    public static final String IP = "0x800";
    public static final String ARP = "0x806";
    private String zielMacAdresse;
    private String quellMacAdresse;
    private String typ;
    private ProtocolDataUnit daten;
    private Set<String> readByLauscherForMac = new HashSet<String>();

    public EthernetFrame(ProtocolDataUnit daten, String quellMacAdresse, String zielMacAdresse, String typ) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + String.valueOf(this.getClass()) + " (EthernetFrame), constr: EthernetFrame(" + String.valueOf(daten) + "," + quellMacAdresse + "," + zielMacAdresse + "," + typ + ")");
        this.zielMacAdresse = zielMacAdresse;
        this.quellMacAdresse = quellMacAdresse;
        this.typ = typ;
        this.daten = daten;
    }

    public EthernetFrame clone() {
        ProtocolDataUnit clonedData = this.daten instanceof IcmpPaket ? ((IcmpPaket)this.daten).clone() : (this.daten instanceof IpPaket ? ((IpPaket)this.daten).clone() : this.daten);
        EthernetFrame clonedFrame = new EthernetFrame(clonedData, this.quellMacAdresse, this.zielMacAdresse, this.typ);
        clonedFrame.readByLauscherForMac = this.readByLauscherForMac;
        clonedFrame.setRcvNic(this.getRcvNic());
        return clonedFrame;
    }

    public void setReadByLauscherForMac(String mac) {
        this.readByLauscherForMac.add(mac);
    }

    public boolean isReadByLauscherForMac(String mac) {
        return this.readByLauscherForMac.contains(mac);
    }

    public ProtocolDataUnit getDaten() {
        return this.daten;
    }

    public String getQuellMacAdresse() {
        return this.quellMacAdresse;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getZielMacAdresse() {
        return this.zielMacAdresse;
    }

    public String toString() {
        return "[src=" + this.quellMacAdresse + ", dest=" + this.zielMacAdresse + ", type=" + this.typ + (String)(this.daten != null ? " | " + String.valueOf(this.daten) : "") + "]";
    }

    public boolean sameContent(EthernetFrame frame) {
        if (frame == this) {
            return true;
        }
        if (this.zielMacAdresse.equals(frame.getZielMacAdresse()) && this.quellMacAdresse.equals(frame.getQuellMacAdresse()) && this.typ.equals(frame.getTyp())) {
            ProtocolDataUnit argumentData = frame.getDaten();
            if (this.daten instanceof IpPaket && argumentData instanceof IpPaket) {
                IpPaket argumentPacket = (IpPaket)argumentData;
                IpPaket thisPacket = (IpPaket)this.daten;
                return thisPacket.getIdentification() == argumentPacket.getIdentification() && thisPacket.getTtl() == argumentPacket.getTtl();
            }
            if (this.daten instanceof ArpPaket && argumentData instanceof ArpPaket) {
                ArpPaket thisArpPacket = (ArpPaket)this.daten;
                ArpPaket argumentArpPacket = (ArpPaket)frame.getDaten();
                return thisArpPacket.getArpPacketNumber() == argumentArpPacket.getArpPacketNumber();
            }
            return false;
        }
        return false;
    }

    public boolean samePayload(EthernetFrame frame, int ttl) {
        ProtocolDataUnit framePayload = frame.getDaten();
        if (this.daten instanceof IpPaket && framePayload instanceof IpPaket) {
            if (!(this.daten instanceof IcmpPaket) && !(framePayload instanceof IcmpPaket)) {
                IpPaket thisIpPacket = (IpPaket)this.daten;
                IpPaket argumentIpPacket = (IpPaket)framePayload;
                return thisIpPacket.getIdentification() == argumentIpPacket.getIdentification() && thisIpPacket.getTtl() == ttl;
            }
            if (this.daten instanceof IcmpPaket && framePayload instanceof IcmpPaket) {
                IcmpPaket thisIcmpPacket = (IcmpPaket)this.daten;
                IcmpPaket argumentIcmpPacket = (IcmpPaket)framePayload;
                return thisIcmpPacket.getIdentification() == argumentIcmpPacket.getIdentification() && thisIcmpPacket.getTtl() == ttl;
            }
            return false;
        }
        return false;
    }
}

